/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EncodeForUri;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.UnparsedText;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.UnparsedTextIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntPredicate;

public class UnparsedTextLines
extends UnparsedTextFunction
implements Callable {
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue hrefVal = (StringValue)arguments[0].head();
        String encoding = this.getArity() == 2 ? arguments[1].head().getStringValue() : null;
        return SequenceTool.toLazySequence(this.evalUnparsedTextLines(hrefVal, encoding, context));
    }

    private SequenceIterator evalUnparsedTextLines(StringValue hrefVal, String encoding, XPathContext context) throws XPathException {
        if (hrefVal == null) {
            return EmptyIterator.emptyIterator();
        }
        String href = hrefVal.getStringValue();
        boolean stable = context.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/stableUnparsedText");
        if (stable) {
            StringValue content = UnparsedText.evalUnparsedText(hrefVal, this.getStaticBaseUriString(), encoding, context);
            URI abs = UnparsedTextLines.getAbsoluteURI(href, this.getStaticBaseUriString());
            LineNumberReader reader = new LineNumberReader(new StringReader(content.getStringValue()));
            return new UnparsedTextIterator(reader, abs, context, encoding);
        }
        URI absoluteURI = UnparsedTextLines.getAbsoluteURI(href, this.getRetainedStaticContext().getStaticBaseUriString());
        return new UnparsedTextIterator(absoluteURI, context, encoding, null);
    }

    public CharSequence readFile(String href, String baseURI, String encoding, XPathContext context) throws XPathException {
        Reader reader;
        Configuration config = context.getConfiguration();
        IntPredicate checker = config.getValidCharacterChecker();
        URI absoluteURI = UnparsedTextLines.getAbsoluteURI(href, baseURI);
        try {
            reader = context.getController().getUnparsedTextURIResolver().resolve(absoluteURI, encoding, config);
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("FOUT1170");
            throw err;
        }
        try {
            return UnparsedTextLines.readFile(checker, reader);
        }
        catch (UnsupportedEncodingException encErr) {
            XPathException e = new XPathException("Unknown encoding " + Err.wrap(encoding), encErr);
            e.setErrorCode("FOUT1190");
            throw e;
        }
        catch (IOException ioErr) {
            throw UnparsedTextLines.handleIOError(absoluteURI, ioErr);
        }
    }

    public static URI getAbsoluteURI(String href, String baseURI) throws XPathException {
        URI absoluteURI;
        try {
            absoluteURI = ResolveURI.makeAbsolute(href, baseURI);
        }
        catch (URISyntaxException err) {
            XPathException e = new XPathException(err.getReason() + ": " + err.getInput(), err);
            e.setErrorCode("FOUT1170");
            throw e;
        }
        if (absoluteURI.getFragment() != null) {
            XPathException e = new XPathException("URI for unparsed-text() must not contain a fragment identifier");
            e.setErrorCode("FOUT1170");
            throw e;
        }
        EncodeForUri.checkPercentEncoding(absoluteURI.toString());
        return absoluteURI;
    }

    public static XPathException handleIOError(URI absoluteURI, IOException ioErr) {
        String message = "Failed to read input file";
        if (!ioErr.getMessage().equals(absoluteURI.toString())) {
            message = message + ' ' + absoluteURI.toString();
        }
        message = message + " (" + ioErr.getClass().getName() + ')';
        XPathException e = new XPathException(message, ioErr);
        String errorCode = ioErr instanceof MalformedInputException ? "FOUT1200" : (ioErr instanceof CharacterCodingException ? "FOUT1200" : (ioErr instanceof UnmappableCharacterException ? "FOUT1190" : "FOUT1170"));
        e.setErrorCode(errorCode);
        return e;
    }

    public static CharSequence readFile(IntPredicate checker, Reader reader) throws IOException, XPathException {
        int actual;
        FastStringBuffer sb = new FastStringBuffer(2048);
        char[] buffer = new char[2048];
        boolean first = true;
        int line = 1;
        int column = 1;
        while ((actual = reader.read(buffer, 0, 2048)) >= 0) {
            int c = 0;
            while (c < actual) {
                int ch32;
                if ((ch32 = buffer[c++]) == 10) {
                    ++line;
                    column = 0;
                }
                ++column;
                if (UTF16CharacterSet.isHighSurrogate(ch32)) {
                    if (c == actual) {
                        actual = reader.read(buffer, 0, 2048);
                        c = 0;
                    }
                    char low = buffer[c++];
                    ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
                }
                if (checker.matches(ch32)) continue;
                XPathException err = new XPathException("The unparsed-text file contains a character that is illegal in XML (line=" + line + " column=" + column + " value=hex " + Integer.toHexString(ch32) + ')');
                err.setErrorCode("FOUT1190");
                throw err;
            }
            if (first) {
                first = false;
                if (buffer[0] == '\ufeff') {
                    sb.append(buffer, 1, actual - 1);
                    continue;
                }
                sb.append(buffer, 0, actual);
                continue;
            }
            sb.append(buffer, 0, actual);
        }
        reader.close();
        return sb.condense();
    }

    public static void main(String[] args) throws Exception {
        FastStringBuffer sb1 = new FastStringBuffer(256);
        FastStringBuffer sb2 = new FastStringBuffer(256);
        File file = new File(args[0]);
        FileInputStream is = new FileInputStream(file);
        while (true) {
            int b;
            if ((b = ((InputStream)is).read()) < 0) break;
            sb1.append(Integer.toHexString(b) + " ");
            sb2.append((char)b + " ");
            if (sb1.length() <= 80) continue;
            System.out.println(sb1.toString());
            System.out.println(sb2.toString());
            sb1 = new FastStringBuffer(256);
            sb2 = new FastStringBuffer(256);
        }
        System.out.println(sb1.toString());
        System.out.println(sb2.toString());
        ((InputStream)is).close();
    }
}

