# This Makefile.PL for Archive-Tar-Wrapper was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.008001;
use ExtUtils::MakeMaker;

if ( $^O eq 'MSWin32' ) {
    require Win32;
    require File::Which;
    my $product_info = Win32::GetOSDisplayName();
    my ( $osvername, $major, $minor, $id ) = Win32::GetOSVersion();
    print "Running on $product_info - major=$major, minor=$minor, id=$id\n";

    unless ( $major >= 6 ) {
        warn
"Too old Microsoft Windows to be supported, major version must be equal or higher 6.\n";
        die "OS unsupported\n";
    }

    # double quoting is required on Windows if there are spaces in the path
    my $tar_path = File::Which::which('bsdtar.exe');
    $tar_path = File::Which::which('tar') unless ( defined($tar_path) );

    unless ( defined($tar_path) ) {
        warn "No tar program available, cannot work without it.\n";
        die "OS unsupported\n";
    }
    else {
        my $version_info = `"$tar_path" --version`;
        print "Using $tar_path $version_info\n";

        if ( $version_info =~ /GNU/ ) {
            warn
"Sorry, GNU tar is not supported on Microsoft Windows. Install a BSD tar or check your PATH configuration\n";
            die "OS unsupported\n";
        }
    }
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "API wrapper around the 'tar' utility",
  "AUTHOR" => "Mike Schilli <cpan\@perlmeister.com>, Alceu Rodrigues de Freitas Junior <glasswalk3r\@yahoo.com.br>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Which" => 0
  },
  "DISTNAME" => "Archive-Tar-Wrapper",
  "LICENSE" => "gpl",
  "MIN_PERL_VERSION" => "5.008001",
  "NAME" => "Archive::Tar::Wrapper",
  "PREREQ_PM" => {
    "Cwd" => 0,
    "File::Temp" => 0,
    "File::Which" => 0,
    "IPC::Run" => 0,
    "Log::Log4perl" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Test::More" => 0
  },
  "VERSION" => "0.42",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Cwd" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "File::Temp" => 0,
  "File::Which" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "IPC::Run" => 0,
  "Log::Log4perl" => 0,
  "Test::More" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
