use strict;
use warnings;
use Test::More tests => 1 + 256 * 4 + 1;
use Test::Differences;
use Parse::ANSIColor::Tiny;

my $p = new_ok('Parse::ANSIColor::Tiny');

my $chart = do { local $/; <DATA>; };
my $parsed = $p->parse($chart);

sub expect {
  for my $prefix ( '', 'on_' ){
    my $name = $prefix . $_[0];
    eq_or_diff shift(@$parsed), [ [$name], $name ];
    is_deeply  shift(@$parsed), [ [], "\n" ], "newline";
  }
}

do {
  for my $i ( 0 .. 15 ){
    expect "ansi$i";
  }
  for my $r ( 0 .. 5 ) {
    for my $g ( 0 .. 5 ) {
      for my $b ( 0 .. 5 ) {
        expect "rgb$r$g$b";
      }
    }
  }
  for my $i ( 0 .. 23 ){
    expect "grey$i";
  }
};

is_deeply $parsed, [], 'all checked';

# perl -MTerm::ANSIColor -le 'sub p { print colored(("$_$_[0]") x 2) for ("", "on_") } for $i ( 0 .. 15 ){ p "ansi$i" } for $r ( 0 .. 5 ) { for $g ( 0 .. 5 ) { for $b ( 0 .. 5 ) { p "rgb${r}${g}${b}" } } } for $i ( 0 .. 23 ){ p "grey$i" }'

__DATA__
[38;5;0mansi0[0m
[48;5;0mon_ansi0[0m
[38;5;1mansi1[0m
[48;5;1mon_ansi1[0m
[38;5;2mansi2[0m
[48;5;2mon_ansi2[0m
[38;5;3mansi3[0m
[48;5;3mon_ansi3[0m
[38;5;4mansi4[0m
[48;5;4mon_ansi4[0m
[38;5;5mansi5[0m
[48;5;5mon_ansi5[0m
[38;5;6mansi6[0m
[48;5;6mon_ansi6[0m
[38;5;7mansi7[0m
[48;5;7mon_ansi7[0m
[38;5;8mansi8[0m
[48;5;8mon_ansi8[0m
[38;5;9mansi9[0m
[48;5;9mon_ansi9[0m
[38;5;10mansi10[0m
[48;5;10mon_ansi10[0m
[38;5;11mansi11[0m
[48;5;11mon_ansi11[0m
[38;5;12mansi12[0m
[48;5;12mon_ansi12[0m
[38;5;13mansi13[0m
[48;5;13mon_ansi13[0m
[38;5;14mansi14[0m
[48;5;14mon_ansi14[0m
[38;5;15mansi15[0m
[48;5;15mon_ansi15[0m
[38;5;16mrgb000[0m
[48;5;16mon_rgb000[0m
[38;5;17mrgb001[0m
[48;5;17mon_rgb001[0m
[38;5;18mrgb002[0m
[48;5;18mon_rgb002[0m
[38;5;19mrgb003[0m
[48;5;19mon_rgb003[0m
[38;5;20mrgb004[0m
[48;5;20mon_rgb004[0m
[38;5;21mrgb005[0m
[48;5;21mon_rgb005[0m
[38;5;22mrgb010[0m
[48;5;22mon_rgb010[0m
[38;5;23mrgb011[0m
[48;5;23mon_rgb011[0m
[38;5;24mrgb012[0m
[48;5;24mon_rgb012[0m
[38;5;25mrgb013[0m
[48;5;25mon_rgb013[0m
[38;5;26mrgb014[0m
[48;5;26mon_rgb014[0m
[38;5;27mrgb015[0m
[48;5;27mon_rgb015[0m
[38;5;28mrgb020[0m
[48;5;28mon_rgb020[0m
[38;5;29mrgb021[0m
[48;5;29mon_rgb021[0m
[38;5;30mrgb022[0m
[48;5;30mon_rgb022[0m
[38;5;31mrgb023[0m
[48;5;31mon_rgb023[0m
[38;5;32mrgb024[0m
[48;5;32mon_rgb024[0m
[38;5;33mrgb025[0m
[48;5;33mon_rgb025[0m
[38;5;34mrgb030[0m
[48;5;34mon_rgb030[0m
[38;5;35mrgb031[0m
[48;5;35mon_rgb031[0m
[38;5;36mrgb032[0m
[48;5;36mon_rgb032[0m
[38;5;37mrgb033[0m
[48;5;37mon_rgb033[0m
[38;5;38mrgb034[0m
[48;5;38mon_rgb034[0m
[38;5;39mrgb035[0m
[48;5;39mon_rgb035[0m
[38;5;40mrgb040[0m
[48;5;40mon_rgb040[0m
[38;5;41mrgb041[0m
[48;5;41mon_rgb041[0m
[38;5;42mrgb042[0m
[48;5;42mon_rgb042[0m
[38;5;43mrgb043[0m
[48;5;43mon_rgb043[0m
[38;5;44mrgb044[0m
[48;5;44mon_rgb044[0m
[38;5;45mrgb045[0m
[48;5;45mon_rgb045[0m
[38;5;46mrgb050[0m
[48;5;46mon_rgb050[0m
[38;5;47mrgb051[0m
[48;5;47mon_rgb051[0m
[38;5;48mrgb052[0m
[48;5;48mon_rgb052[0m
[38;5;49mrgb053[0m
[48;5;49mon_rgb053[0m
[38;5;50mrgb054[0m
[48;5;50mon_rgb054[0m
[38;5;51mrgb055[0m
[48;5;51mon_rgb055[0m
[38;5;52mrgb100[0m
[48;5;52mon_rgb100[0m
[38;5;53mrgb101[0m
[48;5;53mon_rgb101[0m
[38;5;54mrgb102[0m
[48;5;54mon_rgb102[0m
[38;5;55mrgb103[0m
[48;5;55mon_rgb103[0m
[38;5;56mrgb104[0m
[48;5;56mon_rgb104[0m
[38;5;57mrgb105[0m
[48;5;57mon_rgb105[0m
[38;5;58mrgb110[0m
[48;5;58mon_rgb110[0m
[38;5;59mrgb111[0m
[48;5;59mon_rgb111[0m
[38;5;60mrgb112[0m
[48;5;60mon_rgb112[0m
[38;5;61mrgb113[0m
[48;5;61mon_rgb113[0m
[38;5;62mrgb114[0m
[48;5;62mon_rgb114[0m
[38;5;63mrgb115[0m
[48;5;63mon_rgb115[0m
[38;5;64mrgb120[0m
[48;5;64mon_rgb120[0m
[38;5;65mrgb121[0m
[48;5;65mon_rgb121[0m
[38;5;66mrgb122[0m
[48;5;66mon_rgb122[0m
[38;5;67mrgb123[0m
[48;5;67mon_rgb123[0m
[38;5;68mrgb124[0m
[48;5;68mon_rgb124[0m
[38;5;69mrgb125[0m
[48;5;69mon_rgb125[0m
[38;5;70mrgb130[0m
[48;5;70mon_rgb130[0m
[38;5;71mrgb131[0m
[48;5;71mon_rgb131[0m
[38;5;72mrgb132[0m
[48;5;72mon_rgb132[0m
[38;5;73mrgb133[0m
[48;5;73mon_rgb133[0m
[38;5;74mrgb134[0m
[48;5;74mon_rgb134[0m
[38;5;75mrgb135[0m
[48;5;75mon_rgb135[0m
[38;5;76mrgb140[0m
[48;5;76mon_rgb140[0m
[38;5;77mrgb141[0m
[48;5;77mon_rgb141[0m
[38;5;78mrgb142[0m
[48;5;78mon_rgb142[0m
[38;5;79mrgb143[0m
[48;5;79mon_rgb143[0m
[38;5;80mrgb144[0m
[48;5;80mon_rgb144[0m
[38;5;81mrgb145[0m
[48;5;81mon_rgb145[0m
[38;5;82mrgb150[0m
[48;5;82mon_rgb150[0m
[38;5;83mrgb151[0m
[48;5;83mon_rgb151[0m
[38;5;84mrgb152[0m
[48;5;84mon_rgb152[0m
[38;5;85mrgb153[0m
[48;5;85mon_rgb153[0m
[38;5;86mrgb154[0m
[48;5;86mon_rgb154[0m
[38;5;87mrgb155[0m
[48;5;87mon_rgb155[0m
[38;5;88mrgb200[0m
[48;5;88mon_rgb200[0m
[38;5;89mrgb201[0m
[48;5;89mon_rgb201[0m
[38;5;90mrgb202[0m
[48;5;90mon_rgb202[0m
[38;5;91mrgb203[0m
[48;5;91mon_rgb203[0m
[38;5;92mrgb204[0m
[48;5;92mon_rgb204[0m
[38;5;93mrgb205[0m
[48;5;93mon_rgb205[0m
[38;5;94mrgb210[0m
[48;5;94mon_rgb210[0m
[38;5;95mrgb211[0m
[48;5;95mon_rgb211[0m
[38;5;96mrgb212[0m
[48;5;96mon_rgb212[0m
[38;5;97mrgb213[0m
[48;5;97mon_rgb213[0m
[38;5;98mrgb214[0m
[48;5;98mon_rgb214[0m
[38;5;99mrgb215[0m
[48;5;99mon_rgb215[0m
[38;5;100mrgb220[0m
[48;5;100mon_rgb220[0m
[38;5;101mrgb221[0m
[48;5;101mon_rgb221[0m
[38;5;102mrgb222[0m
[48;5;102mon_rgb222[0m
[38;5;103mrgb223[0m
[48;5;103mon_rgb223[0m
[38;5;104mrgb224[0m
[48;5;104mon_rgb224[0m
[38;5;105mrgb225[0m
[48;5;105mon_rgb225[0m
[38;5;106mrgb230[0m
[48;5;106mon_rgb230[0m
[38;5;107mrgb231[0m
[48;5;107mon_rgb231[0m
[38;5;108mrgb232[0m
[48;5;108mon_rgb232[0m
[38;5;109mrgb233[0m
[48;5;109mon_rgb233[0m
[38;5;110mrgb234[0m
[48;5;110mon_rgb234[0m
[38;5;111mrgb235[0m
[48;5;111mon_rgb235[0m
[38;5;112mrgb240[0m
[48;5;112mon_rgb240[0m
[38;5;113mrgb241[0m
[48;5;113mon_rgb241[0m
[38;5;114mrgb242[0m
[48;5;114mon_rgb242[0m
[38;5;115mrgb243[0m
[48;5;115mon_rgb243[0m
[38;5;116mrgb244[0m
[48;5;116mon_rgb244[0m
[38;5;117mrgb245[0m
[48;5;117mon_rgb245[0m
[38;5;118mrgb250[0m
[48;5;118mon_rgb250[0m
[38;5;119mrgb251[0m
[48;5;119mon_rgb251[0m
[38;5;120mrgb252[0m
[48;5;120mon_rgb252[0m
[38;5;121mrgb253[0m
[48;5;121mon_rgb253[0m
[38;5;122mrgb254[0m
[48;5;122mon_rgb254[0m
[38;5;123mrgb255[0m
[48;5;123mon_rgb255[0m
[38;5;124mrgb300[0m
[48;5;124mon_rgb300[0m
[38;5;125mrgb301[0m
[48;5;125mon_rgb301[0m
[38;5;126mrgb302[0m
[48;5;126mon_rgb302[0m
[38;5;127mrgb303[0m
[48;5;127mon_rgb303[0m
[38;5;128mrgb304[0m
[48;5;128mon_rgb304[0m
[38;5;129mrgb305[0m
[48;5;129mon_rgb305[0m
[38;5;130mrgb310[0m
[48;5;130mon_rgb310[0m
[38;5;131mrgb311[0m
[48;5;131mon_rgb311[0m
[38;5;132mrgb312[0m
[48;5;132mon_rgb312[0m
[38;5;133mrgb313[0m
[48;5;133mon_rgb313[0m
[38;5;134mrgb314[0m
[48;5;134mon_rgb314[0m
[38;5;135mrgb315[0m
[48;5;135mon_rgb315[0m
[38;5;136mrgb320[0m
[48;5;136mon_rgb320[0m
[38;5;137mrgb321[0m
[48;5;137mon_rgb321[0m
[38;5;138mrgb322[0m
[48;5;138mon_rgb322[0m
[38;5;139mrgb323[0m
[48;5;139mon_rgb323[0m
[38;5;140mrgb324[0m
[48;5;140mon_rgb324[0m
[38;5;141mrgb325[0m
[48;5;141mon_rgb325[0m
[38;5;142mrgb330[0m
[48;5;142mon_rgb330[0m
[38;5;143mrgb331[0m
[48;5;143mon_rgb331[0m
[38;5;144mrgb332[0m
[48;5;144mon_rgb332[0m
[38;5;145mrgb333[0m
[48;5;145mon_rgb333[0m
[38;5;146mrgb334[0m
[48;5;146mon_rgb334[0m
[38;5;147mrgb335[0m
[48;5;147mon_rgb335[0m
[38;5;148mrgb340[0m
[48;5;148mon_rgb340[0m
[38;5;149mrgb341[0m
[48;5;149mon_rgb341[0m
[38;5;150mrgb342[0m
[48;5;150mon_rgb342[0m
[38;5;151mrgb343[0m
[48;5;151mon_rgb343[0m
[38;5;152mrgb344[0m
[48;5;152mon_rgb344[0m
[38;5;153mrgb345[0m
[48;5;153mon_rgb345[0m
[38;5;154mrgb350[0m
[48;5;154mon_rgb350[0m
[38;5;155mrgb351[0m
[48;5;155mon_rgb351[0m
[38;5;156mrgb352[0m
[48;5;156mon_rgb352[0m
[38;5;157mrgb353[0m
[48;5;157mon_rgb353[0m
[38;5;158mrgb354[0m
[48;5;158mon_rgb354[0m
[38;5;159mrgb355[0m
[48;5;159mon_rgb355[0m
[38;5;160mrgb400[0m
[48;5;160mon_rgb400[0m
[38;5;161mrgb401[0m
[48;5;161mon_rgb401[0m
[38;5;162mrgb402[0m
[48;5;162mon_rgb402[0m
[38;5;163mrgb403[0m
[48;5;163mon_rgb403[0m
[38;5;164mrgb404[0m
[48;5;164mon_rgb404[0m
[38;5;165mrgb405[0m
[48;5;165mon_rgb405[0m
[38;5;166mrgb410[0m
[48;5;166mon_rgb410[0m
[38;5;167mrgb411[0m
[48;5;167mon_rgb411[0m
[38;5;168mrgb412[0m
[48;5;168mon_rgb412[0m
[38;5;169mrgb413[0m
[48;5;169mon_rgb413[0m
[38;5;170mrgb414[0m
[48;5;170mon_rgb414[0m
[38;5;171mrgb415[0m
[48;5;171mon_rgb415[0m
[38;5;172mrgb420[0m
[48;5;172mon_rgb420[0m
[38;5;173mrgb421[0m
[48;5;173mon_rgb421[0m
[38;5;174mrgb422[0m
[48;5;174mon_rgb422[0m
[38;5;175mrgb423[0m
[48;5;175mon_rgb423[0m
[38;5;176mrgb424[0m
[48;5;176mon_rgb424[0m
[38;5;177mrgb425[0m
[48;5;177mon_rgb425[0m
[38;5;178mrgb430[0m
[48;5;178mon_rgb430[0m
[38;5;179mrgb431[0m
[48;5;179mon_rgb431[0m
[38;5;180mrgb432[0m
[48;5;180mon_rgb432[0m
[38;5;181mrgb433[0m
[48;5;181mon_rgb433[0m
[38;5;182mrgb434[0m
[48;5;182mon_rgb434[0m
[38;5;183mrgb435[0m
[48;5;183mon_rgb435[0m
[38;5;184mrgb440[0m
[48;5;184mon_rgb440[0m
[38;5;185mrgb441[0m
[48;5;185mon_rgb441[0m
[38;5;186mrgb442[0m
[48;5;186mon_rgb442[0m
[38;5;187mrgb443[0m
[48;5;187mon_rgb443[0m
[38;5;188mrgb444[0m
[48;5;188mon_rgb444[0m
[38;5;189mrgb445[0m
[48;5;189mon_rgb445[0m
[38;5;190mrgb450[0m
[48;5;190mon_rgb450[0m
[38;5;191mrgb451[0m
[48;5;191mon_rgb451[0m
[38;5;192mrgb452[0m
[48;5;192mon_rgb452[0m
[38;5;193mrgb453[0m
[48;5;193mon_rgb453[0m
[38;5;194mrgb454[0m
[48;5;194mon_rgb454[0m
[38;5;195mrgb455[0m
[48;5;195mon_rgb455[0m
[38;5;196mrgb500[0m
[48;5;196mon_rgb500[0m
[38;5;197mrgb501[0m
[48;5;197mon_rgb501[0m
[38;5;198mrgb502[0m
[48;5;198mon_rgb502[0m
[38;5;199mrgb503[0m
[48;5;199mon_rgb503[0m
[38;5;200mrgb504[0m
[48;5;200mon_rgb504[0m
[38;5;201mrgb505[0m
[48;5;201mon_rgb505[0m
[38;5;202mrgb510[0m
[48;5;202mon_rgb510[0m
[38;5;203mrgb511[0m
[48;5;203mon_rgb511[0m
[38;5;204mrgb512[0m
[48;5;204mon_rgb512[0m
[38;5;205mrgb513[0m
[48;5;205mon_rgb513[0m
[38;5;206mrgb514[0m
[48;5;206mon_rgb514[0m
[38;5;207mrgb515[0m
[48;5;207mon_rgb515[0m
[38;5;208mrgb520[0m
[48;5;208mon_rgb520[0m
[38;5;209mrgb521[0m
[48;5;209mon_rgb521[0m
[38;5;210mrgb522[0m
[48;5;210mon_rgb522[0m
[38;5;211mrgb523[0m
[48;5;211mon_rgb523[0m
[38;5;212mrgb524[0m
[48;5;212mon_rgb524[0m
[38;5;213mrgb525[0m
[48;5;213mon_rgb525[0m
[38;5;214mrgb530[0m
[48;5;214mon_rgb530[0m
[38;5;215mrgb531[0m
[48;5;215mon_rgb531[0m
[38;5;216mrgb532[0m
[48;5;216mon_rgb532[0m
[38;5;217mrgb533[0m
[48;5;217mon_rgb533[0m
[38;5;218mrgb534[0m
[48;5;218mon_rgb534[0m
[38;5;219mrgb535[0m
[48;5;219mon_rgb535[0m
[38;5;220mrgb540[0m
[48;5;220mon_rgb540[0m
[38;5;221mrgb541[0m
[48;5;221mon_rgb541[0m
[38;5;222mrgb542[0m
[48;5;222mon_rgb542[0m
[38;5;223mrgb543[0m
[48;5;223mon_rgb543[0m
[38;5;224mrgb544[0m
[48;5;224mon_rgb544[0m
[38;5;225mrgb545[0m
[48;5;225mon_rgb545[0m
[38;5;226mrgb550[0m
[48;5;226mon_rgb550[0m
[38;5;227mrgb551[0m
[48;5;227mon_rgb551[0m
[38;5;228mrgb552[0m
[48;5;228mon_rgb552[0m
[38;5;229mrgb553[0m
[48;5;229mon_rgb553[0m
[38;5;230mrgb554[0m
[48;5;230mon_rgb554[0m
[38;5;231mrgb555[0m
[48;5;231mon_rgb555[0m
[38;5;232mgrey0[0m
[48;5;232mon_grey0[0m
[38;5;233mgrey1[0m
[48;5;233mon_grey1[0m
[38;5;234mgrey2[0m
[48;5;234mon_grey2[0m
[38;5;235mgrey3[0m
[48;5;235mon_grey3[0m
[38;5;236mgrey4[0m
[48;5;236mon_grey4[0m
[38;5;237mgrey5[0m
[48;5;237mon_grey5[0m
[38;5;238mgrey6[0m
[48;5;238mon_grey6[0m
[38;5;239mgrey7[0m
[48;5;239mon_grey7[0m
[38;5;240mgrey8[0m
[48;5;240mon_grey8[0m
[38;5;241mgrey9[0m
[48;5;241mon_grey9[0m
[38;5;242mgrey10[0m
[48;5;242mon_grey10[0m
[38;5;243mgrey11[0m
[48;5;243mon_grey11[0m
[38;5;244mgrey12[0m
[48;5;244mon_grey12[0m
[38;5;245mgrey13[0m
[48;5;245mon_grey13[0m
[38;5;246mgrey14[0m
[48;5;246mon_grey14[0m
[38;5;247mgrey15[0m
[48;5;247mon_grey15[0m
[38;5;248mgrey16[0m
[48;5;248mon_grey16[0m
[38;5;249mgrey17[0m
[48;5;249mon_grey17[0m
[38;5;250mgrey18[0m
[48;5;250mon_grey18[0m
[38;5;251mgrey19[0m
[48;5;251mon_grey19[0m
[38;5;252mgrey20[0m
[48;5;252mon_grey20[0m
[38;5;253mgrey21[0m
[48;5;253mon_grey21[0m
[38;5;254mgrey22[0m
[48;5;254mon_grey22[0m
[38;5;255mgrey23[0m
[48;5;255mon_grey23[0m
