# Generated by default/object.tt
package Paws::LexRuntimeV2::ActiveContextTimeToLive;
  use Moose;
  has TimeToLiveInSeconds => (is => 'ro', isa => 'Int', request_name => 'timeToLiveInSeconds', traits => ['NameInRequest'], required => 1);
  has TurnsToLive => (is => 'ro', isa => 'Int', request_name => 'turnsToLive', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntimeV2::ActiveContextTimeToLive

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntimeV2::ActiveContextTimeToLive object:

  $service_obj->Method(Att1 => { TimeToLiveInSeconds => $value, ..., TurnsToLive => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntimeV2::ActiveContextTimeToLive object:

  $result = $service_obj->Method(...);
  $result->Att1->TimeToLiveInSeconds

=head1 DESCRIPTION

The time that a context is active. You can specify the time to live in
seconds or in conversation turns.

=head1 ATTRIBUTES


=head2 B<REQUIRED> TimeToLiveInSeconds => Int

The number of seconds that the context is active. You can specify
between 5 and 86400 seconds (24 hours).


=head2 B<REQUIRED> TurnsToLive => Int

The number of turns that the context is active. You can specify up to
20 turns. Each request and response from the bot is a turn.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntimeV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

