package Net::Amazon::EMR::ListClustersResult;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Net::Amazon::EMR::ClusterSummary;

has 'Clusters' => ( is => 'ro',
                            isa => 'Net::Amazon::EMR::Type::ArrayRefofClusterSummary',
                            coerce => 1 );

has 'Marker' => ( is => 'ro',
                  isa => 'Str',
              );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::ListClustersResult

=head1 DESCRIPTION

Implements the ListClusters result type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/API/API_ListClusters.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
