/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.hwpf.model.LFO;
import org.apache.poi.hwpf.model.LFOData;
import org.apache.poi.hwpf.model.ListFormatOverrideLevel;
import org.apache.poi.util.Internal;

@Internal
public final class ListFormatOverride {
    private LFO _lfo;
    private LFOData _lfoData;

    public ListFormatOverride(byte[] buf, int offset) {
        this._lfo = new LFO(buf, offset);
    }

    public ListFormatOverride(int lsid) {
        this._lfo = new LFO();
        this._lfo.setLsid(lsid);
    }

    public ListFormatOverrideLevel[] getLevelOverrides() {
        return this._lfoData.getRgLfoLvl();
    }

    LFO getLfo() {
        return this._lfo;
    }

    LFOData getLfoData() {
        return this._lfoData;
    }

    public int getLsid() {
        return this._lfo.getLsid();
    }

    public ListFormatOverrideLevel getOverrideLevel(int level) {
        ListFormatOverrideLevel retLevel = null;
        for (int x = 0; x < this.getLevelOverrides().length; ++x) {
            if (this.getLevelOverrides()[x].getLevelNum() != level) continue;
            retLevel = this.getLevelOverrides()[x];
        }
        return retLevel;
    }

    public int numOverrides() {
        return this._lfo.getClfolvl();
    }

    void setLfoData(LFOData _lfoData) {
        this._lfoData = _lfoData;
    }

    public void setLsid(int lsid) {
        this._lfo.setLsid(lsid);
    }

    public void setOverride(int index, ListFormatOverrideLevel lfolvl) {
        this.getLevelOverrides()[index] = lfolvl;
    }

    public byte[] toByteArray() {
        return this._lfo.serialize();
    }
}

