/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.model.graph;

import at.ac.tuwien.dbai.pdfwrap.model.graph.DocEdge;
import at.ac.tuwien.dbai.pdfwrap.model.graph.DocNode;
import at.ac.tuwien.dbai.pdfwrap.model.graph.DocumentGraph;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.graphelements.GraphEltSet;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;

public class DocGraphEltSet
extends GraphEltSet {
    public static Color NODE_COLOR = Color.red.darker();
    public List<DocNode> lastEnabledNodes;
    protected DocNode startNode;
    protected DocumentGraph dg;

    public DocGraphEltSet() {
    }

    public DocGraphEltSet(DocumentGraph dg) {
        this.dg = dg;
        for (DocNode n : dg.getNodes()) {
            try {
                this.addNode(n);
            }
            catch (TGException e1) {
                e1.printStackTrace();
            }
        }
        for (DocEdge e : dg.getEdges()) {
            this.addEdge(e);
        }
    }

    public DocNode getStartNode() {
        return this.startNode;
    }

    public void setStartNode(DocNode n) {
        this.startNode = n;
    }

    public void clearWrapperEdits() {
        for (Object o : this.nodes) {
            DocNode n = (DocNode)o;
            n.clearWrapperEdits();
        }
        for (Object o : this.edges) {
            DocEdge e = (DocEdge)o;
            e.clearWrapperEdits();
        }
        this.enableDisableNodes();
        this.enableDisableEdges();
    }

    public void clearNodeHighlights() {
        for (Object o : this.nodes) {
            DocNode n = (DocNode)o;
            n.setExampleInstance(false);
            n.setFoundInstance(false);
        }
    }

    public void highlightExampleInstance(List<DocNode> l) {
        for (DocNode n : l) {
            n.setExampleInstance(true);
        }
    }

    public void highlightFoundInstance(List<DocNode> l) {
        for (DocNode n : l) {
            n.setFoundInstance(true);
        }
    }

    public DocNode getFirstEnabledNode() {
        for (Object o : this.nodes) {
            DocNode n = (DocNode)o;
            if (n.isRemoveFromInstance()) continue;
            return n;
        }
        return (DocNode)this.nodes.get(0);
    }

    public void enableDisableNodes(List<DocNode> instanceNodes) {
        for (Object o : this.nodes) {
            DocNode n = (DocNode)o;
            Iterator<DocNode> iter = instanceNodes.iterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                DocNode gs = iter.next();
                if (n != gs) continue;
                found = true;
            }
            if (found) {
                n.setRemoveFromInstance(false);
                continue;
            }
            n.setRemoveFromInstance(true);
        }
        this.lastEnabledNodes = instanceNodes;
    }

    public void enableDisableNodes() {
        this.enableDisableNodes(this.lastEnabledNodes);
    }

    public void enableDisableEdges() {
        for (Object o : this.edges) {
            DocEdge e = (DocEdge)o;
            if (!e.getFrom().isRemoveFromInstance() && !e.getTo().isRemoveFromInstance()) {
                e.setRemoveFromInstance(false);
                continue;
            }
            e.setRemoveFromInstance(true);
        }
    }
}

