/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff.charset;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CFFCharset {
    private List<Entry> entries = new ArrayList<Entry>();

    public boolean isFontSpecific() {
        return false;
    }

    public int getSID(String name) {
        for (Entry entry : this.entries) {
            if (!entry.entryName.equals(name)) continue;
            return entry.entrySID;
        }
        return -1;
    }

    public String getName(int sid) {
        for (Entry entry : this.entries) {
            if (entry.entrySID != sid) continue;
            return entry.entryName;
        }
        return null;
    }

    public void register(int sid, String name) {
        this.entries.add(new Entry(sid, name));
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public static class Entry {
        private int entrySID;
        private String entryName;

        protected Entry(int sid, String name) {
            this.entrySID = sid;
            this.entryName = name;
        }

        public int getSID() {
            return this.entrySID;
        }

        public String getName() {
            return this.entryName;
        }

        public String toString() {
            return "[sid=" + this.entrySID + ", name=" + this.entryName + "]";
        }
    }
}

