# -*- perl -*-
BEGIN
{
    use strict;
    use warnings;
    use Config;
    # Config->import;
    if( $Config{useithreads} )
    {
        require threads;
        # "Because of its global effect, this setting should not be used inside modules or the like."
        # threads->import qw( exit threads_only );
        threads->import;
        require threads::shared;
        threads::shared->import;
    }
    use constant THREADED => $Config{useithreads};
    use Test::More qw( no_plan );
    use Nice::Try;
    our $DEBUG = 0;
};

SKIP:
{
    diag( "perl is not threaded." ) if( !THREADED && $DEBUG );
    skip( 'Your perl is not threaded.', 1 ) if( !THREADED );
    $SIG{SEGV} = sub
    {
        # stdout->print( "Caught a segmentation fault!\n" );
        fail( 'Nice::Try is not thread safe' );
        exit(1);
    };
    my $tid = threads->create(sub
    {
        try
        {
            return( "Hello world" );
        }
        catch( $e )
        {
            stderr->print( "Oopsie daisy: $e\n" );
        }
    });
    ok( $tid, 'Nice::Try is thread safe' );
    $tid->join;
};
done_testing;

__END__

