BEGIN {
  use strict; use warnings;
  use Git::Wrapper;
  use Sort::Versions qw( versioncmp );
  if ( versioncmp( Git::Wrapper->new('.')->version, '1.5.0' ) == -1 )
  {
    print "git version 1.5.0 or better is required\n";
    exit;
  }
  unless(eval q{ use 5.020; 1}) {
    print "Perl 5.020 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.71.
use strict;
use warnings;
use 5.020;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Convert cpan distribution from BackPAN to a git repository",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "Git::Wrapper"        => 0,
    "Sort::Versions"      => 0
  },
  "DISTNAME"  => "App-cpangitify",
  "EXE_FILES" => [
    "bin/cpangitify"
  ],
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.020",
  "NAME"             => "App::cpangitify",
  "PM"               => {
    "lib/App/cpangitify.pm" => "\$(INST_LIB)/App/cpangitify.pm"
  },
  "PREREQ_PM" => {
    "Archive::Libarchive::Extract" => 0,
    "CPAN::ReleaseHistory"         => 0,
    "File::Copy::Recursive"        => 0,
    "File::chdir"                  => 0,
    "Git::Wrapper"                 => 0,
    "HTTP::Tiny"                   => 0,
    "IPC::System::Simple"          => 0,
    "JSON::PP"                     => 0,
    "Mozilla::CA"                  => 0,
    "Path::Class"                  => "0.26",
    "PerlX::Maybe"                 => "0.003",
    "Test2::API"                   => "1.302086",
    "URI"                          => 0,
    "experimental"                 => 0
  },
  "TEST_REQUIRES" => {
    "Capture::Tiny"              => 0,
    "HTTP::Date"                 => 0,
    "Test2::API"                 => "1.302086",
    "Test2::Plugin::FauxHomeDir" => 0,
    "Test2::V0"                  => "0.000121",
    "URI::file"                  => 0
  },
  "VERSION" => "0.20",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Archive::Libarchive::Extract" => 0,
  "CPAN::ReleaseHistory"         => 0,
  "Capture::Tiny"                => 0,
  "File::Copy::Recursive"        => 0,
  "File::chdir"                  => 0,
  "Git::Wrapper"                 => 0,
  "HTTP::Date"                   => 0,
  "HTTP::Tiny"                   => 0,
  "IPC::System::Simple"          => 0,
  "JSON::PP"                     => 0,
  "Mozilla::CA"                  => 0,
  "Path::Class"                  => "0.26",
  "PerlX::Maybe"                 => "0.003",
  "Test2::API"                   => "1.302086",
  "Test2::Plugin::FauxHomeDir"   => 0,
  "Test2::V0"                    => "0.000121",
  "URI"                          => 0,
  "URI::file"                    => 0,
  "experimental"                 => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);