# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=evolution-data-server
VER=2.22.2
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`

DEPS=`/devel/src/tml/latest.sh intltool glib atk pango pixman cairo gtk+ libglade libIDL ORBit2 libbonobo GConf libbonoboui gnome-mime-data libgnome libgnomeui gnome-vfs gnutls libsoup mozilla-nspr mozilla-nss`

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh
sed -e 's/--image-base=0x10000000/--enable-auto-image-base/' <configure >configure.temp && mv configure.temp configure

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I can only
# do this if you have shared version of the library, which you do not
# appear to have." Screw libtool. I know what I am doing. Yes, I do
# want to link with a static libintl now. (The proxy-libintl libintl
# wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

usedev

MY_PKG_CONFIG_PATH=""
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    [ -d /devel/dist/$D/lib/pkgconfig ] && MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done

if [ $VER = 2.22.2 ]; then
    patch -p0 <<'EOF'
--- configure
+++ configure
@@ -23633,9 +23633,17 @@
     DL_LIB=''
     SOFTOKN3_LIB=''
     LIBEXECDIR_IN_SERVER_FILE='../../../libexec'
-    # No, don't use Windows XP -only API
-    # AC_CACHE_VAL(have_addrinfo, [have_addrinfo=yes])
-    # AC_DEFINE(_WIN32_WINNT, 0x501, [To get getaddrinfo etc declarations])
+    if test "${have_addrinfo+set}" = set; then
+  echo $ECHO_N "(cached) $ECHO_C" >&6
+else
+  have_addrinfo=yes
+fi
+
+
+cat >>confdefs.h <<\_ACEOF
+#define _WIN32_WINNT 0x501
+_ACEOF
+
     ;;
 *)  os_win32=no
     NO_UNDEFINED=''
--- config.h.in
+++ config.h.in
@@ -278,6 +278,9 @@
    `char[]'. */
 #undef YYTEXT_POINTER
 
+/* To get getaddrinfo etc declarations */
+#undef _WIN32_WINNT
+
 /* Define to `__inline__' or `__inline' if that's what the C compiler
    calls it, or to nothing if 'inline' is not supported under any name.  */
 #ifndef __cplusplus
EOF
fi

PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3 -mms-bitfields -mthreads' CPPFLAGS='-I/opt/win_iconv/include -I/opt/proxy-libintl/include -I/opt/gnuwin32/include -I/opt/misc/include -I/devel/dist/popt-1.10.2-tml-20050828/include  -I/opt/pthread/include' LDFLAGS='-L/opt/win_iconv/lib -L/opt/proxy-libintl/lib -Wl,--exclude-libs=libintl.a -L/opt/gnuwin32/lib -L/opt/misc/lib -L/devel/dist/popt-1.10.2-tml-20050828/lib -L/opt/pthread/lib -Wl,--enable-auto-image-base' CFLAGS=-O2 ./configure --disable-gtk-doc --disable-static  --with-nspr-includes=/devel/dist/mozilla-nspr-4.6-winnt-opt/include --with-nspr-libs=/devel/dist/mozilla-nspr-4.6-winnt-opt/lib --with-nss-includes=/devel/dist/mozilla-nss-3.10-winnt-opt/include --with-nss-libs=/devel/dist/mozilla-nss-3.10-winnt-opt/lib --prefix=c:/devel/target/$HEX &&
libtoolcacheize &&

PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH PATH=/devel/target/$HEX/bin:.libs:$PATH make -j2 install &&
unset MY_PKG_CONFIG_PATH &&

./evolution-data-server-zip

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh)
manifestify /tmp/$MOD-$VER.zip /tmp/$MOD-dev-$VER.zip
