/* testqueue.c generated by valac 0.12.0, the Vala compiler
 * generated from testqueue.vala, do not modify */

/* testqueue.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_QUEUE_TESTS (queue_tests_get_type ())
#define QUEUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUEUE_TESTS, QueueTests))
#define QUEUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUEUE_TESTS, QueueTestsClass))
#define IS_QUEUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUEUE_TESTS))
#define IS_QUEUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUEUE_TESTS))
#define QUEUE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUEUE_TESTS, QueueTestsClass))

typedef struct _QueueTests QueueTests;
typedef struct _QueueTestsClass QueueTestsClass;
typedef struct _QueueTestsPrivate QueueTestsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _QueueTests {
	CollectionTests parent_instance;
	QueueTestsPrivate * priv;
};

struct _QueueTestsClass {
	CollectionTestsClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer queue_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
GType queue_tests_get_type (void) G_GNUC_CONST;
enum  {
	QUEUE_TESTS_DUMMY_PROPERTY
};
QueueTests* queue_tests_construct (GType object_type, const gchar* name);
CollectionTests* collection_tests_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target);
void queue_tests_test_capacity_bound (QueueTests* self);
static void _queue_tests_test_capacity_bound_gee_test_case_test_method (gpointer self);
void queue_tests_test_one_element_operation (QueueTests* self);
static void _queue_tests_test_one_element_operation_gee_test_case_test_method (gpointer self);
void queue_tests_test_gobject_properties (QueueTests* self);
static void _queue_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);


static void _queue_tests_test_capacity_bound_gee_test_case_test_method (gpointer self) {
	queue_tests_test_capacity_bound (self);
}


static void _queue_tests_test_one_element_operation_gee_test_case_test_method (gpointer self) {
	queue_tests_test_one_element_operation (self);
}


static void _queue_tests_test_gobject_properties_gee_test_case_test_method (gpointer self) {
	queue_tests_test_gobject_properties (self);
}


QueueTests* queue_tests_construct (GType object_type, const gchar* name) {
	QueueTests * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (QueueTests*) collection_tests_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[Queue] capacity bound", _queue_tests_test_capacity_bound_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Queue] one element operation", _queue_tests_test_one_element_operation_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Queue] GObject properties", _queue_tests_test_gobject_properties_gee_test_case_test_method, self);
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void queue_tests_test_capacity_bound (QueueTests* self) {
	GeeCollection* _tmp0_;
	GeeQueue* _tmp1_;
	GeeQueue* test_queue;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (GEE_IS_QUEUE (_tmp0_) ? ((GeeQueue*) _tmp0_) : NULL);
	test_queue = _tmp1_;
	g_assert (test_queue != NULL);
	_tmp2_ = gee_queue_get_capacity (test_queue);
	if (_tmp2_ == GEE_QUEUE_UNBOUNDED_CAPACITY) {
		gint _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = gee_queue_get_remaining_capacity (test_queue);
		g_assert (_tmp3_ == GEE_QUEUE_UNBOUNDED_CAPACITY);
		_tmp4_ = gee_queue_get_is_full (test_queue);
		g_assert (!_tmp4_);
	} else {
		gboolean _tmp5_;
		gint _tmp6_;
		gint capacity;
		gboolean _tmp11_;
		gboolean _tmp17_;
		_tmp5_ = gee_collection_get_is_empty ((GeeCollection*) test_queue);
		g_assert (_tmp5_);
		_tmp6_ = gee_queue_get_capacity (test_queue);
		capacity = _tmp6_;
		{
			gint i;
			i = 1;
			{
				gboolean _tmp7_;
				_tmp7_ = TRUE;
				while (TRUE) {
					gboolean _tmp8_;
					gboolean _tmp9_;
					gint _tmp10_;
					if (!_tmp7_) {
						i++;
					}
					_tmp7_ = FALSE;
					if (!(i <= capacity)) {
						break;
					}
					_tmp8_ = gee_queue_get_is_full (test_queue);
					g_assert (!_tmp8_);
					_tmp9_ = gee_queue_offer (test_queue, "one");
					g_assert (_tmp9_);
					_tmp10_ = gee_queue_get_remaining_capacity (test_queue);
					g_assert (_tmp10_ == (capacity - i));
				}
			}
		}
		_tmp11_ = gee_queue_get_is_full (test_queue);
		g_assert (_tmp11_);
		{
			gint i;
			i = 1;
			{
				gboolean _tmp12_;
				_tmp12_ = TRUE;
				while (TRUE) {
					gpointer _tmp13_ = NULL;
					gchar* _tmp14_;
					gboolean _tmp15_;
					gint _tmp16_;
					if (!_tmp12_) {
						i++;
					}
					_tmp12_ = FALSE;
					if (!(i <= capacity)) {
						break;
					}
					_tmp13_ = gee_queue_poll (test_queue);
					_tmp14_ = (gchar*) _tmp13_;
					g_assert (g_strcmp0 (_tmp14_, "one") == 0);
					_g_free0 (_tmp14_);
					_tmp15_ = gee_queue_get_is_full (test_queue);
					g_assert (!_tmp15_);
					_tmp16_ = gee_queue_get_remaining_capacity (test_queue);
					g_assert (_tmp16_ == i);
				}
			}
		}
		_tmp17_ = gee_collection_get_is_empty ((GeeCollection*) test_queue);
		g_assert (_tmp17_);
	}
	_g_object_unref0 (test_queue);
}


void queue_tests_test_one_element_operation (QueueTests* self) {
	GeeCollection* _tmp0_;
	GeeQueue* _tmp1_;
	GeeQueue* test_queue;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* recipient;
	gboolean _tmp3_;
	gpointer _tmp4_ = NULL;
	gchar* _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	gpointer _tmp8_ = NULL;
	gchar* _tmp9_;
	gint _tmp10_;
	gboolean _tmp11_;
	gpointer _tmp12_ = NULL;
	gchar* _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gboolean _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gboolean _tmp19_;
	gint _tmp20_;
	gpointer _tmp21_ = NULL;
	gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gboolean _tmp25_;
	gint _tmp26_;
	gboolean _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_;
	gint _tmp31_;
	gpointer _tmp32_ = NULL;
	gchar* _tmp33_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (GEE_IS_QUEUE (_tmp0_) ? ((GeeQueue*) _tmp0_) : NULL);
	test_queue = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	recipient = _tmp2_;
	g_assert (test_queue != NULL);
	_tmp3_ = gee_queue_offer (test_queue, "one");
	g_assert (_tmp3_);
	_tmp4_ = gee_queue_peek (test_queue);
	_tmp5_ = (gchar*) _tmp4_;
	g_assert (g_strcmp0 (_tmp5_, "one") == 0);
	_g_free0 (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) test_queue);
	g_assert (_tmp6_ == 1);
	_tmp7_ = gee_collection_get_is_empty ((GeeCollection*) test_queue);
	g_assert (!_tmp7_);
	_tmp8_ = gee_queue_poll (test_queue);
	_tmp9_ = (gchar*) _tmp8_;
	g_assert (g_strcmp0 (_tmp9_, "one") == 0);
	_g_free0 (_tmp9_);
	_tmp10_ = gee_collection_get_size ((GeeCollection*) test_queue);
	g_assert (_tmp10_ == 0);
	_tmp11_ = gee_collection_get_is_empty ((GeeCollection*) test_queue);
	g_assert (_tmp11_);
	_tmp12_ = gee_queue_peek (test_queue);
	_tmp13_ = (gchar*) _tmp12_;
	g_assert (_tmp13_ == NULL);
	_g_free0 (_tmp13_);
	_tmp14_ = gee_queue_poll (test_queue);
	_tmp15_ = (gchar*) _tmp14_;
	g_assert (_tmp15_ == NULL);
	_g_free0 (_tmp15_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	_tmp16_ = gee_queue_offer (test_queue, "one");
	g_assert (_tmp16_);
	_tmp17_ = gee_queue_drain (test_queue, (GeeCollection*) recipient, 1);
	g_assert (_tmp17_ == 1);
	_tmp18_ = gee_collection_get_size ((GeeCollection*) test_queue);
	g_assert (_tmp18_ == 0);
	_tmp19_ = gee_collection_get_is_empty ((GeeCollection*) test_queue);
	g_assert (_tmp19_);
	_tmp20_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp20_ == 1);
	_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 0);
	_tmp22_ = (gchar*) _tmp21_;
	g_assert (g_strcmp0 (_tmp22_, "one") == 0);
	_g_free0 (_tmp22_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	_tmp23_ = gee_queue_drain (test_queue, (GeeCollection*) recipient, 1);
	g_assert (_tmp23_ == 0);
	_tmp24_ = gee_collection_get_size ((GeeCollection*) test_queue);
	g_assert (_tmp24_ == 0);
	_tmp25_ = gee_collection_get_is_empty ((GeeCollection*) test_queue);
	g_assert (_tmp25_);
	_tmp26_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp26_ == 0);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	_tmp27_ = gee_queue_offer (test_queue, "one");
	g_assert (_tmp27_);
	_tmp28_ = gee_queue_drain (test_queue, (GeeCollection*) recipient, -1);
	g_assert (_tmp28_ == 1);
	_tmp29_ = gee_collection_get_size ((GeeCollection*) test_queue);
	g_assert (_tmp29_ == 0);
	_tmp30_ = gee_collection_get_is_empty ((GeeCollection*) test_queue);
	g_assert (_tmp30_);
	_tmp31_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp31_ == 1);
	_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 0);
	_tmp33_ = (gchar*) _tmp32_;
	g_assert (g_strcmp0 (_tmp33_, "one") == 0);
	_g_free0 (_tmp33_);
	_g_object_unref0 (recipient);
	_g_object_unref0 (test_queue);
}


void queue_tests_test_gobject_properties (QueueTests* self) {
	GeeCollection* _tmp0_;
	GeeQueue* _tmp1_;
	GeeQueue* test_queue;
	GValue value = {0};
	GValue _tmp2_ = {0};
	GValue _tmp3_ = {0};
	gint _tmp4_;
	gint _tmp5_;
	GValue _tmp6_ = {0};
	GValue _tmp7_ = {0};
	gint _tmp8_;
	gint _tmp9_;
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	gboolean _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (GEE_IS_QUEUE (_tmp0_) ? ((GeeQueue*) _tmp0_) : NULL);
	test_queue = _tmp1_;
	g_assert (test_queue != NULL);
	g_value_init (&_tmp2_, G_TYPE_INT);
	_tmp3_ = _tmp2_;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp3_;
	g_object_get_property ((GObject*) test_queue, "capacity", &value);
	_tmp4_ = g_value_get_int (&value);
	_tmp5_ = gee_queue_get_capacity (test_queue);
	g_assert (_tmp4_ == _tmp5_);
	g_value_unset (&value);
	g_value_init (&_tmp6_, G_TYPE_INT);
	_tmp7_ = _tmp6_;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp7_;
	g_object_get_property ((GObject*) test_queue, "remaining-capacity", &value);
	_tmp8_ = g_value_get_int (&value);
	_tmp9_ = gee_queue_get_remaining_capacity (test_queue);
	g_assert (_tmp8_ == _tmp9_);
	g_value_unset (&value);
	g_value_init (&_tmp10_, G_TYPE_BOOLEAN);
	_tmp11_ = _tmp10_;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp11_;
	g_object_get_property ((GObject*) test_queue, "is-full", &value);
	_tmp12_ = g_value_get_boolean (&value);
	_tmp13_ = gee_queue_get_is_full (test_queue);
	g_assert (_tmp12_ == _tmp13_);
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	_g_object_unref0 (test_queue);
}


static void queue_tests_class_init (QueueTestsClass * klass) {
	queue_tests_parent_class = g_type_class_peek_parent (klass);
}


static void queue_tests_instance_init (QueueTests * self) {
}


GType queue_tests_get_type (void) {
	static volatile gsize queue_tests_type_id__volatile = 0;
	if (g_once_init_enter (&queue_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (QueueTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) queue_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QueueTests), 0, (GInstanceInitFunc) queue_tests_instance_init, NULL };
		GType queue_tests_type_id;
		queue_tests_type_id = g_type_register_static (TYPE_COLLECTION_TESTS, "QueueTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&queue_tests_type_id__volatile, queue_tests_type_id);
	}
	return queue_tests_type_id__volatile;
}



