#include <Xclasses/Xclasses.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <stdarg.h>
#include "designer.h"
#include "externs.h"

dlist allobjs;
functions gg_func[TOTAL_OBJ+3+1];

int editobj(des_object *o);
group *commandParser(int md,char *command[],des_object *o,...);

#define ADD2LIST(text,tname,obj,c)	addlist.AddAtEnd(text,(void*)obj); \
									gg_func[c].func=tname; \
									gg_func[c].count=0; \
									gg_func[c].vars[0]=0; \
									gg_func[c].name=text;

static int total_objs=0;

void settypenames(void)
{
	int c=1;
	addlist.AddAtEnd("-- groups"); c++;
	addlist.LockItem(c-1);
	ADD2LIST("group",ed_group,OBJ_GROUP,c); c++;
	ADD2LIST("bordergroup",ed_bordergroup,OBJ_BORDERGROUP,c); c++;
	ADD2LIST("spacegroup",ed_spacegroup,OBJ_SPACEGROUP,c); c++;

	addlist.AddAtEnd("-- for subgroups"); c++;
	addlist.LockItem(c-1);
	ADD2LIST("card",ed_card,OBJ_CARD,c); c++;
	ADD2LIST("rubbergroup",ed_rubbergroup,OBJ_RUBBERGROUP,c); c++;

	addlist.AddAtEnd("-- for subobjects"); c++;
	addlist.LockItem(c-1);
	ADD2LIST("visible",ed_visible,OBJ_VISIBLE,c); c++;

	addlist.AddAtEnd("-- gadgets"); c++;
	addlist.LockItem(c-1);
	ADD2LIST("button",ed_button,OBJ_BUTTON,c); c++;
	ADD2LIST("fbutton",ed_fbutton,OBJ_FBUTTON,c); c++;
	ADD2LIST("selbutton",ed_selbutton,OBJ_SELBUTTON,c); c++;
	ADD2LIST("mxbutton",ed_mxbutton,OBJ_MXBUTTON,c); c++;
//	ADD2LIST("selknob",ed_selknob,OBJ_SELKNOB,c); c++;
	ADD2LIST("mxknob",ed_mxknob,OBJ_MXKNOB,c); c++;
	ADD2LIST("checkbox",ed_checkbox,OBJ_CHECKBOX,c); c++;
	ADD2LIST("choice",ed_choice,OBJ_CHOICE,c); c++;
	ADD2LIST("input",ed_input,OBJ_INPUT,c); c++;
	ADD2LIST("listview",ed_listview,OBJ_LISTVIEW,c); c++;
	ADD2LIST("slider",ed_slider,OBJ_SLIDER,c); c++;
	ADD2LIST("scroller",ed_scroller,OBJ_SCROLLER,c); c++;
	ADD2LIST("textbox",ed_textbox,OBJ_TEXTBOX,c); c++;

	addlist.AddAtEnd("-- output"); c++;
	addlist.LockItem(c-1);
	ADD2LIST("ruler",ed_ruler,OBJ_RULER,c); c++;
	ADD2LIST("text",ed_text,OBJ_TEXT,c); c++;
	ADD2LIST("output",ed_output,OBJ_OUTPUT,c); c++;
	ADD2LIST("autotextbox",ed_autotextbox,OBJ_AUTOTEXTBOX,c); c++;
	ADD2LIST("htmltextbox",ed_htmltextbox,OBJ_HTMLTEXTBOX,c); c++;
	ADD2LIST("xclock",ed_xclock,OBJ_XCLOCK,c); c++;
	ADD2LIST("indicator",ed_indicator,OBJ_INDICATOR,c); c++;
	ADD2LIST("image",ed_image,OBJ_IMAGE,c); c++;
	ADD2LIST("graphic",ed_graphic,OBJ_GRAPHIC,c); c++;
	total_objs=c-1;
}


void addgg(void)
{
	struct des_object *obj;
	int s=addlist.Selected();
	if (s==0) return;

	if (obj=new des_object)
	{
		{
			char *r=(char*)obj;
			for(int i=0;i<sizeof(des_object);i++)
			{
				*r=0;
				r++;
			}
		}
		obj->type=(unsigned int)addlist.GetData(s);
		obj->size=sizeof(des_object);
		sprintf(obj->varname,"%s%s_%02d",set.objprefixes,gg_func[s].name,gg_func[s].count++);
		strcpy(obj->classname,gg_func[s].name);
		strcpy(obj->objname,gg_func[s].name);
		obj->func=s;
		obj->weight=100;
		obj->ID[0]=0;
		obj->gp_adjust=0;
		obj->gp_dialogmode=0;
		obj->gp_usesmallest=0;
		obj->gg_lefttext=0;
		obj->gp_horiz=0;
		obj->lttext[0]=0;
		obj->helptext=NULL;
		if (allobjs.IsEmpty())
		{
			obj->level=0;
		}
		else
		{
			if (allgadgets.Selected())
			{
				des_object *o;
				o=(des_object*)allgadgets.GetData(allgadgets.Selected());
				obj->level=o->level;
				if (o->type & OBJ_ALLGROUPS)
				{
					obj->level++;
				}
			}
			else
			{
				obj->level=((des_object*)allobjs.tail)->level;
				if (((des_object*)allobjs.tail)->type & OBJ_ALLGROUPS)
				{
					obj->level++;
				}
			}
		}
		gg_func[obj->func].func(MODE_SETUP,obj);
		if (editobj(obj))
		{
			if (allgadgets.Selected())
			{
				des_object *o;
				o=(des_object*)allgadgets.GetData(allgadgets.Selected());
				o=(des_object*)o->base.next;
				allobjs.Insert((node*)obj,(node*)o);
			}
			else
			{
				allobjs.AddTail((node*)obj);
			}
			updateOutput();
			allgadgets.Selected(allobjs.Find((node*)obj));
		}
		else
		{
			delete obj;
		}
	}
}
void editgg(void)
{
	struct des_object *obj;
	int s=allgadgets.Selected();
	if (s==0) return;

	if (obj=(des_object*)allgadgets.GetData(s))
	{
		editobj(obj);
		updateOutput();
		allgadgets.Selected(allobjs.Find((node*)obj));
	}
}
void delgg(void)
{
	struct des_object *obj;
	int s=allgadgets.Selected();
	if (s==0) return;

	if (obj=(des_object*)allgadgets.GetData(s))
	{
		allobjs.Remove((node*)obj);
		if (obj->outputbuf) delete obj->outputbuf;
		delete obj;
		updateOutput();
	}
}
int exportgg(char *fname)
{
	int r=1,lt_count=0;
	FILE *file;
	char *grname[30],*spaces="                              ";

	if (file=fopen(fname,"w"))
	{
		struct des_object *o=(des_object*)allobjs.head;
		int grouplevel=0;

		for(int i=0;i<total_objs;i++)
		{
			gg_func[i].vars[0]=0;
		}

		while (o->base.next)
		{
			if (strlen(gg_func[o->func].vars)+strlen(o->varname)>=sizeof(gg_func[o->func].vars))
			{
				fprintf(file,"%s;\n",gg_func[o->func].vars);
				gg_func[o->func].vars[0]=0;
			}
			if (strlen(gg_func[o->func].vars)==0)
			{
				strcpy(gg_func[o->func].vars,o->classname);
				strcat(gg_func[o->func].vars," ");
				strcat(gg_func[o->func].vars,o->varname);
			}
			else
			{
				strcat(gg_func[o->func].vars,", ");
				strcat(gg_func[o->func].vars,o->varname);
			}
			o=(des_object*)o->base.next;
		}
		for(int i=0;i<total_objs;i++)
		{
			if (strlen(gg_func[i].vars))
			{
				fprintf(file,"%s;\n",gg_func[i].vars);
				gg_func[i].vars[0]=0;
			}
		}
		fprintf(file,"\ngroup *%s(void)\n",set.funcname);
		fprintf(file,"{\n");

		o=(des_object*)allobjs.head;
		grouplevel=0;
		while (o->base.next)
		{
			if (o->level>grouplevel)
			{ // Level error
			}
			else
			{
				char **command=(char**)gg_func[o->func].func(MODE_COMMAND,o);

				if (o->gg_lefttext)
				{
					lt_count++;
					fprintf(file,"    %.*sstatic lefttext lt_%02x;\n",grouplevel,spaces,lt_count);
					fprintf(file,"    %.*slt_%02x.Gadget(%s);\n",grouplevel,spaces,lt_count,o->varname);
					fprintf(file,"    %.*slt_%02x.Name(NULL);\n",grouplevel,spaces,lt_count);
					if (strlen(o->lttext)) fprintf(file,"    %.*slt_%02x.Text(\"%s\");\n",grouplevel,spaces,lt_count,o->lttext);
				}
				if (o->weight!=100)
				{
					if (o->gg_lefttext)
						fprintf(file,"    %.*slt_%02x.Weight(%d);\n",grouplevel,spaces,lt_count,o->weight);
					else
						fprintf(file,"    %.*s%s.Weight(%d);\n",grouplevel,spaces,o->varname,o->weight);
				}
				if (strlen(o->objname))
					fprintf(file,"    %.*s%s.Name(\"%s\");\n",grouplevel,spaces,o->varname,o->objname);
				else
					fprintf(file,"    %.*s%s.Name(NULL);\n",grouplevel,spaces,o->varname);

				if (o->type & OBJ_ALLGROUPS)
				{
					if (o->gp_dialogmode) fprintf(file,"    %.*s%s.DialogMode();\n",grouplevel,spaces,o->varname);
					if (o->gp_usesmallest) fprintf(file,"    %.*s%s.UseSmallest();\n",grouplevel,spaces,o->varname);
					if (o->gp_adjust==1) fprintf(file,"    %.*s%s.Center();\n",grouplevel,spaces,o->varname);
					if (o->gp_adjust==2) fprintf(file,"    %.*s%s.Right();\n",grouplevel,spaces,o->varname);
					if (o->gp_horiz)
						fprintf(file,"    %.*s%s.Horiz();\n",grouplevel,spaces,o->varname);
					else
						fprintf(file,"    %.*s%s.Vert();\n",grouplevel,spaces,o->varname);
				}
				if (o->helptext)
				{
//					fprintf(file,"    %.*s%s.HelpText(\"%s\");\n",grouplevel,spaces,o->varname,o->helptext);
				}
				if (strlen(o->ID)) fprintf(file,"    %.*s%s.ID(%s);\n",grouplevel,spaces,o->varname,o->ID);

				char *out=(char*)commandParser(CP_EXPORT,command,o);
				char *st,*en;

				if (st=out)
				{
					en=st;
					while (*en)
					{
						if (*en=='\n')
						{
							*en=0;
							fprintf(file,"    %.*s%s.%s;\n",grouplevel,spaces,o->varname,st);
							st=en+1;
						}
						en++;
					}
				}

				if (o->level<grouplevel)
				{
					grouplevel=o->level;
					fprintf(file,"    %.*s/* group %s */\n\n",grouplevel-1,spaces,grname[grouplevel-1]);
				}
				if (grouplevel>0)
				{
					if (o->gg_lefttext)
						fprintf(file,"    %.*s%s.Add(lt_%02x);\n",grouplevel-1,spaces,grname[grouplevel-1],lt_count);
					else
						fprintf(file,"    %.*s%s.Add(%s);\n",grouplevel-1,spaces,grname[grouplevel-1],o->varname);
				}
				if (o->type & OBJ_ALLGROUPS)
				{
					grname[grouplevel]=o->varname;
					grouplevel=o->level+1;
				}
			}
			o=(des_object*)o->base.next;
		}
		fprintf(file,"\n    return %s;\n} /* genGUI */\n",grname[0]);
		fclose(file);
		r=0;
	}
	return r;
}
group *basegroup;
group *showgg(void)
{
	struct des_object *o=(des_object*)allobjs.head;
	int grouplevel=0;
	group *curgp[30];
	char *c;

	if (!o->base.next || !(o->type & OBJ_ALLGROUPS)) return NULL;

	basegroup=new group;
	basegroup->Name("examplewindow");
	curgp[0]=NULL;

	while (o->base.next)
	{
		o->ltobj=NULL;
		if (o->level>grouplevel)
		{ // Level error
		}
		else
		{
			gg_func[o->func].func(MODE_CREATE,o);
			c=o->lvtext;
			while (*c && *c==' ') c++;
//			sprintf(o->helpinfo,"ID: %d\n%s",o->ID,c);
			if (o->helptext)
				o->obj->HelpText(o->helptext);
			if (o->type & OBJ_ALLGROUPS)
			{
				if (o->gp_dialogmode) ((group*)o->obj)->DialogMode();
				if (o->gp_usesmallest) ((group*)o->obj)->UseSmallest();
				if (o->gp_adjust==1) ((group*)o->obj)->Center();
				if (o->gp_adjust==2) ((group*)o->obj)->Right();
				if (o->gp_horiz)
					((group*)o->obj)->Horiz();
				else
					((group*)o->obj)->Vert();
			}
			else
			{
//				if (o->ID) o->obj->ID(o->ID);
			}
			if (o->gg_lefttext)
			{
				o->ltobj=new lefttext;
				o->ltobj->Gadget(o->obj);
				if (strlen(o->lttext)) o->ltobj->Text(o->lttext);
			}
			if (o->weight!=100)
			{
				if (o->gg_lefttext)
					o->ltobj->Weight(o->weight);
				else
					o->obj->Weight(o->weight);
			}
			if (o->level<grouplevel)
			{
				grouplevel=o->level;
			}
			if (grouplevel>0)
			{
				if (o->gg_lefttext)
					curgp[grouplevel-1]->Add(o->ltobj);
				else
					curgp[grouplevel-1]->Add(o->obj);
			}
			if (o->type & OBJ_ALLGROUPS)
			{
				curgp[grouplevel]=(group*)o->obj;
				grouplevel=o->level+1;
			}
		}
		o=(des_object*)o->base.next;
	}
	basegroup->Add(curgp[0]);
	return basegroup;
}
void freegg(void)
{
	struct des_object *o=(des_object*)allobjs.head;

	while (o->base.next)
	{
		if (o->obj->userdata) delete o->obj->userdata;
		o=(des_object*)o->base.next;
	}
	DeleteObjectTree(basegroup->FullName(),0);
}

//          0  ,1     ,2   ,3   ,4    ,5
// Ende: 	QIT
// Neue GP: GRP
// Neue BGP:BGRP,Title/NULL
// Input: 	TXT,offset,Name,Text,chars,Funcname
// Integer: INT,offset,Name,Text,chars,Funcname
// Bool1:	BL1,offset,Name,Text,TrueFuncname
// Bool2:	BL2,offset,Name,Text,TrueFuncname,FalseFuncname
// Choice:  CHO,offset,Name,Text,ValText1,ValFunc1,...,NULL
// 

// CP_MAKEGROUP,com,des_object,basegroup
// CP_SETVALUES,com,des_object,basegroup
// CP_EXPORT,com,des_object
group *commandParser(int md,char *command[],des_object *o,...)
{
#define	VALUE(x)	((int)o+(int)command[x])
	int i=0,done=0;
	switch (md)
	{
	case CP_MAKEGROUP:
		{
			va_list args;
			va_start(args,o);
			bordergroup *basegp=va_arg(args,bordergroup *);
			group *g=basegp;
			basegp->Vert();

			while (!done)
			{ printf("%s\n",command[i]);
				if (!strcmp("QIT",command[i]))
				{
					done=1;
				}
				else if (!strcmp("GRP",command[i]))
				{
					g=new group;
					basegp->Add(g);
					basegp->Horiz();
					g->Vert();
					g->Name(NULL);
				}
				else if (!strcmp("BGRP",command[i]))
				{
					g=new bordergroup;
					basegp->Add(g);
					basegp->Horiz();
					g->Vert();
					g->Name(NULL);
					((bordergroup*)g)->Title(command[i+1]);
					i+=1;
				}
				else if (!strcmp("TXT",command[i]))
				{
					input *ip=new input;
					ip->Name(command[i+2]);
					ip->Text(command[i+3]);
					ip->MaxChars((int)command[i+4]);
					ip->Default((char*)VALUE(i+1));

					g->Add(ip);
					i+=5;
				}
				else if (!strcmp("INT",command[i]))
				{
					char buf[(int)command[i+4]+1];
					input *ip=new input;
					ip->Name(command[i+2]);
					ip->Text(command[i+3]);
					ip->IntegerMode();
					ip->MaxChars((int)command[i+4]);
					sprintf(buf,"%d",*(int*)VALUE(i+1));
					ip->Default(buf);

					g->Add(ip);
					i+=5;
				}
				else if (!strcmp("BL1",command[i]))
				{
					checkbox *cb=new checkbox;
					cb->Name(command[i+2]);
					cb->Text(command[i+3]);
					cb->State(*(int*)VALUE(i+1)?PRESSED:RELEASED);

					g->Add(cb);
					i+=4;
				}
				else if (!strcmp("BL2",command[i]))
				{
					checkbox *cb=new checkbox;
					cb->Name(command[i+2]);
					cb->Text(command[i+3]);
					cb->State(*(int*)VALUE(i+1)?PRESSED:RELEASED);

					g->Add(cb);
					i+=5;
				}
				else if (!strcmp("CHO",command[i]))
				{
					lefttext *lt=new lefttext;
					choice *cb=new choice;
					int j,v;
					lt->Name(NULL);
					lt->Text(command[i+3]);
					lt->Gadget(cb);
					cb->Name(command[i+2]);
					v=i+1;
					i+=4;
					j=i;
					while (command[j])
					{
						j+=2;
					}
					char **chb=new char*[(j-i)/2+1];
					cb->userdata=chb;
					j=0;
					while (command[i])
					{
						chb[j++]=command[i];
						i+=2;
					}
					chb[j]=NULL;
					cb->Items(chb);
					cb->Selected(*(int*)VALUE(v));
					g->Add(lt);
				}
				i++;
			}
			va_end(args);
		}
		break;
	case CP_SETVALUES:
		{
			va_list args;
			va_start(args,o);
			group *basegp=va_arg(args,group *);
			char oname[INTERNLEN+5];
			while (!done)
			{ printf("%s\n",command[i]);
				if (!strcmp("QIT",command[i]))
				{
					done=1;
				}
				else if (!strcmp("GRP",command[i]))
				{
				}
				else if (!strcmp("BGRP",command[i]))
				{
					i+=1;
				}
				else if (!strcmp("TXT",command[i]))
				{
					sprintf(oname,".%s",command[i+2]);
					input *ip=(input*)FindObject(basegp->FullName(),oname);
					ip->Input((char*)VALUE(i+1));

					i+=5;
				}
				else if (!strcmp("INT",command[i]))
				{
					sprintf(oname,".%s",command[i+2]);
					input *ip=(input*)FindObject(basegp->FullName(),oname);
					char buf[(int)command[i+4]+1];
					ip->Input(buf);
					*(int*)VALUE(i+1)=atoi(buf);

					i+=5;
				}
				else if (!strcmp("BL1",command[i]))
				{
					sprintf(oname,".%s",command[i+2]);
					checkbox *cb=(checkbox*)FindObject(basegp->FullName(),oname);
					*(int*)VALUE(i+1)=cb->State()==PRESSED?1:0;

					i+=4;
				}
				else if (!strcmp("BL2",command[i]))
				{
					sprintf(oname,".%s",command[i+2]);
					checkbox *cb=(checkbox*)FindObject(basegp->FullName(),oname);
					*(int*)VALUE(i+1)=cb->State()==PRESSED?1:0;

					i+=5;
				}
				else if (!strcmp("CHO",command[i]))
				{
					sprintf(oname,".%s",command[i+2]);
					choice *cb=(choice*)FindObject(basegp->FullName(),oname);
					*(int*)VALUE(i+1)=cb->Selected();
					i+=4;
					while (command[i])
					{
						i+=2;
					}
				}
				i++;
			}
			va_end(args);
		}
		break;
	case CP_EXPORT:
		{
			static char txt[1000];
			txt[0]=0;
			while (!done)
			{
				if (!strcmp("QIT",command[i]))
				{
					done=1;
				}
				else if (!strcmp("GRP",command[i]))
				{
				}
				else if (!strcmp("BGRP",command[i]))
				{
					i+=1;
				}
				else if (!strcmp("TXT",command[i]))
				{
					if (strlen(((char*)VALUE(i+1))))
					{
						strcat(txt,command[i+5]);
						strcat(txt,"(\"");
						strcat(txt,((char*)VALUE(i+1)));
						strcat(txt,"\")\n");
					}
					i+=5;
				}
				else if (!strcmp("INT",command[i]))
				{
					if (strlen(((char*)VALUE(i+1))))
					{
						char buf[(int)command[i+4]+1];
						strcat(txt,command[i+5]);
						sprintf(buf,"(%d)\n",*(int*)VALUE(i+1));
						strcat(txt,buf);
					}
					i+=5;
				}
				else if (!strcmp("BL1",command[i]))
				{
					if (*(int*)VALUE(i+1))
						strcat(txt,command[i+4]);
					strcat(txt,"\n");
					i+=4;
				}
				else if (!strcmp("BL2",command[i]))
				{
					if (*(int*)VALUE(i+1))
						strcat(txt,command[i+4]);
					else
						strcat(txt,command[i+5]);
					strcat(txt,"\n");
					i+=5;
				}
				else if (!strcmp("CHO",command[i]))
				{
					int j,v;
					v=i+1;
					i+=4;
					j=0;
					while (command[i])
					{
						if (j++==*(int*)VALUE(v))
						{
							strcat(txt,command[i+1]);
							strcat(txt,"\n");
						}
						i+=2;
					}
				}
				i++;
			}
			return (group*)txt;
		}
		break;
	}
	return 0;
}

void wfunc(int val,char *buf,int maxsize)
{
	sprintf(buf,"%d%%",val);
}
int editobj(des_object *o)
{
#define ID_LEFTTEXTON	1
#define ID_OKBUTTON		2
#define ID_CANCELBUTTON	3

	static appwindow edwin;
	group maingp;
	bordergroup allgroup;
	int x,y,w,h;

	GetPositionOnRoot(mainwin.display(),mainwin.window(),x,y);
	mainwin.Size(w,h);

//	edwin.InitSize(x,y,10);
	edwin.Name("editobject");
	edwin.Init();
	edwin.TransientFor(mainwin);
	edwin.Adjust(x,y,w,h,ADJUST_CENTER|ADJUST_MIDDLE);

	maingp.Name("maingroup");
	maingp.Vert();
	maingp.Add(allgroup);
	 allgroup.Horiz();
	 allgroup.Title("General");
	 group allgroups1,allgroups2;
	 allgroup.Add(allgroups1);
	  allgroups1.Vert();
	  input varname;
	  allgroups1.Add(varname);
	   varname.MaxChars(sizeof(o->varname));
	   varname.Text("Variable name:");
	   varname.Default(o->varname);
	  input objname;
	  allgroups1.Add(objname);
	   objname.MaxChars(sizeof(o->objname));
	   objname.Text("Object name:");
	   objname.Default(o->objname);
	  input idname;
	  allgroups1.Add(idname);
	   idname.MaxChars(sizeof(o->ID));
	   idname.Text("ID name:");
	   idname.Default(o->ID);
	  input callbackname;
	  allgroups1.Add(callbackname);
	   callbackname.MaxChars(sizeof(o->callback));
	   callbackname.Text("Callback name:");
	   callbackname.Default(o->callback);
	  lefttext weighttext;
	  slider weightslider;
	  allgroups1.Add(weighttext);
	   weighttext.Text("Weight:");
	   weighttext.Gadget(weightslider);
	   weightslider.MinValue(1);
	   weightslider.MaxValue(200);
	   weightslider.Value(o->weight);
	   weightslider.TextCallback(wfunc);
	   weightslider.Horiz();
	  lefttext lefttexttitle;
	  group lefttextgroup;
	  checkbox lefttexton;
	  input lefttexttext;
	  allgroups1.Add(lefttexttitle);
	   lefttexttitle.Text("Left text:");
	   lefttexttitle.Gadget(lefttextgroup);
	   lefttextgroup.Horiz();
	   lefttextgroup.Add(lefttexton);
	    lefttexton.Text("");
	    lefttexton.State(o->gg_lefttext?PRESSED:RELEASED);
	    lefttexton.ID(ID_LEFTTEXTON);
	   lefttextgroup.Add(lefttexttext);
	    lefttexttext.MaxChars(sizeof(o->lttext));
	    lefttexttext.Default(o->lttext);
		if (lefttexton.State()==PRESSED)
			lefttexttext.Unlock();
		else
			lefttexttext.Lock();
	 allgroup.Add(allgroups2);
	  allgroups2.Vert();
	  lefttext helptexttext;
	  textbox helptext;
	  allgroups2.Add(helptexttext);
	   helptexttext.Text("Help text:");
	   helptexttext.Gadget(helptext);
	   helptext.ReplaceText(o->helptext);

//	ruler spacer1;
//	maingp.Add(spacer1);
	
	bordergroup gp_allgroup;
	group gp_allgroups1,gp_allgroups2;
	lefttext ltadjust,ltdirection;
	choice adjust,direction;
	checkbox usesmallest,dialogmode;
	char *dir[]={"horizontal","vertical",NULL};
	char *adj[]={"left","center","right",NULL};
	if (o->type & OBJ_ALLGROUPS)
	{ // Group
		maingp.Add(gp_allgroup);
		 gp_allgroup.Title("Group");
		 gp_allgroup.Horiz();
		 gp_allgroup.Add(gp_allgroups1);
		  gp_allgroups1.Vert();
		  gp_allgroups1.Add(ltdirection);
		   ltdirection.Text("Direction:");
		   ltdirection.Gadget(direction);
		   direction.Items(dir);
		   direction.Selected(o->gp_horiz?0:1);
		  gp_allgroups1.Add(ltadjust);
		   ltadjust.Text("Adjust:");
		   ltadjust.Gadget(adjust);
		   adjust.Items(adj);
		   adjust.Selected(o->gp_adjust);

		 gp_allgroup.Add(gp_allgroups2);
		  gp_allgroups2.Vert();
		  gp_allgroups2.Add(usesmallest);
		   usesmallest.Text("Use smallest");
		   usesmallest.State(o->gp_usesmallest?PRESSED:RELEASED);
		  gp_allgroups2.Add(dialogmode);
		   dialogmode.Text("Dialog mode");
		   dialogmode.State(o->gp_dialogmode?PRESSED:RELEASED);
	}

	char **command=(char**)gg_func[o->func].func(MODE_COMMAND,o);

	bordergroup *objectdata=NULL;
	if (command[0])
	{
		objectdata=new bordergroup;
		maingp.Add(objectdata);
		objectdata->Name("object");
		objectdata->Title(gg_func[o->func].name);
		objectdata->Vert();

		commandParser(CP_MAKEGROUP,command,o,objectdata);
//		printf("%x, %s\n",g,g->Name());
//		objectdata->Add(g);
	}

	ruler lastspacer;
	maingp.Add(lastspacer);
	spacegroup butgroup;
	maingp.Add(butgroup);
	 butgroup.Horiz();
	 butgroup.DialogMode();
	 butgroup.Border(4);
	 fbutton okbut,cancelbut;
	 butgroup.Add(okbut);
	  okbut.Text("Ok");
	  okbut.ID(ID_OKBUTTON);
	 butgroup.Add(cancelbut);
	  cancelbut.Text("Cancel");
	  cancelbut.ID(ID_CANCELBUTTON);

	edwin.SetGroup(maingp);
	edwin.Create();

	int done=0,r=0;
	
	while (!done)
	{
		r=edwin.NextEvent();
		if (r==EV_WINDOWCLOSE)
			done=1;
		else if (r==EV_GADGET)
		{
			switch (edwin.ID())
			{
			case ID_OKBUTTON:
				done=2;
				break;
			case ID_CANCELBUTTON:
				done=1;
				break;
			case ID_LEFTTEXTON:
				if (lefttexton.State()==PRESSED)
					lefttexttext.Unlock();
				else
					lefttexttext.Lock();
				break;
			}
		}
	}	
	edwin.Close();

	if (done==2)
	{
		varname.Input(o->varname);
		objname.Input(o->objname);
		idname.Input(o->ID);
		callbackname.Input(o->callback);
		o->weight=weightslider.Value();
		o->gg_lefttext=lefttexton.State()==PRESSED?1:0;
		lefttexttext.Input(o->lttext);
		if (o->helptext)
		{
			::free(o->helptext);
			o->helptext=NULL;
		}
		if (helptext.TextSize())
		{
			if (o->helptext=(char*)malloc(helptext.TextSize()+1))
			{
				helptext.CopyText(o->helptext,helptext.TextSize()+1);
			}
		}
		if (o->type & OBJ_ALLGROUPS)
		{ // Group
			o->gp_adjust=adjust.Selected();
			o->gp_horiz=(direction.Selected()?0:1);
			o->gp_usesmallest=usesmallest.State()==PRESSED?1:0;
			o->gp_dialogmode=dialogmode.State()==PRESSED?1:0;
		}
		// Werte setzen & ggs freigeben
		if (command[0])
		{ // setzen
			commandParser(CP_SETVALUES,command,o,objectdata);

		// freigeben
			DeleteObjectTree(objectdata->FullName());
		}
	}
	return done-1;
}

int ed_group(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new group;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_bordergroup(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={"TXT",(char*)offsetof(des_object,d_bordergroup.title),"title","Title",(char*)TEXTLEN,"Title",
									"QIT",
								   };
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new bordergroup;
			if (strlen(o->d_bordergroup.title))
				((bordergroup*)o->obj)->Title(o->d_bordergroup.title);
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_spacegroup(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={"INT",(char*)offsetof(des_object,d_spacegroup.space),"space","Space",(char*)INTLEN,"Border",
									"QIT",
								   };
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new spacegroup;
			if (o->d_spacegroup.space>0)
				((spacegroup*)o->obj)->Border(o->d_spacegroup.space);
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_button(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={"TXT",(char*)offsetof(des_object,d_button.text),"text","Text",(char*)TEXTLEN,"Text",
									"QIT",
								   };
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new button;
			((button*)o->obj)->Text(o->d_button.text);
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_fbutton(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={"TXT",(char*)offsetof(des_object,d_fbutton.text),"text","Text",(char*)TEXTLEN,"Text",
									"QIT",
								   };
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new fbutton;
			((fbutton*)o->obj)->Text(o->d_fbutton.text);
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_selbutton(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={"TXT",(char*)offsetof(des_object,d_selbutton.text),"text","Text",(char*)TEXTLEN,"Text",
									"QIT",
								   };
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new selbutton;
			((selbutton*)o->obj)->Text(o->d_selbutton.text);
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_mxbutton(int m,des_object *o)
{
	return 1;
}
int ed_selknob(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={"TXT",(char*)offsetof(des_object,d_selknob.text),"text","Text",(char*)TEXTLEN,"Text",
									"QIT",
								   };
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new selknob;
			((selknob*)o->obj)->Text(o->d_selknob.text);
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_mxknob(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new mxknob;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_checkbox(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={"TXT",(char*)offsetof(des_object,d_selknob.text),"text","Text",(char*)TEXTLEN,"Text",
									"QIT",
								   };
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new checkbox;
			((checkbox*)o->obj)->Text(o->d_checkbox.text);
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_choice(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new choice;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_input(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={"GRP",
									"TXT",(char*)offsetof(des_object,d_input.text),"text","Text",(char*)TEXTLEN,"Text",
									"INT",(char*)offsetof(des_object,d_input.maxchars),"maxchars","max chars",(char*)INTLEN,"MaxChars",
									"GRP",
									"BL1",(char*)offsetof(des_object,d_input.alwaysmode),"alwaysmode","Always mode","AlwaysMode()",
									"BL1",(char*)offsetof(des_object,d_input.integermode),"integermode","Integer mode","IntergerMode()",
									"BL1",(char*)offsetof(des_object,d_input.invisiblemode),"invisiblemode","Invisible mode","InvisibleMode()",
									"QIT",
								   };
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new input;
			((input*)o->obj)->Text(o->d_input.text);
			((input*)o->obj)->MaxChars(o->d_input.maxchars);
			if (o->d_input.alwaysmode)((input*)o->obj)->AlwaysMode();
			if (o->d_input.integermode)((input*)o->obj)->IntegerMode();
			if (o->d_input.invisiblemode)((input*)o->obj)->InvisibleMode();
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			o->d_input.maxchars=64;
			break;
	}
	return 0;
}
int ed_listview(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new listview;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_slider(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={"INT",(char*)offsetof(des_object,d_slider.minval),"minvalue","min value",(char*)INTLEN,"MinValue",
									"INT",(char*)offsetof(des_object,d_slider.maxval),"maxvalue","max value",(char*)INTLEN,"MaxValue",
									"CHO",(char*)offsetof(des_object,d_slider.horiz),"horiz","direction","vertical","Vert()","horizontal","Horiz()",NULL,
									"QIT",
								   };
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new slider;
			((slider*)o->obj)->MinValue(o->d_slider.minval);
			((slider*)o->obj)->MaxValue(o->d_slider.maxval);
			if (o->d_slider.horiz) ((slider*)o->obj)->Horiz();
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			o->d_slider.minval=0;
			o->d_slider.maxval=10;
			break;
	}
	return 0;
}
int ed_scroller(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new scroller;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_ruler(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={"CHO",(char*)offsetof(des_object,d_ruler.horiz),"horiz","direction","horizontal","Horiz()","vertical","Vert()",NULL,
									"INT",(char*)offsetof(des_object,d_ruler.space),"space","Space",(char*)INTLEN,"Space",
									"INT",(char*)offsetof(des_object,d_ruler.offset),"offset","Start offset",(char*)INTLEN,"Offset",
									"QIT",
								   };
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new ruler;
			((ruler*)o->obj)->Space(o->d_ruler.space);
			((ruler*)o->obj)->Offset(o->d_ruler.offset);
			if (o->d_ruler.horiz) ((ruler*)o->obj)->Vert(); else ((ruler*)o->obj)->Horiz();
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			o->d_ruler.space=4;
			o->d_ruler.horiz=0;
			break;
	}
	return 0;
}
int ed_text(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new text;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_output(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={"TXT",(char*)offsetof(des_object,d_output.text),"text","Text",(char*)TEXTLEN,"Text",
									"QIT",
								   };
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new output;
			((output*)o->obj)->Text(o->d_output.text);
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_xclock(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={"BGRP","Seconds",
									"CHO",(char*)offsetof(des_object,d_xclock.showseconds),"showseconds","show seconds","no","NoSeconds()","yes","Seconds()",NULL,
									"CHO",(char*)offsetof(des_object,d_xclock.smallseconds),"smallseconds","second hand","long","LongSeconds()","small","SmallSeconds()",NULL,
									"BGRP","Minutes",
									"CHO",(char*)offsetof(des_object,d_xclock.nominutes),"nominutes","minutes","show","Minutes()","don't show","NoMinutes()",NULL,
									"CHO",(char*)offsetof(des_object,d_xclock.exactminutes),"exactminutes","minutes","nice","NiceMinutes()","exact","ExactMinutes()",NULL,
									"QIT",
								   };
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new xclock;
			if (o->d_xclock.showseconds)
				((xclock*)o->obj)->Seconds();
			if (o->d_xclock.exactminutes)
				((xclock*)o->obj)->ExactMinutes();
			if (o->d_xclock.smallseconds)
				((xclock*)o->obj)->SmallSeconds();
			if (o->d_xclock.nominutes)
				((xclock*)o->obj)->NoMinutes();
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_indicator(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new indicator;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_graphic(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new graphic;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_visible(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new visible;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_card(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new card;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_rubbergroup(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new rubbergroup;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_textbox(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new textbox;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_autotextbox(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new autotextbox;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_htmltextbox(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new htmltextbox;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}
int ed_image(int m,des_object *o)
{
	switch (m)
	{
		case MODE_COMMAND:
			{
				static char *com[]={NULL};
				return (int)com;
			}
			break;
		case MODE_CREATE:
			o->obj=new image;
			break;
		case MODE_FREE:
			delete o->obj;
			break;
		case MODE_SETUP:
			break;
	}
	return 0;
}

