#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include <Xclasses/Xclasses.h>

Xcolors d;
Xwindows w;
XEvent myevent;

group g1,g2,g6,g7,g8,g9,g0,g10,g11;
bordergroup g3,g4,g5;
button b1,b2,b3;
selbutton sw1,sw2;
scroller s1,s2;
slider s3,s4;
input i1,i2,i3;
text t1;

int main(int argc,char *argv[])
{
	char zw[5];
	int r,c=0,ende=0;
	XEvent myevent;

	if (!d.Init(argc,argv))
	{
		printf("Error:\nCan't open display\n\n");
		exit(1);
	}
	
	w.Title("Testfenster");
	w.Create(0,0,400,200);	
	w.Geometry(argc,argv);
	w.IconTitle("Mein Icon");
	w.Background(d.col_background());
	
	b1.Text("-"); b1.ID(1);
	b1.Font(FONT_BIG);
	b2.Text("+"); b2.ID(2);
	b2.Font(FONT_BIG);
	b3.Text("Ende"); b3.ID(3);

	sw1.Text("Lock/Unlock 1"); sw1.ID(7);
	sw1.State(RELEASED);
	sw2.Text("Lock/Unlock 2"); sw2.ID(8);
	sw2.State(RELEASED);


	i1.Text("Position"); i1.ID(4);
	i1.MaxChars(4);
	i1.AlwaysMode();
	i1.Default("0");
	i2.Text("Anzahl"); i2.ID(5);
	i2.MaxChars(4);
	i2.AlwaysMode();
	i2.Default("50");
	i3.Text("Sichtbar"); i3.ID(6);
	i3.MaxChars(4);
	i3.AlwaysMode();
	i3.Default("10");
	s1.Items(50);
	s1.Visible(10);
	s1.ID(10);
	s1.Arrows();
	s2.Items(30);
	s2.Visible(10);
	s2.ID(11);
	s2.Horiz();
	s3.Vert();
	s3.ID(12);
	s3.MaxValue(30);
	s3.MinValue(10);
	s4.Horiz();
	s4.ID(12);
	s4.MaxValue(1000);
	s4.MinValue(950);

	t1.Text("Ein Scroller-Test.");
	t1.Font(FONT_BIG);

	g0.Vert();
	g0.Add(g9);
	g0.Add(g1);
	
	g9.Vert();
	g9.Add(t1);

	g1.Add(g2);
	g1.Add(g5);
	g1.Horiz();

	g2.Vert();	
	g2.Add(g3);
	g2.Add(g4);

	g3.Add(i1);
	g3.Add(i2);
	g3.Add(i3);
	g3.Title("Eingabe");

	g4.Add(g6);
	g6.Horiz();
	g6.Add(g7);
	g7.Vert();
	g7.Add(b1);
	g7.Add(b2);
	g6.Add(g8);
	g8.Vert();
	g8.Add(sw1);
	g8.Add(sw2);

	g4.Add(b3);
	g4.Title("Kontrolle");

	g5.Title("Scroller");
	g5.Vert();
	g5.Add(g10);
	g10.Horiz();
	g10.Add(s1);
	g10.Add(s2);
	g10.Add(s3);
	g5.Add(g11);
	g11.Vert();
	g11.Add(s4);

	g0.Create(w.window());	

	w.MinSize(g0.minWidth(),g0.minHeight());
	w.MaxSize(g0.maxWidth(),g0.maxHeight());
	w.MakeFit();
	w.OpenU(); 
	w.Event(StructureNotifyMask|KeyPressMask);

	do
	{
		r=g0.NextEvent(&myevent);
		if (r==0)
		{
			switch (myevent.type)
			{
				case ConfigureNotify:
					w.Title("Mein gendertes Fenster");
					g0.Resize(w.window());
					break;
			}
		}
		else
		{
			switch(r)
			{
				case 1:
					c=s1.Position();
					s1.Position(c-1);
					break;
				case 2:
					c=s1.Position();
					s1.Position(c+1);
					break;
				case 3:
					ende=1;
					break;
				case 4:
					i1.Input(zw);
					if (strlen(zw)>0)
					{
						s1.Position(atoi(zw));
					}
					break;
				case 5:
					i2.Input(zw);
					if (strlen(zw)>0)
					{
						s1.Items(atoi(zw));
					}
					break;
				case 6:
					i3.Input(zw);
					if (strlen(zw)>0)
					{
						s1.Visible(atoi(zw));
					}
					break;
				case 7:
					if (sw1.State()==PRESSED)
					{
						s1.Lock();
					}
					else
					{
						s1.Unlock();
					}
					break;
				case 8:
					if (sw2.State()==PRESSED)
					{
						s2.Lock();
					}
					else
					{
						s2.Unlock();
					}
					break;
			}
			sprintf(zw,"%d",s1.Position());
			i1.Default(zw);
		}
	}
	while (!ende && !(r==0 && w.IsCloseEvent(&myevent)));

	w.CloseU();
	g0.Free();
	w.Destroy();

}
