#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <ctype.h>
#include <unistd.h>
#include <pwd.h>
//#include <grp.h>
#include <sys/types.h>
#include <sys/time.h>
#include <dirent.h>

// Erweiterungen:
// Benutzerinfo: externes Script starten per Button

#include <Xclasses/Xclasses.h>

XCprogram	myprg("xmanager",
					XCP_Version,"1.2",
					XCP_Copyright,"(c) by Jrgen Schmitz in 1997 - only for FSAI",
					XCP_Author,"Jrgen Schmitz",
					XCP_EMail,"schmitzj@fsai.fh-trier.de",
					XCP_OwnHTML,
			"Dieses Programm wurde zur Benutzerverwaltung auf den Servern "
			"der FSAI geschrieben und dient auerdem als Demo der Xclasses.<p>"
			"Eine anderweitige Verwendung ist nur mit Genemigung des Autors "
			"gestattet!"
		,
					XCP_Done);

#define SGGFONT FONT_SMALL
#define GGFONT FONT_GADGET
#define FIXGGFONT FONT_FIXED
#define BGGFONT FONT_BIG
#define GPFONT FONT_GROUP

#define NAME		0
#define VORNAME		1
#define STRASSE		2
#define ORT			3
#define TELEFON		4
#define GEBURT		5
#define BURO		6
#define BUROTEL		7
#define BERUF		8
#define LOGIN		9
#define MALIAS		10
#define GRUPPE		11
#define HOME		12

#define AN_WERTE	13
#define AN_BREAK	8

char *an_texte[]={"_Name","_Vorname","_Strae","_Ort",
				  "_Telefon","_Geburtsdatum","_Bro",
				  "B_rotelefon","B_eruf","_Login",
				  "_Mail-Alias","G_ruppe","_Homeverzeichnis",
				  };
int an_size[]={20,20,30,30,
			   15,10,10,
			   10,30,8,
			   20,8,40,
			   };
char *an_extratxt[]={"Standard","FSR-AI","Prof-AI",NULL};
appwindow mywindow("Xmanager");

group maingp,ausg;
bordergroup work[4];
text status;
textbox statusio;
input an_input[AN_WERTE];
text an_hinweis[AN_WERTE];
mxknob an_extra;
fbutton anlegen1,pruefen1,leeren1;
fbutton anlegen2,pruefen2,existiert2,loeschen2;
listview antraege;

input p_create,p_del,p_lpr,p_motd,p_defgruppe,p_defhome,p_basecolor,p_aliasfile;
input p_antraege,p_antraegekopien;
fbutton p_save,p_cancel,p_testdruck;
mxknob p_homename;
char *homenamewahl[]={"keine Vorgabe","Gruppe an Verzeichnis hngen",NULL};

popup an_group_cont;
menu mymenu;

int modus=0;
char buf[400];

#define UEBER		0
#define PREFS		1
#define ANLEGEN		2
#define INFO		3
#define LOESCHEN	3

text ueber_txt1,ueber_txt2,ueber_txt3,ueber_txt4;
ruler ueber_rl1,ueber_rl2;
void gui_ueber(void)
{
	work[UEBER].Center();
	 ueber_txt1.Font("-*-times-bold-r-*-*-40-*-*-*-*-*-*-*");
	 ueber_txt1.Center(),
	 ueber_txt1.Text("x m a n a g e r\n ");
	work[UEBER].Add(ueber_txt1);
	 ueber_txt2.Font(BGGFONT);
	 ueber_txt2.Center(),
	 ueber_txt2.Text("Benutzerverwaltung unter X-Windows\n"
					 "mit Xclasses von Jrgen Schmitz\n"
					 "(c) 1996 by Jrgen Schmitz");
	work[UEBER].Add(ueber_txt2);
	 ueber_rl1.Horiz();
	 ueber_rl1.Space(5);
	work[UEBER].Add(ueber_rl1);
	 ueber_txt3.Font(GGFONT);
	 ueber_txt3.Center(),
	 ueber_txt3.Text("Menauswahl ber die Liste\n"
					 "am linken Rand.\n"
					 "Das Fenster kann in seiner Gre verndert werden,\n"
					 "alle Objekte ndern dabei auch ihre Gre und Position\n"
					 "um optimal sichtbar zu sein.");
	work[UEBER].Add(ueber_txt3);
	 ueber_rl2.Horiz();
	 ueber_rl2.Space(5);
	work[UEBER].Add(ueber_rl2);
	 ueber_txt4.Font(GGFONT);
	 ueber_txt4.Center(),
	 ueber_txt4.Text("Vorhandene Benutzerantrge: -");
	work[UEBER].Add(ueber_txt4);
}
char ueber_txt[100];
void ueber_update(void)
{
	sprintf(ueber_txt,"Vorhandene Benutzerantrge: %d",antraege.Count());
	ueber_txt4.Text(ueber_txt);
}

void setgroups(gadget *,int);
ruler an_rl1,an_rl2;
group an_sgp[2],an_bgp;
void gui_benutzer(void)
{
	gfx_text dummy;
	for(int i=0;i<AN_WERTE;i++)
	{
		 an_input[i].Font(GGFONT);
		 an_input[i].ID(101+i);
		 an_input[i].Text(an_texte[i]);
		 an_input[i].MaxChars(an_size[i]);
		 an_input[i].AlwaysMode();
		work[ANLEGEN].Add(an_input[i]);
		if (i==LOGIN || i==MALIAS)
		{
			an_hinweis[i].Font(SGGFONT);
		 	an_hinweis[i].Text("Return in Name und Vorname erzeugt Eintrag");
			work[ANLEGEN].Add(an_hinweis[i]);
		}
		if (i==AN_BREAK)
		{
			an_rl1.Horiz();
			an_rl1.Space(5);
			work[ANLEGEN].Add(an_rl1);
		}
		if (i==GRUPPE)
		{
			an_input[i].ContextPopup(an_group_cont);
		}
	}
	 an_input[AN_WERTE-1].ID(AN_WERTE-1);
	 
	 an_extra.Horiz();
	 an_extra.Font(GGFONT);
	 an_extra.Items(an_extratxt);
	work[ANLEGEN].Add(an_extra);	 

	 an_rl2.Horiz();
	 an_rl2.Space(5);
	work[ANLEGEN].Add(an_rl2);
	 an_sgp[0].Horiz();
	 an_sgp[1].Horiz();
//	 an_sgp[0].DialogMode();
	 an_sgp[0].Right();
	 an_sgp[1].Right();
	work[ANLEGEN].Add(an_sgp[0]);
	 an_sgp[0].AddShadow(an_sgp[1]);
	  pruefen1.Font(GGFONT);
	  pruefen1.ID(151);
	  pruefen1.Text("prfen");
	 an_sgp[0].Add(pruefen1);
	  anlegen1.Font(GGFONT);
	  anlegen1.ID(152);
	  anlegen1.Text("anlegen");
	 an_sgp[0].Add(anlegen1);
	  leeren1.Font(GGFONT);
	  leeren1.ID(157);
	  leeren1.Text("lschen");
	 an_sgp[0].Add(leeren1);
	 an_sgp[1].Add(an_bgp);
//	  an_bgp.DialogMode();
	  an_bgp.Horiz();
	   pruefen2.Font(GGFONT);
	   pruefen2.ID(151);
	   pruefen2.Text("prfen");
	   pruefen2.Lock();
	  an_bgp.Add(pruefen2);
	   anlegen2.Font(GGFONT);
	   anlegen2.ID(153);
	   anlegen2.Text("anlegen");
	   anlegen2.Lock();
	  an_bgp.Add(anlegen2);
	   existiert2.Font(GGFONT);
	   existiert2.ID(154);
	   existiert2.Text("existiert");
	   existiert2.Lock();
	  an_bgp.Add(existiert2);
	   loeschen2.Font(GGFONT);
	   loeschen2.ID(155);
	   loeschen2.Text("lschen");
	   loeschen2.Lock();
	  an_bgp.Add(loeschen2);
	  antraege.Font(FIXGGFONT);
	  antraege.ID(156);
	  antraege.ShowSelected();
	 an_sgp[1].Add(antraege);

	an_group_cont.AddHeadline("Gruppen");
	an_group_cont.Add("fsai","1",1);
	an_group_cont.Add("user","2",2);
	an_group_cont.Add("wheel","3",3);
	an_group_cont.ID(setgroups);
}

void read_config(void);
void write_config(void);
void testdruck(void);
void read_antraege(void);

ruler p_rl1,p_rl2,p_rl3;
group p_gp1;
void gui_prefs(void)
{
	 p_create.Font(GGFONT);
	 p_create.Text("Create-User Script:");
	 p_create.MaxChars(100);
	 p_create.HelpText("Script zum Anlegen des Benutzers.\n"
					   "Aufrufoptionen:\n"
					   "<loginname> <ges.name> <mail-alias> <home>\n <gruppe> <passwort> <telefon> <bro> <bro-tel> <extra>\n"
					   "");
	work[PREFS].Add(p_create);
	 p_del.Font(GGFONT);
	 p_del.Text("Delete-User Script:");
	 p_del.MaxChars(100);
	 p_del.HelpText("Script zum lschen des Benutzers.\n"
					"Aufrufoptionen:\n"
					"<loginname> <homedir>\n"
					"");
	work[PREFS].Add(p_del);
	 p_lpr.Font(GGFONT);
	 p_lpr.Text("Druckbefehl:");
	 p_lpr.MaxChars(100);
	 p_lpr.HelpText("Befehl zum Ausdrucken des Antrags.\n"
					"Aufruf ber Pipe."
					"");
	work[PREFS].Add(p_lpr);
	 p_motd.Font(GGFONT);
	 p_motd.Text("Werbe-Text:");
	 p_motd.MaxChars(100);
	 p_motd.HelpText("Text, der unten den Ausdruck gesetzt werden\nsoll, z.B. fr Hinweise.");
	work[PREFS].Add(p_motd);
	 p_aliasfile.Font(GGFONT);
	 p_aliasfile.Text("Mail-Alias File:");
	 p_aliasfile.MaxChars(100);
	work[PREFS].Add(p_aliasfile);
	 p_antraege.Font(GGFONT);
	 p_antraege.Text("Antrge in Verzeichnis:");
	 p_antraege.MaxChars(100);
	 p_antraege.ID((void (*)(gadget *, int))read_antraege);
	work[PREFS].Add(p_antraege);
	 p_antraegekopien.Font(GGFONT);
	 p_antraegekopien.Text("Antrge kopieren nach:");
	 p_antraegekopien.MaxChars(100);
//	 p_antraegekopien.ID((void (*)(gadget *, int))read_antraege);
	work[PREFS].Add(p_antraegekopien);

	 p_rl1.Horiz();
	 p_rl1.Space(4);
	work[PREFS].Add(p_rl1);
	 p_defgruppe.Font(GGFONT);
	 p_defgruppe.Text("Gruppenvorgabe:");
	 p_defgruppe.MaxChars(20);
	 p_defgruppe.HelpText("Standardgruppe fr neue Benutzer.");
	work[PREFS].Add(p_defgruppe);
	 p_defhome.Font(GGFONT);
	 p_defhome.Text("Homevorgabe:");
	 p_defhome.MaxChars(100);
	 p_defhome.HelpText("Prefix des Homeverzeichnis (z.B. /home)");
	work[PREFS].Add(p_defhome);
	 p_homename.Font(GGFONT);
	 p_homename.Horiz();
	 p_homename.Items(homenamewahl);
     p_homename.Selected(1);
	work[PREFS].Add(p_homename);

	 p_rl3.Horiz();
	 p_rl3.Space(4);
	work[PREFS].Add(p_rl3);
	 p_basecolor.Font(GGFONT);
	 p_basecolor.Text("Programmfarbe:");
	 p_basecolor.MaxChars(20);
	 p_basecolor.HelpText("X11 Farbbezeichner\nwird erst nach einem\nProgrammneustart sichtbar");
	work[PREFS].Add(p_basecolor);


	 p_rl2.Horiz();
	 p_rl2.Space(4);
	work[PREFS].Add(p_rl2);
	 p_gp1.Horiz();
	 p_gp1.DialogMode();
	 
	  p_save.Font(GGFONT);
	  p_save.ID((void (*)(gadget *, int))write_config);
	  p_save.Text("Speichern");
	 p_gp1.Add(p_save);

	  p_testdruck.Font(GGFONT);
	  p_testdruck.ID((void (*)(gadget *, int))testdruck);
	  p_testdruck.Text("Testseite drucken");
	 p_gp1.Add(p_testdruck);

	  p_cancel.Font(GGFONT);
	  p_cancel.ID((void (*)(gadget *, int))read_config);
	  p_cancel.Text("zuletzt gespeicherte Werte");
	 p_gp1.Add(p_cancel);
	work[PREFS].Add(p_gp1);
}
ruler bir1;
bordergroup	bilg,big1,big2,big2_2;
group bipwg,bivisgp;
visible bivis;

input bi_login,bi_passwd;
output bi_name,bi_gruppe,bi_home,bi_groesse,bi_hinweis;
fbutton bi_loginsuchen,bi_pw_zufall,bi_pw_set;
fbutton bi_loeschen;
selbutton bi_sicher;
dirview bi_dirlist;
lefttext bi_ltdummy1;

void gui_binfo(void)
{
	 bilg.Horiz();
	 bilg.Font(GPFONT);
	 bilg.UseSmallest();
	 bilg.Title("Login");
	work[INFO].Add(bilg);
 	  bi_login.MaxChars(8);
	  bi_login.Text("Login:");
	  bi_login.Font(GGFONT);
	  bi_login.ID(200);
	 bilg.Add(bi_login);
	  bi_loginsuchen.Font(GGFONT);
	  bi_loginsuchen.ID(200);
	  bi_loginsuchen.Text("suchen");
	 bilg.Add(bi_loginsuchen);
	 
	 bir1.Horiz();
	 bir1.Space(10);
	work[INFO].Add(bir1);
	 big1.Vert();
	 big1.Font(GPFONT);
	 big1.Title("Userdaten");
	 big1.YDistance(1);
	work[INFO].Add(big1);
	 big1.Add(bivis);
	 bivis.Apply(bivisgp);
	  bivisgp.Vert();
	  bivisgp.YDistance(1);
	   bi_name.Font(GGFONT);
	   bi_name.Text("Name:");
	  bivisgp.Add(bi_name);
	   bi_gruppe.Font(GGFONT);
	   bi_gruppe.Text("Gruppe:");
	  bivisgp.Add(bi_gruppe);
	   bi_hinweis.Font(GGFONT);
	   bi_hinweis.Text("Vermerke:");
	  bivisgp.Add(bi_hinweis);
	   bi_home.Font(GGFONT);
	   bi_home.Text("Homeverzeichnis:");
	  bivisgp.Add(bi_home);
	   bi_groesse.Font(GGFONT);
	   bi_groesse.Text("Verzeichnisgre:");
	  bivisgp.Add(bi_groesse);
	   bi_dirlist.ShowPeriod();
	   bi_dirlist.SetDir("/");
	   bi_ltdummy1.Gadget(bi_dirlist);
	  bivisgp.Add(bi_ltdummy1);

	
	 big2.Vert();
	 big2.Font(GPFONT);
	 big2.Title("ndern");
	work[INFO].Add(big2);
	  bipwg.Horiz();
	  bipwg.UseSmallest();
	 big2.Add(bipwg);
	  bi_passwd.Font(GGFONT);
	  bi_passwd.MaxChars(8);
	  bi_passwd.Text("neues Passwort:");
	 bipwg.Add(bi_passwd);
	  bi_pw_zufall.Text("generieren");
	  bi_pw_zufall.ID(201);
	  bi_pw_zufall.Font(GGFONT);
	  bi_pw_zufall.Weight(50);
	 bipwg.Add(bi_pw_zufall);
	  bi_pw_set.Text("ndern...");
	  bi_pw_set.ID(202);
	  bi_pw_set.Font(GGFONT);
	  bi_pw_set.Weight(50);
	 bipwg.Add(bi_pw_set);
	 big2.AddShadow(big2_2);
	  big2_2.Horiz();
	  big2_2.Font(GPFONT);
	  big2_2.Title("Lschen");
	  big2_2.UseSmallest();
	  big2_2.DialogMode();
	  big2_2.Add(bi_sicher);
	   bi_sicher.Font(GGFONT);
	   bi_sicher.Text("Sicher?\nSchalter aktivieren");
	   bi_sicher.ID(250);
	  big2_2.Add(bi_loeschen);
	   bi_loeschen.Font(GGFONT);
	   bi_loeschen.ID(251);
	   bi_loeschen.Text("Account\nlschen");
}

int System(char *com)
{
	FILE *datei;
	char buf[100];

	if (datei=popen(com,"r"))
	{
		while (!feof(datei))
		{
			if (fgets(buf,sizeof(buf),datei))
			{
				statusio.AppendText(buf); mywindow.Update();
			}
		}
		pclose(datei);
	}
	return 0;
}
int dirsize(char *dir)
{
	FILE *datei;
	char buf[100],com[300];
	int size=0;

	sprintf(com,"du -ks %s",dir);
	if (datei=popen(com,"r"))
	{
		while (!feof(datei))
		{
			if (fgets(buf,sizeof(buf),datei))
			{
				statusio.AppendText(buf); mywindow.Update();
				sscanf(buf,"%d",&size);
			}
		}
		pclose(datei);
	}
	return size;
}

char *rpasswd(void)
{
	static char pw[10];
	int i;
	struct timeval tv;

	gettimeofday(&tv,NULL);
	
	srand(tv.tv_usec+tv.tv_sec);	
	for(i=0;i<8;i++)
	{
		pw[i]=(char)(random()%26+97);
	}
	pw[i]=0;
	return pw;
}

void drucke(char *txt)
{
	FILE *datei;
	p_lpr.Input(buf);

	if (datei=fopen("/root/printed","w"))
	{
		fwrite(txt,strlen(txt),1,datei);
		fclose(datei);
	}

	strcat(buf," 2>&1");	
	if (datei=popen(buf,"w"))
	{
		fwrite(txt,strlen(txt),1,datei);
		pclose(datei);
		status.Text("Druckauftrag abgeschickt");
	}
}
void druckeTEX(char *txt)
{
	static int cc=0;
	FILE *datei;
	char com[300],fname[100];
	p_lpr.Input(buf);

	cc++;
	sprintf(fname,"/root/antrag/printed_%d.tex",cc);
	if (datei=fopen(fname,"w"))
	{
		fwrite(txt,strlen(txt),1,datei);
		fclose(datei);
	}

	sprintf(fname,"/root/antrag/printed_%d",cc);
	sprintf(com,"printit.sh %s %s",fname,buf);
	system(com);
	status.Text("Druckauftrag abgeschickt");
}
void chpasswd(char *login,char *pw)
{
	FILE *datei;
	
	if (datei=popen("chpasswd","w"))
	{
		fprintf(datei,"%s:%s\n",login,pw);
		pclose(datei);
	}
}

void testdruck(void)
{
	status.Text("drucke Testseite..."); //mainwin.Update();
	mywindow.Update();
	drucke(
"                       xmanager\n\n"
"                Benutzerverwaltung unter X11\n\n"
"-----------------------------------------------------------\n"
"Probeausdruck                                 Probeausdruck\n"
"  Probeausdruck                             Probeausdruck\n"
"    Probeausdruck                         Probeausdruck\n"
"      Probeausdruck                     Probeausdruck\n"
"        Probeausdruck                 Probeausdruck\n"
"          Probeausdruck             Probeausdruck\n"
"            Probeausdruck         Probeausdruck\n"
"              Probeausdruck     Probeausdruck\n"
"                Probeausdruck Probeausdruck\n"
"-----------------------------------------------------------\n");
}

config c("xmanager");
char prefs_c[10][100]={"","","lpr","",
				"/etc/alias","/var/spool/antr",
				"/var/spool/antr_bak","user","/home",
				"#c0c0c0"};
int home=0;
configopts o[]={
			{"S100:create",prefs_c[0]},
			{"S100:delete",prefs_c[1]},
			{"S100:printer",prefs_c[2]},
			{"S100:motd",prefs_c[3]},
			{"S100:alias",prefs_c[4]},
			{"S100:antraege",prefs_c[5]},
			{"S100:antraegekopien",prefs_c[6]},
			{"S100:defgruppe",prefs_c[7]},
			{"S100:defhome",prefs_c[8]},
			{"S100:basecolor",prefs_c[9]},
			{"I:homename",(char*)&home},
			{NULL,NULL}};

void set_config(void)
{
	p_create.Default(prefs_c[0]);
	p_del.Default(prefs_c[1]);
	p_lpr.Default(prefs_c[2]);
	p_motd.Default(prefs_c[3]);
	p_aliasfile.Default(prefs_c[4]);
	p_antraege.Default(prefs_c[5]);
	p_antraegekopien.Default(prefs_c[6]);
	p_defgruppe.Default(prefs_c[7]);
	p_defhome.Default(prefs_c[8]);
	p_basecolor.Default(prefs_c[9]);
//	p_homename.Selected(home);
}
void read_config(void)
{
	c.SetItems(o);
	if (!c.Read())
	{
		status.Text("Einstellungen gelesen");
		set_config();
	}
}
void write_config(void)
{
	p_create.Input(prefs_c[0]);
	p_del.Input(prefs_c[1]);
	p_lpr.Input(prefs_c[2]);
	p_motd.Input(prefs_c[3]);
	p_aliasfile.Input(prefs_c[4]);
	p_antraege.Input(prefs_c[5]);
	p_antraegekopien.Input(prefs_c[6]);
	p_defgruppe.Input(prefs_c[7]);
	p_defhome.Input(prefs_c[8]);
	p_basecolor.Input(prefs_c[9]);
	home=p_homename.Selected();

	c.SetItems(o);
	if (!c.Write())
	{
		status.Text("Einstellungen gesichert");
	}
	else
	{
		status.Text("Fehler:\nEinstellungen nicht geschrieben!");
	}
}
void umlaute(char *quelle,char *ziel)
{ // Umlaute raus
	int j=0;
	for(int i=0;i<strlen(quelle);i++)
	{
		if (quelle[i]=='')
		{
			ziel[j]='a'; j++;
			ziel[j]='e';
		}
		else if (quelle[i]=='')
		{
			ziel[j]='A'; j++;
			ziel[j]='e';
		}
		else if (quelle[i]=='')
		{
			ziel[j]='o'; j++;
			ziel[j]='e';
		}
		else if (quelle[i]=='')
		{
			ziel[j]='O'; j++;
			ziel[j]='e';
		}
		else if (quelle[i]=='')
		{
			ziel[j]='u'; j++;
			ziel[j]='e';
		}
		else if (quelle[i]=='')
		{
			ziel[j]=''; j++;
			ziel[j]='e';
		}
		else if (quelle[i]=='')
		{
			ziel[j]='s'; j++;
			ziel[j]='s';
		}
		else
		{
			ziel[j]=quelle[i];
		}
		j++;
	}
	ziel[j]=0;
}
void make_login(void)
{
	char name[an_size[NAME]*2+1],vorname[an_size[VORNAME]*2+1];

	an_input[NAME].Input(buf);
	umlaute(buf,name);
	an_input[NAME].Default(name);
	an_input[VORNAME].Input(buf);
	umlaute(buf,vorname);
	an_input[VORNAME].Default(vorname);

	buf[0]=vorname[0];
	buf[1]='.';
	buf[2]=0;
	strcat(buf,name);
	an_input[MALIAS].Default(buf);

	for(int i=0;i<strlen(name);i++)
	{
		name[i]=tolower(name[i]);
	}
	vorname[0]=tolower(vorname[0]);
	vorname[1]=0;
	strcpy(buf,name);
	buf[7]=0;
	strcat(buf,vorname);
	an_input[LOGIN].Default(buf);
}
void set_home(void)
{
	p_defhome.Input(buf);
	if (p_homename.Selected()==1)
	{
		if (strlen(buf))
		{
			char grp[an_size[GRUPPE]+1];
			if (buf[strlen(buf)-1]!='/') strcat(buf,"/");
			an_input[GRUPPE].Input(grp);
			strcat(buf,grp);
		}
	}
	if (strlen(buf))
	{
		char lg[an_size[LOGIN]+1];
		if (buf[strlen(buf)-1]!='/') strcat(buf,"/");
		an_input[LOGIN].Input(lg);
		strcat(buf,lg);
	}
	an_input[HOME].Default(buf);
}
void setgroups(gadget *,int)
{
	switch (an_group_cont.PID())
	{
		case 1:
			an_input[GRUPPE].Default("fsai");
			break;
		case 2:
			an_input[GRUPPE].Default("user");
			break;
		case 3:
			an_input[GRUPPE].Default("wheel");
			break;
	}
	set_home();
}
void pruefen(void)
{
	char name[an_size[NAME]*2+1],vorname[an_size[VORNAME]*2+1];
	char login[an_size[LOGIN]+1],malias[an_size[MALIAS]+1];
	struct passwd *pw;

	an_input[LOGIN].Input(buf);
	if (!strlen(buf)) make_login();

	an_input[NAME].Input(buf);
	umlaute(buf,name);
	an_input[NAME].Default(name);
	an_input[VORNAME].Input(buf);
	umlaute(buf,vorname);
	an_input[VORNAME].Default(vorname);
	an_input[LOGIN].Input(login);
	an_input[MALIAS].Input(malias);

	an_hinweis[LOGIN].Text("");
	an_hinweis[MALIAS].Text("");

	if (pw=getpwnam(login))
	{
		sprintf(buf,"Login existiert bereits fr %s.",pw->pw_gecos);
		an_hinweis[LOGIN].Text(buf);
		existiert2.Unlock();
		anlegen1.Lock(); anlegen2.Lock();
	}
	else
	{
		existiert2.Lock();
		if (strlen(login))
		{
			anlegen1.Unlock(); anlegen2.Unlock();
		}
	}
	if (strlen(malias))
	{
		FILE *datei;
		char name[100];
		int i;
		p_aliasfile.Input(buf);

		if (malias[strlen(malias)-1]=='\n')
		{
			malias[strlen(malias)-1]=0;
		}
		if (datei=fopen(buf,"r"))
		{
			while (!feof(datei))
			{
				if (fgets(name,sizeof(name),datei))
				{
					if (name[strlen(name)-1]=='\n')
					{
						name[strlen(name)-1]=0;
					}
					if (strncasecmp(malias,name,strlen(malias))==0)
					{
						i=0;
						while (i<strlen(name) && name[i]!=':' ) i++;
						i++;
						while (i<strlen(name) && name[i]==' ' ) i++;
						sprintf(buf,"Mail-Alias existiert bereits fr Account %s.",&name[i]);
						an_hinweis[MALIAS].Text(buf);
						existiert2.Unlock();
						anlegen1.Lock(); anlegen2.Lock();
					}
				}
			}
			fclose(datei);
		}
	}

	status.Text("Benutzerdaten geprft.");	
}

void read_antraege(void)
{
	struct dirent **namelist;
	int n,l;
	char *nme,txt[100];

	p_antraege.Input(buf);
	l=strlen(buf);
	antraege.RemoveAll();

	if ((n=scandir(buf, &namelist, 0, alphasort))>0)
	{
		if (buf[l-1]!='/')
		{
			strcat(buf,"/");
			l++;
		}
		for(int i=2;i<n;i++)
		{
			sprintf(txt," %2d (%s)",i-1,namelist[i]->d_name);
			if (nme=(char*)malloc(l+strlen(namelist[i]->d_name)+1))
			{
				strcpy(nme,buf);
				strcat(nme,namelist[i]->d_name);
				antraege.AddAtEnd(txt,nme);
			}
		}
	}
}
void read_antrag(void)
{
	char *fname,name[100];
	FILE *datei;
	int i=0;
					
	fname=(char*)antraege.GetData(antraege.Selected());
	if (datei=fopen(fname,"r"))
	{
		while (!feof(datei))
		{
			if (fgets(name,sizeof(name),datei))
			{
				if (name[strlen(name)-1]=='\n')
				{
					name[strlen(name)-1]=0;
				}
				switch(i)
				{
					case 0:
						an_input[VORNAME].Default(name);
						break;
					case 1:
						an_input[NAME].Default(name);
						make_login(); pruefen();
						break;
					case 2:
						an_input[STRASSE].Default(name);
						break;
					case 3:
						an_input[ORT].Default(name);
						break;
					case 4:
						an_input[TELEFON].Default(name);
						break;
					case 5:
						an_input[GEBURT].Default(name);
						break;
					case 6:
						an_input[BERUF].Default(name);
						break;
					case 7:
						an_input[BURO].Default(name);
						break;
					case 8:
						an_input[BUROTEL].Default(name);
						break;
				}
				i++;
			}
		}
		fclose(datei);
		an_extra.Selected(0);
		p_defgruppe.Input(buf);
		an_input[GRUPPE].Default(buf);
		set_home();
	}
}
void clear_form(void)
{
	anlegen2.Lock();
	existiert2.Lock();
	loeschen2.Lock();
	pruefen2.Lock();
	antraege.Remove(antraege.Selected());
	antraege.Selected(0);
	for(int i=0;i<AN_WERTE;i++)
	{
		an_input[i].Default("");
		an_hinweis[i].Text("");
	}
}
char *datum(void)
{
	static char d[14];
	time_t t;
	struct tm *ttm;
	time(&t);	
	ttm=localtime(&t);
	strftime(d,sizeof(d),"%d.%m.%Y",ttm);
	return d;
}
#include "benutzer.tex.h"
#include "original.tex.h"
char *userdaten1(char (*b)[60])
{
	static char ud[1000];
	
	sprintf(ud,"      Login        : %s\n"
			   "      Gruppe       : %s\n"
			   "      Mail-Alias   : %s\n\n"
			   "      Name         : %s\n"
			   "      Vorname:     : %s\n\n"
			   "      Strasse      : %s\n"
			   "      PLZ, Ort     : %s\n\n"
			   "      Telefon      : %s\n"
			   "      Geburtsdatum : %s\n\n"
			   "      Beruf/Fach   : %s\n"
			   "      Buero        : %s\n"
			   "      Buero-Telefon: %s",
			   b[LOGIN],b[GRUPPE],b[MALIAS],
			   b[NAME],b[VORNAME],b[STRASSE],
			   b[ORT],b[TELEFON],b[GEBURT],
			   b[BERUF],b[BURO],b[BUROTEL]);
	return ud;
}
char *userdaten2(char (*b)[60],char *pw)
{
	static char ud[1000];
	
	sprintf(ud,"      Name         : %s\n"
			   "      Vorname:     : %s\n\n"
			   "      Strasse      : %s\n"
			   "      PLZ, Ort     : %s\n\n"
			   "      Telefon      : %s\n"
			   "      Geburtsdatum : %s\n\n"
			   "      Beruf/Fach   : %s\n"
			   "      Buero        : %s\n"
			   "      Buero-Telefon: %s\n\n"
			   "      Login        : %s\n\n"
			   "      Mail-Alias   : %s\n"
			   "      Gruppe       : %s\n\n"
			   "      Passwort     : %s\n"
			   "      (unbedingt nach dem ersten Login aendern! Befehl: 'passwd')",
			   b[NAME],b[VORNAME],b[STRASSE],
			   b[ORT],b[TELEFON],b[GEBURT],
			   b[BERUF],b[BURO],b[BUROTEL],
			   b[LOGIN],b[MALIAS],b[GRUPPE],pw);
	return ud;
}
char *motd(void)
{
	static char txt[2000];
	FILE *datei;
	p_motd.Input(buf);

	txt[0]=0;	
	if (datei=fopen(buf,"r"))
	{
		while (!feof(datei))
		{
			if (fgets(buf,sizeof(buf),datei))
			{
				strncat(txt,"    ",sizeof(txt));
				strncat(txt,buf,sizeof(txt));
			}
		}
		fclose(datei);
		txt[sizeof(txt)-1]=0;
	}
	return txt;
}
void anlegen(int ext=0,char *epw=NULL)
{
	static char com[800],drk[3800],pw[12];
	char b[AN_WERTE][60];
	int extra=0;
	easy_dialog hinweis;

	if (ext)
		strcpy(pw,epw);
	else
		strcpy(pw,rpasswd());

	extra=an_extra.Selected();
	for(int i=0;i<AN_WERTE;i++)	an_input[i].Input(b[i]);

	if (!strlen(b[NAME]))
	{
		hinweis.Text("Fehler:\nEs wurde kein Name angegeben.");
		hinweis.Options("Ok");
		hinweis.Start(mywindow);
		return;
	}
	if (!strlen(b[VORNAME]))
	{
		hinweis.Text("Fehler:\nEs wurde kein Vorname angegeben.");
		hinweis.Options("Ok");
		hinweis.Start(mywindow);
		return;
	}
	if (!strlen(b[LOGIN]))
	{
		hinweis.Text("Fehler:\nEs wurde kein Login angegeben.");
		hinweis.Options("Ok");
		hinweis.Start(mywindow);
		return;
	}
	if (!strlen(b[MALIAS]))
	{
		hinweis.Text("Fehler:\nEs wurde kein Mail-Alias angegeben.");
		hinweis.Options("Ok");
		hinweis.Start(mywindow);
		return;
	}
	if (!strlen(b[GRUPPE]))
	{
		hinweis.Text("Fehler:\nEs wurde keine Gruppe angegeben.");
		hinweis.Options("Ok");
		hinweis.Start(mywindow);
		return;
	}
	if (!strlen(b[HOME]))
	{
		hinweis.Text("Fehler:\nEs wurde kein Homeverzeichnis angegeben.");
		hinweis.Options("Ok");
		hinweis.Start(mywindow);
		return;
	}

/*
	sprintf(drk,"\n"
			    "      Benutzerantrag fuer Rechner FSAI - Original\n"
				"      ===========================================\n\n"
				"%s\n\n\n"
				"      Benutzer eingerichtet\n\n"
				"      %10s _____________________\n"
				"                          (Unterschrift)\n\n\n"
				"      Antrag bestaetigt, Benutzerordnung anerkannt:\n\n\n"
				"       __________   _____________________________\n"
				"       (Datum)      (Accountnehmer)\n\n\n"
				"                    _____________________________\n"
				"                    (uebergeben - Fachschaft)\n"
	            "\f\n"
				"      Benutzerantrag fuer Rechner FSAI - Benutzerkopie\n"
				"      ================================================\n\n"
				"%s\n\n"
				"   --------------------------------------------------------------------\n"
				"    E-Mail Adresse: %s@fsai.fh-trier.de\n"
				"        alternativ: %s@fsai.fh-trier.de\n"
				"   --------------------------------------------------------------------\n"
				"%s\n"
				"   --------------------------------------------------------------------\n"
				"                                        Das FSAI - Systemverwalter Team\n"
				,userdaten1(b),datum()
				,userdaten2(b,pw),b[LOGIN],b[MALIAS],motd());
*/

	sprintf(drk,originalTEX,
		ext?"\\\\--- ACCOUNT EXISTIERT BEREITS ---":"",
		b[LOGIN],b[GRUPPE],b[MALIAS],b[NAME],b[VORNAME],
		b[STRASSE],b[ORT],b[TELEFON],b[GEBURT],b[BERUF],
		b[BURO],b[BUROTEL],datum());
	druckeTEX(drk);

	sprintf(drk,benutzerTEX,
		ext?"\\\\--- ACCOUNT EXISTIERT BEREITS ---":"",
		b[NAME],b[VORNAME],b[STRASSE],b[ORT],b[TELEFON],
		b[GEBURT],b[BERUF],b[BURO],b[BUROTEL],b[LOGIN],
		b[MALIAS],b[GRUPPE],pw,b[LOGIN],b[MALIAS],motd());
	druckeTEX(drk);

	if (!ext)
	{
		p_create.Input(buf);
		sprintf(com,"%s %s \"%s %s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" %d",
				 buf,
				 	b[LOGIN],
				 		 b[VORNAME],
				 		 	b[NAME],
				 		 		   b[MALIAS],
				 		 		   	      b[HOME],
				 		 		   	             b[GRUPPE],
				 		 		   	                    pw,
				 		 		   	                	       b[TELEFON],
				 		 		   	                	              b[BURO],
				 		 		   	                	                     b[BUROTEL],extra);
		System(com);
	}
}
void existiert(void)
{
	static char pw[12];
	char b[AN_WERTE][60];
	int extra=0;

	extra=an_extra.Selected();
	for(int i=0;i<AN_WERTE;i++)	an_input[i].Input(b[i]);

	strcpy(pw,rpasswd());
	anlegen(1,pw);
	chpasswd(b[LOGIN],pw);
}
void verschiebe_antrag(void)
{
	char *fname,com[300];
	fname=(char*)antraege.GetData(antraege.Selected());
	p_antraegekopien.Input(buf);
	sprintf(com,"mv %s %s/",fname,buf);
	System(com);
}
void loesche_antrag(void)
{
	easy_dialog yesno;
	yesno.Text("Diesen Antrag wirklich lschen?");
	yesno.Options("Ja|Nein");
	if (yesno.Start(mywindow)==1)
	{
		char *fname;
		fname=(char*)antraege.GetData(antraege.Selected());
		remove(fname);
		clear_form();
	}
}
void info_suchen(void)
{
	FILE *datei;
	struct passwd *pw;
	struct sys_group {
		char    *gr_name;
		char    *gr_passwd;
		gid_t   gr_gid;
		char    **gr_mem;
	} *gp;
	static char gruppe[30],name[40],dir[100],hinweis[200];

	mywindow.MCursor(XC_watch);
	bi_login.Input(buf);
	
	if (pw=getpwnam(buf))
	{
		strcpy(name,pw->pw_gecos);
		strcpy(dir,pw->pw_dir);
		bi_name.Output(name);
		bi_home.Output(dir);
		if (gp=(sys_group*)getgrgid(pw->pw_gid))
		{
			strcpy(gruppe,gp->gr_name);
			bi_gruppe.Output(gruppe);
		}
		bi_dirlist.SetDir(dir);
		sprintf(buf,"%d Bytes",dirsize(dir));
		bi_groesse.Output(buf);

		hinweis[0]=0;
		sprintf(buf,"%s/.forward",dir);
		if (datei=fopen(buf,"r"))
		{
			fclose(datei);
			strcat(hinweis,"mail forward  ");
		}

		bi_hinweis.Output(hinweis);
	}
	else
	{
		status.Text("Account nicht gefunden!");
		bi_name.Output("");
		bi_home.Output("");
		bi_gruppe.Output("");
		bi_groesse.Output("");
		bi_hinweis.Output("");
		bi_dirlist.SetDir("/");
	}
	mywindow.MCursor(-1);	// undocumentated feature!
}
void loesche_benutzer(void)
{
	char com[300],name[10],dir[200];
	struct passwd *pw;

	bi_login.Input(name);
	if (pw=getpwnam(name))
	{
		strcpy(dir,pw->pw_dir);
		p_del.Input(buf);
		sprintf(com,"%s %s %s",buf,name,dir);
		System(com);
		bi_login.Default("");
		info_suchen();
	}
}

int main(int argc,char *argv[])
{
	int ende=0,w;

	p_basecolor.Default("#b0b0c0");
	read_config();
	p_basecolor.Input(buf);

	mywindow.InitSize(0,0,500,100);
	if (!mywindow.Init(argc,argv,buf))
	{
		printf("Error: Can't open display\n");
		exit(1);
	}
	mywindow.Title("XMANAGER user manager - (c) Jrgen Schmitz");
	mywindow.IconTitle("XMANAGER");

	bordergroup ctl;
	ctl.Title("Kontrolle");
	ctl.Font(GPFONT);
	ctl.Weight(80);
	ctl.Vert();
	 listview ctl_lv;
	 ctl_lv.Font(SGGFONT);
	 ctl_lv.ShowSelected();
	 ctl_lv.ID(1);
	 ctl_lv.HelpText("Eine Unterfunktion des\nProgramms whlen.");
	 ctl.Add(ctl_lv);
	 ruler rl;
	 rl.Horiz();
	 rl.Space(3);
	 ctl.Add(rl);
	 fbutton exit;
	 exit.Font(BGGFONT);
	 exit.Text("Beenden");
	 exit.Weight(10);
	 exit.ID(2);
	 ctl.Add(exit);

	 ctl_lv.AddAtEnd("ber");
	 ctl_lv.AddAtEnd("Einstellungen");
	 ctl_lv.AddAtEnd("anlegen");
	 ctl_lv.AddAtEnd("Antrag verwalten");
	 ctl_lv.AddAtEnd("Information");
	 ctl_lv.AddAtEnd("lschen");
	 ctl_lv.Selected(1);
	
	for (int i=0;i<4;i++)
	{
		work[i].Font(GPFONT);
		work[i].Vert();
		work[i].Center();
		if (i>0) work[0].AddShadow(work[i]);
	}
	work[UEBER].Title("xmanager -  (c) 1996 by Jrgen Schmitz");
	gui_ueber();

	work[ANLEGEN].Title("Benutzer anlegen");
	gui_benutzer();

	work[INFO].Title("Benutzerinformation");
	gui_binfo();

	work[PREFS].Title("Programmeinstellungen");
	gui_prefs();

	ausg.Horiz();
	ausg.Add(ctl);
	ausg.Add(work[0]);
	maingp.Add(ausg);

	 status.Font(SGGFONT);
	 status.Text("xmanager\nX11 Benutzerverwaltung");
	 status.Center();
	maingp.Add(status);

	 statusio.ReadOnly();
	 statusio.AlwaysShowLast();
	maingp.Add(statusio);
	maingp.Vert();

	mymenu.ID(1000);
	mymenu.AddMenu("Programm");
	mymenu.Add("ber",1);
	mymenu.AddRuler();
	mymenu.Add("Ende",2);
	mymenu.AddHelpMenu("Xclasses");
	mymenu.Add("ber",1);

	mywindow.SetGroup(maingp);
	mywindow.SetMenu(mymenu);
	mywindow.Create();

	set_config();
	read_antraege();
	ueber_update();
	while (!ende)
	{
		switch(mywindow.NextEvent())
		{
			case EV_WINDOWCLOSE:
				if (mywindow.CloseMe()) ende=1;
				break;
			default:
				w=mywindow.ID();		
				status.Text("xmanager\nX11 Benutzerverwaltung");
				switch (w)
				{
					case 1000:
						if (mymenu.MID()==1)
						{
							ctl_lv.Selected(1);
							modus=0;
							status.Text("xmanager\nX11 Benutzerverwaltung");
							ueber_update();
							work[UEBER].Show();
						}
						else if (mymenu.MID()==2)
						{
							ende=1;
						}
						break;
					case 2:
						ende=1;
						break;
					case 1: // Modus
						bi_sicher.State(RELEASED);
						modus=ctl_lv.Selected()-1;
						status.Text("xmanager\nX11 Benutzerverwaltung");
						switch (modus)
						{
							case 0: // ueber
								ueber_update();
								work[UEBER].Show();
								break;
							case 1: // prefs
								work[PREFS].Show();
								break;
							case 2: // anlegen
								work[ANLEGEN].Title("Benutzer anlegen");
								work[ANLEGEN].Show();
								an_sgp[0].Show();
								an_hinweis[LOGIN].Text("");
								an_hinweis[MALIAS].Text("");
								pruefen();
								break;
							case 3: // Antrag anlegen
								work[ANLEGEN].Title("Benutzerantrag anlegen");
								work[ANLEGEN].Show();
								an_sgp[1].Show();
								an_hinweis[LOGIN].Text("");
								an_hinweis[MALIAS].Text("");
								pruefen();
								break;
							case 4: // info
								work[INFO].Title("Benutzerinformation");
								work[INFO].Show();
								big2.Show();
								break;
							case 5: // loeschen
								work[INFO].Title("Benutzer lschen");
								work[INFO].Show();
								big2_2.Show();
								break;						

						}
						break;
					case 101+GRUPPE:
						set_home();
						an_input[w-100].ActivateKey();
						break;
					case 101+VORNAME:
					case 101+NAME:
						make_login(); pruefen();
						an_input[w-100].ActivateKey();
						break;
					case 101+STRASSE:
					case 101+ORT:
					case 101+TELEFON:
					case 101+GEBURT:
					case 101+BURO:
					case 101+BUROTEL:
					case 101+BERUF:
					case 101+LOGIN:
					case 101+MALIAS:
					case 101+HOME:
						an_input[w-100].ActivateKey();
						break;
					case 151: // prfen
						status.Text("prfe Benutzerdaten..."); //mainwin.Update();
						mywindow.Update();
						pruefen();
						break;
					case 152: // anlegen
						status.Text("Benutzer wird angelegt");
						anlegen();
						break;
					case 153: // anlegen (Antrage)
						status.Text("Benutzer wird angelegt");

						anlegen();
						verschiebe_antrag();
						clear_form();
						break;
					case 154: // existiert
						status.Text("Benutzer existiert Ausdruck,\nPasswort gendert");
						existiert();
						verschiebe_antrag();
						clear_form();
						break;
					case 155: // lschen
						status.Text("Benutzerantrag wird gelscht...");
						loesche_antrag();
						break;
					case 156: // ausgewhlt
						read_antrag();
						anlegen2.Unlock();
						loeschen2.Unlock();
						pruefen2.Unlock();
						break;
					case 157: // Felder lschen
						clear_form();
						break;
					case 200: //  login-name suchen, anzeigen
						bi_sicher.State(RELEASED);
						info_suchen();
						if (modus==5)
						{
							bi_sicher.ActivateKey();
						}
						break;
					case 201: // zufallspw
						strcpy(buf,rpasswd());
						bi_passwd.Default(buf);
						break;
					case 202: // pw ndern
						{
							easy_dialog yesno;
							yesno.Text("Das Passwort wirklich ndern?");
							yesno.Options("Ja|Nein");
							if (yesno.Start(mywindow)==1)
							{
								char login[10];
								char drk[2800];

								bi_passwd.Input(buf);
								bi_login.Input(login);

								sprintf(drk,"\n"
								"  Benutzerpasswort geaendert\n"
								"  --------------------------\n\n"
								"  Benutzername  : %s\n"
								"  neues Passwort: %s\n\n"
								,login,buf);
								drucke(drk);

								chpasswd(login,buf);
								status.Text("Passwort gendert.");
							}
						}
						break;
					case 250:
						bi_loeschen.ActivateKey();
						break;
					case 251: // lschen
						if (bi_sicher.State()==PRESSED)
						{
							loesche_benutzer();
						}
						bi_sicher.State(RELEASED);
						bi_login.ActivateKey();
						break;
				}
		}
	}

	mywindow.Close();
}
