#ifndef INCL_DDRAW_H
#define INCL_DDRAW_H

// *-----------------------------------------------------------------------
// * Xclasses class header file
// * 
// * class name: Ddraw
// * author    : Jrgen Schmitz
// * version   : 1.0
// *-----------------------------------------------------------------------

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/gfx_object.h>

#define LOCK_BORDER		0
#define LOCK_NOBORDER	1

class Ddraw
{
	friend class pDdraw;

	class pDdraw *p;
	
public:

	Ddraw(void);
	Ddraw(gadget *);
	~Ddraw();
	
	int BorderSize(int newsize); // returns old size
	int RealSize(void);			 // returns real bordersize
	void KeyBorder(void);
	void NoKeyBorder(void);
	void StripesMark(void);
	void SolidMark(void);

	void borderlocked(class gadget *g,int x,int y,int w,int h,int flags=LOCK_BORDER);

	int textheight(class gadget *g,char *txt,XFontStruct *font);	// total height in pixel
	int textlength(class gadget *g,char *txt,XFontStruct *font);	// max length in pixel
	int textheight(class gadget *g,char *txt) 
	  	{ return textheight(g,txt,g->gg_font()); };
	int textlength(class gadget *g,char *txt) 
	  	{ return textlength(g,txt,g->gg_font()); };	
	
	void borderUp(class gadget *g,int x,int y,int w,int h);
	void borderDown(class gadget *g,int x,int y,int w,int h);
	void borderEmboss(class gadget *g,int x,int y,int w,int h);
	void borderUpFill(class gadget *g,int x,int y,int w,int h);
	void borderDownFill(class gadget *g,int x,int y,int w,int h);
	void borderEmbossFill(class gadget *g,int x,int y,int w,int h);
	void borderUpShineFill(class gadget *g,int x,int y,int w,int h);

	void bordertext(class gadget *g,int x,int y,int w,int h,char *txt,int adjust,XFontStruct *font);	
	void bordertext(class gadget *g,int x,int y,int w,int h,char *txt,int adjust=(ADJUST_CENTER|ADJUST_MIDDLE))
		{ bordertext(g,x,y,w,h,txt,adjust,g->gg_font()); };
	
	void borderselectedtext(class gadget *g,int x,int y,int w,int h,char *txt,int adjust,XFontStruct *font);	
	void borderselectedtext(class gadget *g,int x,int y,int w,int h,char *txt,int adjust=(ADJUST_CENTER|ADJUST_MIDDLE))
		{ borderselectedtext(g,x,y,w,h,txt,adjust,g->gg_font()); };

	void borderlockedtext(class gadget *g,int x,int y,int w,int h,char *txt,int adjust,XFontStruct *font);	
	void borderlockedtext(class gadget *g,int x,int y,int w,int h,char *txt,int adjust=(ADJUST_CENTER|ADJUST_MIDDLE))
		{ borderlockedtext(g,x,y,w,h,txt,adjust,g->gg_font()); };
	
	void bordermark(class gadget *g,int x,int y,int w,int h);
	void borderunmark(class gadget *g,int x,int y,int w,int h);
	
};

#endif
