#ifndef INCL_TEXTBOX_H
#define INCL_TEXTBOX_H

// *-----------------------------------------------------------------------
// * Xclasses class header file
// * 
// * class name: textbox
// * author    : Jrgen Schmitz
// * version   : 1.0
// *-----------------------------------------------------------------------

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/Ddraw.h>


class textbox : Ddraw, public gadget 
{
	friend class ptextbox;

	class ptextbox *p;

public:
    virtual void GExpose(XEvent *event);
    virtual void GActionPress(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual void GActionRelease(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual int  GMouseMove(int mx,int my,int rx,int ry,unsigned int state,int button);
    virtual int  GActivate(XEvent *event,int why);
    virtual int  GSelected(XEvent *event,int why,int wasabove);
	virtual void GSetLimits(void);
	virtual int  GClipHandler(int why,char *,int);

public:
    textbox();
    virtual ~textbox();

    virtual int Create(void);
    virtual void Free(void);
	virtual void Resize(int w,int h);
	virtual void Lock(void);
	virtual void Unlock(void);
    virtual void Block(int);
    virtual void Unblock(int);

// before Create	
	void ReadOnly(void);
	void AlwaysShowLast(void);
	void MinCols(int);
	void MinRows(int);

// text management
	void AppendText(char *);
	void ReplaceText(char *);
	void InsertText(char *,int curx,int cury);
	int TextSize(void);
	void CopyText(char *,int maxsize);
	void ShowLine(int);
	void TopLine(int);
	int TopLine(void);
	int TotalLines(void);
	void Cursor(int &x,int &y);
	void CursorTo(int x,int y);
	void MaxLineLength(int);

// data
	int visible_rows(void);
	int visible_cols(void);
};

#endif
