.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/ImageOrd.man,v 1.4 2005/02/11 03:02:54 dawes Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH ImageByteOrder 3X11 __vendorversion__ "XLIB FUNCTIONS"
.SH NAME
ImageByteOrder, BitmapBitOrder, BitmapPad, BitmapUnit, DisplayHeight, DisplayHeightMM, DisplayWidth, DisplayWidthMM, XListPixmapFormats, XPixmapFormatValues \- image format functions and macros
.SH SYNTAX
.HP
XPixmapFormatValues *XListPixmapFormats\^(\^Display *\fIdisplay\fP, int *\fIcount_return\fP\^);
.HP
int ImageByteOrder\^(\^Display *\fIdisplay\fP\^);
.HP
int BitmapBitOrder\^(\^Display *\fIdisplay\fP\^);
.HP
int BitmapPad\^(\^Display *\fIdisplay\fP\^);
.HP
int BitmapUnit\^(\^Display *\fIdisplay\fP\^);
.HP
int DisplayHeight\^(\^Display *\fIdisplay\fP\^, \^int \fIscreen_number\fP\^);
.HP
int DisplayHeightMM\^(\^Display *\fIdisplay\fP\^, \^int \fIscreen_number\fP\^);
.HP
int DisplayWidth\^(\^Display *\fIdisplay\fP\^, \^int \fIscreen_number\fP\^);
.HP
int DisplayWidthMM\^(\^Display *\fIdisplay\fP\^, \^int \fIscreen_number\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.ds Cn pixmap formats that are supported by the display
.IP \fIcount_return\fP 1i
Returns the number of \*(Cn.
.IP \fIscreen_number\fP 1i
Specifies the appropriate screen number on the host server.
.SH DESCRIPTION
The
.ZN XListPixmapFormats
function returns an array of
.ZN XPixmapFormatValues
structures that describe the types of Z format images supported
by the specified display.
If insufficient memory is available,
.ZN XListPixmapFormats
returns NULL.
To free the allocated storage for the
.ZN XPixmapFormatValues
structures, use
.ZN XFree .
.LP
The
.ZN ImageByteOrder
macro specifies the required byte order for images for each scanline unit in
XY format (bitmap) or for each pixel value in Z format.
.LP
The
.ZN BitmapBitOrder
macro returns 
.ZN LSBFirst
or
.ZN MSBFirst
to indicate whether the leftmost bit in the bitmap as displayed
on the screen is the least or most significant bit in the unit.
.LP
The
.ZN BitmapPad
macro returns the number of bits that each scanline must be padded.
.LP
The
.ZN BitmapUnit
macro returns the size of a bitmap's scanline unit in bits.
.LP
The
.ZN DisplayHeight
macro returns the height of the specified screen in pixels.
.LP
The
.ZN DisplayHeightMM
macro returns the height of the specified screen in millimeters.
.LP
The
.ZN DisplayWidth
macro returns the width of the screen in pixels.
.LP
The
.ZN DisplayWidthMM
macro returns the width of the specified screen in millimeters.
.SH STRUCTURES
The
.ZN XPixmapFormatValues
structure provides an interface to the pixmap format information
that is returned at the time of a connection setup.
It contains:
.Ds 0
.TA .5i 3i
.ta .5i 3i
typedef struct {
	int depth;
	int bits_per_pixel;
	int scanline_pad;
} XPixmapFormatValues;
.De
.SH "SEE ALSO"
AllPlanes(3X11),
BlackPixelOfScreen(3X11),
IsCursorKey(3X11),
XFree(3X11)
.br
\fI\*(xL\fP
