/**File:         AppDllUI
* Description:   To Enable Sample data Source user to select suitable parameters
*                for his purpose of its output and as expected by the application.  
* Owner:         JFL Peripheral Solutions.
* Author:        Berhane Russom
* Created:       May  1998
* Language:      windows C
* Package:       N/A
* Status:        Test tool
*
*	Copyright  1998 TWAIN Working Group: Adobe Systems Incorporated, 
*	Canon Information Systems, Eastman Kodak Company, 
*	Fujitsu Computer Products of America, Genoa Technology, 
*	Hewlett-Packard Company, Intel Corporation, Kofax Image Products, 
*	JFL Peripheral Solutions Inc., Ricoh Corporation, and Xerox Corporation.  
*	All rights reserved.
*/
#include<windows.h>
#include<WindowsX.h>
#include<commctrl.h>
#include <stdio.h>
#include "resource.h"
#include "Dlgproc.h"

#include "..\twcommon\twain.h"
#include "twd_type.h"
#include "dscaps.h"

#include "scanner.h"
#include <lug.h>
#include <stdarg.h>

void ResizePaper(HWND hDlg);
static HPALETTE hDibPal = NULL;		// handle to palette
static HBITMAP hBmp=NULL;
int nxMM=100, nyMM=100;
int ntMM=0, nlMM=0;
extern DWORD _gdwLineSize;
extern int _gnRowsTotal;
static RECT rcScan={0, 0, 0, 0};
static RECT rcFocus;
static BOOL bFocusPresent=FALSE;
#define PALVERSION      0x300
#define MAXPALETTE      256      /* max. # supported palette entries */

extern double current_gamma;
extern int current_bright;
extern int sharpen_bm, blur_bm;

static void UpdateDisplay(HWND hWnd, int nID, char *fmt, ...)
{
	static char buf[64];

	va_list ap;

	va_start(ap, fmt);
	vsprintf(buf, fmt, ap);
	va_end(ap);
	SetWindowText(GetDlgItem(hWnd, nID), buf);
}

void AdjustFocusRect(LPRECT rcFocus, LPRECT rcClient)
{
	int tmp;

	if(rcFocus->top > rcFocus->bottom)
	{
		tmp=rcFocus->bottom;
		rcFocus->bottom=rcFocus->top;
		rcFocus->top=tmp;
	}
	if(rcFocus->left > rcFocus->right)
	{
		tmp=rcFocus->right;
		rcFocus->right=rcFocus->left;
		rcFocus->left=tmp;
	}
	if(rcFocus->top < rcClient->top)
		rcFocus->top=rcClient->top;
	if(rcFocus->left < rcClient->left)
		rcFocus->left=rcClient->left;
	if(rcFocus->right > rcClient->right)
		rcFocus->right=rcClient->right;
	if(rcFocus->bottom > rcClient->bottom)
		rcFocus->bottom=rcClient->bottom;
}

LRESULT CALLBACK DisplayWndProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	HDC hDC;
	PAINTSTRUCT paint;
	HDC memDC;
	HBITMAP hPrevBitmap;
	BITMAP bm;
	RECT rcClient;
	HRGN rgn;
	HBRUSH hWhiteBr, hPrevBr;
	HPEN hWhitePen, hPrevPen;

	static int nClickX, nClickY;
	static BOOL bMouseDown=FALSE;
	static BOOL bCaptured=FALSE;
	
	switch(iMsg)
	{
	case WM_NCHITTEST:
		return(HTCLIENT);
	case WM_PAINT:
		hDC=BeginPaint(hWnd, &paint);
		GetClientRect(hWnd, &rcClient);
		if(hBmp)
		{
			rgn=CreateRectRgn(0, 0, rcClient.right, rcClient.bottom);
			SelectClipRgn(hDC, rgn);
			DeleteObject(rgn);
			GetObject(hBmp, sizeof(bm), &bm);
			memDC=CreateCompatibleDC(hDC);
			hPrevBitmap=SelectObject(memDC, hBmp);
			StretchBlt(hDC, 0, 0, rcClient.right, rcClient.bottom, memDC, 0, 0, bm.bmWidth, bm.bmHeight, SRCCOPY);
			SelectObject(memDC, hPrevBitmap);
			DeleteDC(memDC);
		}
		else
		{
			hWhiteBr=CreateSolidBrush(RGB(255, 255, 255));
			hWhitePen=CreatePen(PS_SOLID, 0, RGB(255, 255, 255));
			hPrevBr=SelectObject(hDC, hWhiteBr);
			hPrevPen=SelectObject(hDC, hWhitePen);
			Rectangle(hDC, 0, 0, rcClient.right, rcClient.bottom);
			SelectObject(hDC, hPrevBr);
			SelectObject(hDC, hPrevPen);
			DeleteObject(hWhitePen);
			DeleteObject(hWhiteBr);
		}
		if(bFocusPresent)
			DrawFocusRect(hDC, &rcFocus);
		EndPaint(hWnd, &paint);
		if(!hBmp)
		{
			hDC=GetDC(hWnd);

			if(bFocusPresent)
			{
				DrawFocusRect(hDC, &rcFocus);
				InvalidateRect(hWnd, NULL, TRUE);
			}
			bFocusPresent=FALSE;
			ReleaseDC(hWnd, hDC);
			SetRectEmpty(&rcScan);
		}
		break;
	case WM_LBUTTONDOWN:
		if(!hBmp)
			break;
		nClickX=LOWORD(lParam);
		nClickY=HIWORD(lParam);
		if(nClickX < 0)
			nClickX=0;
		if(nClickY < 0)
			nClickY=0;
		SetCapture(hWnd);
		bCaptured=TRUE;
		bMouseDown=TRUE;
		break;
	case WM_LBUTTONUP:
		if(bCaptured)
			ReleaseCapture();
		bCaptured=FALSE;
		bMouseDown=FALSE;
		if(nClickX == LOWORD(lParam) && nClickY == HIWORD(lParam))
		{
			hDC=GetDC(hWnd);
			if(bFocusPresent)
				DrawFocusRect(hDC, &rcFocus);
			bFocusPresent=FALSE;
			SetRectEmpty(&rcScan);
			ReleaseDC(hWnd, hDC);
		}
		break;
	case WM_MOUSEMOVE:
		if(!bMouseDown)
			break;
		hDC=GetDC(hWnd);
		if(bFocusPresent)
			DrawFocusRect(hDC, &rcFocus);
		bFocusPresent=FALSE;
		rcFocus.left=nClickX;
		rcFocus.top=nClickY;
		rcFocus.right=(LONG)(short)LOWORD(lParam);
		rcFocus.bottom=(LONG)(short)HIWORD(lParam);
		if(rcFocus.right < 0)
			rcFocus.right=0;
		if(rcFocus.bottom < 0)
			rcFocus.bottom=0;
		GetClientRect(hWnd, &rcClient);
		AdjustFocusRect(&rcFocus, &rcClient);
		DrawFocusRect(hDC, &rcFocus);
		ReleaseDC(hWnd, hDC);
		bFocusPresent=TRUE;
		break;
	default:
		break;
	};
	return(DefWindowProc(hWnd, iMsg, wParam, lParam));
}

/////////////////////////////////////////////////////////////////////////////
// CreateBIPalette
//
// ARGS:    lpbi        pointer to a BITMAPINFO structure
//
// RETURNS: hPalette    handle to the created palette
//                                        
// NOTES:   Given a Pointer to a BITMAPINFO struct will create a
//          GDI palette object from the color table.
//
HPALETTE CreateBIPalette (LPBITMAPINFOHEADER lpbi)
{                           
	HGLOBAL             hPal = NULL;
	LOGPALETTE          *pPal = NULL;
	HPALETTE            hPalette = NULL;
	WORD                nNumColors = 0;
	BYTE                Red = 0;
	BYTE                Green = 0;
	BYTE                Blue = 0;
	WORD                i = 0;
	RGBQUAD             FAR *pRgb = NULL;

	if (!lpbi)
	{
		return NULL;
	}

	if (lpbi->biSize != sizeof(BITMAPINFOHEADER))
	{
		return NULL;
	}

	// Get a pointer to the color table and the number of colors in it 
	pRgb = (RGBQUAD FAR *)((LPSTR)lpbi + (WORD)lpbi->biSize);
	nNumColors = DibNumColors(lpbi);

	if (nNumColors)
	{
		// Allocate for the logical palette structure
		//  SDH - 02/01/95 - For compatability with the Large model...
		//  pPal = (LOGPALETTE*)LocalAlloc(LPTR,sizeof(LOGPALETTE) + nNumColors *
		//                  sizeof(PALETTEENTRY));
		hPal = GlobalAlloc(GPTR,sizeof(LOGPALETTE) + nNumColors *
							sizeof(PALETTEENTRY));
		pPal = (LOGPALETTE*)(GlobalLock (hPal));
		if (!pPal)
		{
			return NULL;
		}

		pPal->palNumEntries = nNumColors;
		pPal->palVersion    = PALVERSION;

		// Fill in the palette entries from the DIB color table and
		// create a logical color palette.
		for (i = 0; i < nNumColors; i++)
		{
			pPal->palPalEntry[i].peRed   = pRgb[i].rgbRed;
			pPal->palPalEntry[i].peGreen = pRgb[i].rgbGreen;
			pPal->palPalEntry[i].peBlue  = pRgb[i].rgbBlue;
			pPal->palPalEntry[i].peFlags = (BYTE)0;
		}

		hPalette = CreatePalette(pPal);

		GlobalUnlock(hPal);
		GlobalFree(hPal);
	}
	else if (lpbi->biBitCount == 24)
	{
		// A 24 bitcount DIB has no color table entries so, set
		// the number of to the maximum value (256).
		nNumColors = MAXPALETTE;

		hPal = GlobalAlloc(GPTR,sizeof(LOGPALETTE) + nNumColors * sizeof(PALETTEENTRY));
		pPal = (LOGPALETTE*)GlobalLock (hPal);

		if (!pPal)
		{
			return NULL;
		}

		pPal->palNumEntries = nNumColors;
		pPal->palVersion    = PALVERSION;

		Red = Green = Blue = 0;

		// Generate 256 (= 8*8*4) RGB combinations to fill
		// the palette entries.
		for (i = 0; i < pPal->palNumEntries; i++)
		{
			pPal->palPalEntry[i].peRed   = Red;
			pPal->palPalEntry[i].peGreen = Green;
			pPal->palPalEntry[i].peBlue  = Blue;
			pPal->palPalEntry[i].peFlags = (BYTE)0;

			if (!(Red += 32))
			{
				if (!(Green += 32))
				{
					Blue += 64;
				}
			}
		}

		hPalette = CreatePalette(pPal);

		GlobalUnlock(hPal);
		GlobalFree(hPal);
	}
	return hPalette;
}

/////////////////////////////////////////////////////////////////////////////
// FUNCTION: FixUp -- Creates a device independent bitmap and frees the bmp
// handle memory. 
//
// ARGS:    hDib    handle to DIB
//
// RETURNS: hBitMap handle to a DDB
//
HBITMAP FixUp(HWND hWnd, HANDLE hDib)
{
	LPBITMAPINFOHEADER  lpDib = NULL, lpBi = NULL;
	LPSTR               lpBits = NULL;
	DWORD               dwColorTableSize = 0;
	HBITMAP             hBitMap = NULL;
	HDC                 hDC = NULL;

	if (hDib == NULL)
	{
		return(NULL);
	}

	if ((lpDib = (LPBITMAPINFOHEADER) GlobalLock(hDib))==NULL)
	{
		return(NULL);
	}

	lpBi = lpDib;

	// Calculate the color table size, then point past the BITMAPINFOHEADER
	// and color table, to the byte array of bitmap bits.
	dwColorTableSize = (DWORD)(DibNumColors (lpDib) * sizeof(RGBQUAD));
	lpBits = (LPSTR)lpDib + lpBi->biSize + dwColorTableSize;

	// Create a logical palette based on the colors in the DIB header,
	// and realize it
	hDC = GetDC(hWnd);

	if (hDibPal = CreateBIPalette (lpBi))
	{
		SelectPalette (hDC, hDibPal, FALSE);
		RealizePalette (hDC);
	}

	//  Microsoft confirmed a defect in CreateDIBitmap whereas the function
	//  failed with handles to 1Meg or larger 1 color bitmaps.  The workaround
	//  is to create a device dependent bitmap whenever a 1 color bitmap
	//  is detected.  
	if (lpDib->biBitCount == 1)
	{
		// create a device dependent monochrome bitmap
		hBitMap = CreateBitmap((int)lpDib->biWidth,(int)lpDib->biHeight,1,1,lpBits);
		if(hBitMap)
		{
			SetDIBits(hDC,hBitMap,0,(UINT)lpDib->biHeight,lpBits,(LPBITMAPINFO)lpDib,DIB_RGB_COLORS);
		}
	}
	else
	{
		// Create a device-independent bitmap from the BMP
		hBitMap = CreateDIBitmap (hDC, lpDib, (LONG)CBM_INIT, (LPSTR)lpBits,
							(LPBITMAPINFO)lpDib, DIB_RGB_COLORS);
	}

	GlobalUnlock(hDib);

	ReleaseDC (hWnd, hDC);

//	GlobalUnlock(hDib);

	// Return handle to device-dependent bitmap
	return(hBitMap);
}

const char *StringFromPixelTypeBitDepth(TW_UINT16 PixelType, TW_UINT16 BitDepth)
{
	switch(PixelType)
	{
	case TWPT_BW:
		return "1 bit S/W";
		break;
	case TWPT_GRAY:
		if(BitDepth==4)
		{
			return "4 bit Grau";
		}
		else
		{
			return "8 bit Grau";
		}
		break;
	case TWPT_RGB:
		return "24 bit Farbe";
		break;
	case TWPT_PALETTE:
		break;
	case TWPT_CMY:
		break;
	case TWPT_CMYK:
		break;
	case TWPT_YUV:
		break;
	case TWPT_YUVK:
		break;
	case TWPT_CIEXYZ:
		break;
	}
	return NULL;
}

const char *StringFromPaperSize(TW_UINT16 PaperSize)
{
	switch(PaperSize)
	{
		case TWSS_NONE:
			return "Benutzerdefiniert";
			break;
		case TWSS_A4LETTER:
			return "A4";
			break;
		case TWSS_USLETTER:
			return "US Letter";
			break;
		case TWSS_USLEGAL:
			return "US Legal";
			break;
	}
	return NULL;
}

/* Function: SettingsDlgProc 
* Author: Berhane Russom
* Input:
*		hDlg        -Handle to Dialog.
*		iMsg        -Message Identifier.
*	  (l|w)Param	_message parameters
* Output:
*	              _If the function succeeds, the return value is the nResult parameter in the call to the 
*               _EndDialog function used to terminate the dialog box.
*               _If the function fails, the return value is -1.
* Comments:	 		_processes messages sent to a window.
*		
*/
#ifdef WIN32
LRESULT CALLBACK SettingsDlgProc(HWND hDlg, UINT iMsg, WPARAM wParam, LPARAM lParam)
#else	//16 bit version
BOOL FAR PASCAL _export SettingsDlgProc(HWND hDlg, UINT iMsg, WPARAM wParam, LPARAM lParam)
#endif
{	
	int iIndex = 0;
	DWORD dwLineSize;
	HGLOBAL hDIB;
	static char strTmp[256];
	TW_UINT16 *pUintTypes = NULL;
	float *pFloatTypes = NULL;
	int iNumItems = 0;
	int pos;
	RECT rcPreview;
	float fResolution;

	switch(iMsg)
	{
		case WM_INITDIALOG:
			{
				int iSubIndex = 0;
				int iNumSubItems = 0;
				TW_UINT16 *pUintSubTypes = NULL;
				char TmpString[MAX_PATH];
				HWND dlgItemWnd = NULL;
				short sMaxXfer = 0;
				HWND hDisplay;
				HWND hTmp;

				hTmp=GetDlgItem(hDlg, IDC_GAMMA);
				ScrollBar_SetRange(hTmp, 5, 40, FALSE);
				ScrollBar_SetPos(hTmp, 10, FALSE);
				UpdateDisplay(hDlg, IDC_GAMMAVALUE, "%.1f", 1.0F);

				hTmp=GetDlgItem(hDlg, IDC_BRIGHT);
				ScrollBar_SetRange(hTmp, 0, 200, FALSE);
				ScrollBar_SetPos(hTmp, 100, FALSE);
				UpdateDisplay(hDlg, IDC_BRIGHTVALUE, "%d %%", 100);

				hDisplay=GetDlgItem(hDlg, IDC_STC_PAPER);
				SetWindowLong(hDisplay, GWL_WNDPROC, (DWORD)DisplayWndProc);

				EnableWindow(GetDlgItem(hDlg, IDC_WIDTH), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_HEIGHT), FALSE);

				memset(TmpString, 0, MAX_PATH);

				/*
				*	Initialize resolution values
				*/
				pFloatTypes = GetSupportedXResolution(&iNumItems);
				for(iIndex=0; iIndex<iNumItems; iIndex++)
				{
					int iInsertIndex = 0;
					sprintf(TmpString, "%.0f DPI", pFloatTypes[iIndex]);
					iInsertIndex = ComboBox_AddString(GetDlgItem(hDlg, ID_COMBO_RESOLUTION), TmpString);
					ComboBox_SetItemData(GetDlgItem(hDlg, ID_COMBO_RESOLUTION), iInsertIndex, (DWORD)pFloatTypes[iIndex]);

					if(pFloatTypes[iIndex] == GetCurrentXResolution())
					{
						/*
						* Make this the current resolution
						*/
						ComboBox_SelectString(GetDlgItem(hDlg, ID_COMBO_RESOLUTION), 0, TmpString);
					}
				}


				/*
				*	Initialize the paper sizes
				*/
				pUintTypes = GetSupportedSupportedSizes(&iNumItems);
				for(iIndex=0; iIndex<iNumItems; iIndex++)
				{
					int iInsertIndex = 0;
					iInsertIndex = ComboBox_AddString(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE), StringFromPaperSize(pUintTypes[iIndex]));
					ComboBox_SetItemData(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE), iInsertIndex, (DWORD)pUintTypes[iIndex]);

					if(pUintTypes[iIndex] == GetCurrentSupportedSizes())
					{
						/*
						* Make this the current paper size
						*/
						ComboBox_SelectString(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE), 0, StringFromPaperSize(pUintTypes[iIndex]));
					}
				}

				iIndex = ComboBox_GetCurSel(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE));
				SetCurrentSupportedSizes((TW_UINT16)ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE), iIndex));

				if(ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE), iIndex) == TWSS_NONE)
				{
					EnableWindow(GetDlgItem(hDlg, IDC_WIDTH), TRUE);
					EnableWindow(GetDlgItem(hDlg, IDC_HEIGHT), TRUE);
					EnableWindow(GetDlgItem(hDlg, IDC_LEFT), TRUE);
					EnableWindow(GetDlgItem(hDlg, IDC_TOP), TRUE);
				}
				else
				{
					EnableWindow(GetDlgItem(hDlg, IDC_WIDTH), FALSE);
					EnableWindow(GetDlgItem(hDlg, IDC_HEIGHT), FALSE);
					EnableWindow(GetDlgItem(hDlg, IDC_LEFT), FALSE);
					EnableWindow(GetDlgItem(hDlg, IDC_TOP), FALSE);
					if(GetCurrentSupportedSizes()==TWSS_USLETTER)
					{
						nxMM=(TW_UINT16)(8.5F * 25.4F);
						nyMM=(TW_UINT16)(11.0F * 25.4F);
						ntMM=nlMM=0;
					}
					else if(GetCurrentSupportedSizes()==TWSS_A4LETTER)
					{
						nxMM=(TW_UINT16)(8.26772F * 25.4F);
						nyMM=(TW_UINT16)(11.69291F * 25.4F);
						ntMM=nlMM=0;
					}
					sprintf(strTmp, "%d", nxMM);
					SetWindowText(GetDlgItem(hDlg, IDC_WIDTH), strTmp);
					sprintf(strTmp, "%d", nyMM);
					SetWindowText(GetDlgItem(hDlg, IDC_HEIGHT), strTmp);
					SetWindowText(GetDlgItem(hDlg, IDC_TOP), "0");
					SetWindowText(GetDlgItem(hDlg, IDC_LEFT), "0");
				}

				ResizePaper(hDlg);

				/*
				*	Initialize the scan mode
				*/
				pUintTypes = GetSupportedPixelType(&iNumItems);
				for(iIndex=0; iIndex<iNumItems; iIndex++)
				{
					pUintSubTypes = GetSupportedBitDepth(&iNumSubItems, pUintTypes[iIndex]);
					for(iSubIndex = 0; iSubIndex < iNumSubItems; iSubIndex++)
					{
						int iInsertIndex = 0;
						iInsertIndex = ComboBox_AddString(GetDlgItem(hDlg, ID_COMBO_SCANMODE), StringFromPixelTypeBitDepth(pUintTypes[iIndex], pUintSubTypes[iSubIndex]));
						ComboBox_SetItemData(GetDlgItem(hDlg, ID_COMBO_SCANMODE), iInsertIndex, MAKELONG(pUintTypes[iIndex], pUintSubTypes[iSubIndex]));

						if( (pUintTypes[iIndex] == GetCurrentPixelType())&&(pUintSubTypes[iSubIndex]==GetCurrentBitDepth(pUintTypes[iIndex])) )
						{
							/*
							* Make this the current paper size
							*/
							ComboBox_SelectString(GetDlgItem(hDlg, ID_COMBO_SCANMODE), 0, StringFromPixelTypeBitDepth(pUintTypes[iIndex], pUintSubTypes[iSubIndex]));
						}
					}
				}
			}
			break;

		case WM_HSCROLL:												
			pos=ScrollBar_GetPos((HWND)lParam);
			switch(GetWindowLong((HWND)lParam, GWL_ID))
			{
			case IDC_GAMMA:
				switch(LOWORD(wParam))
				{
				case SB_LINELEFT:
					ScrollBar_SetPos((HWND)lParam, pos-1, TRUE);
					break;
				case SB_LINERIGHT:
					ScrollBar_SetPos((HWND)lParam, pos+1, TRUE);
					break;
				case SB_PAGELEFT:
					ScrollBar_SetPos((HWND)lParam, pos-2, TRUE);
					break;
				case SB_PAGERIGHT:
					ScrollBar_SetPos((HWND)lParam, pos+2, TRUE);
					break;
				case SB_THUMBTRACK:
					ScrollBar_SetPos((HWND)lParam, HIWORD(wParam), TRUE);
					break;
				}
				UpdateDisplay(hDlg, IDC_GAMMAVALUE, "%.1f", ((float)ScrollBar_GetPos((HWND)lParam))/10.0);
				current_gamma=((float)ScrollBar_GetPos((HWND)lParam))/10.0;

				if(hBmp)
				{
					StartDIB(&dwLineSize);
					hDIB=ScanToDIB();
					if(!hDIB)
						break;
					DeleteObject(hBmp);
					hBmp=NULL;
					hBmp=FixUp(hDlg, hDIB);
					if(!hBmp)
						break;
					InvalidateRect(GetDlgItem(hDlg, IDC_STC_PAPER), NULL, TRUE);
					UpdateWindow(GetDlgItem(hDlg, IDC_STC_PAPER));
				}
				break;
			case IDC_BRIGHT:
				switch(LOWORD(wParam))
				{
				case SB_LINELEFT:
					ScrollBar_SetPos((HWND)lParam, pos-1, TRUE);
					break;
				case SB_LINERIGHT:
					ScrollBar_SetPos((HWND)lParam, pos+1, TRUE);
					break;
				case SB_PAGELEFT:
					ScrollBar_SetPos((HWND)lParam, pos-10, TRUE);
					break;
				case SB_PAGERIGHT:
					ScrollBar_SetPos((HWND)lParam, pos+10, TRUE);
					break;
				case SB_THUMBTRACK:
					ScrollBar_SetPos((HWND)lParam, HIWORD(wParam), TRUE);
					break;
				}
				UpdateDisplay(hDlg, IDC_BRIGHTVALUE, "%d %%", ScrollBar_GetPos((HWND)lParam));
				current_bright=ScrollBar_GetPos((HWND)lParam);

				if(hBmp)
				{
					StartDIB(&dwLineSize);
					hDIB=ScanToDIB();
					if(!hDIB)
						break;
					DeleteObject(hBmp);
					hBmp=NULL;
					hBmp=FixUp(hDlg, hDIB);
					if(!hBmp)
						break;
					InvalidateRect(GetDlgItem(hDlg, IDC_STC_PAPER), NULL, TRUE);
					UpdateWindow(GetDlgItem(hDlg, IDC_STC_PAPER));
				}
				break;
			}
			break;
		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDC_SHARPEN:
					if(Button_GetCheck((HWND)lParam))
					{
						Button_SetCheck(GetDlgItem(hDlg, IDC_BLUR), FALSE);
						sharpen_bm=1;
						blur_bm=0;
					}
					else
					{
						sharpen_bm=0;
					}
					if(hBmp)
					{
						StartDIB(&dwLineSize);
						hDIB=ScanToDIB();
						if(!hDIB)
							break;
						DeleteObject(hBmp);
						hBmp=NULL;
						hBmp=FixUp(hDlg, hDIB);
						if(!hBmp)
							break;
						InvalidateRect(GetDlgItem(hDlg, IDC_STC_PAPER), NULL, TRUE);
						UpdateWindow(GetDlgItem(hDlg, IDC_STC_PAPER));
					}
					break;
				case IDC_BLUR:
					if(Button_GetCheck((HWND)lParam))
					{
						Button_SetCheck(GetDlgItem(hDlg, IDC_SHARPEN), FALSE);
						blur_bm=1;
						sharpen_bm=0;
					}
					else
					{
						blur_bm=0;
					}
					if(hBmp)
					{
						StartDIB(&dwLineSize);
						hDIB=ScanToDIB();
						if(!hDIB)
							break;
						DeleteObject(hBmp);
						hBmp=NULL;
						hBmp=FixUp(hDlg, hDIB);
						if(!hBmp)
							break;
						InvalidateRect(GetDlgItem(hDlg, IDC_STC_PAPER), NULL, TRUE);
						UpdateWindow(GetDlgItem(hDlg, IDC_STC_PAPER));
					}
					break;
				case IDC_WIDTH:
				case IDC_HEIGHT:
				case IDC_LEFT:
				case IDC_TOP:
						if(hBmp)
							DeleteObject(hBmp);
						hBmp=NULL;
						InvalidateRect(GetDlgItem(hDlg, IDC_STC_PAPER), NULL, TRUE);
						UpdateWindow(GetDlgItem(hDlg, IDC_STC_PAPER));

						iIndex = ComboBox_GetCurSel(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE));
						if(ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE), iIndex) != TWSS_NONE)
							break;
						if(HIWORD(wParam)==EN_CHANGE)
						{
							GetWindowText(GetDlgItem(hDlg, IDC_WIDTH), strTmp, sizeof(strTmp));
							nxMM=atoi(strTmp);
							if(nxMM < 10)
								nxMM=10;
							GetWindowText(GetDlgItem(hDlg, IDC_HEIGHT), strTmp, sizeof(strTmp));
							nyMM=atoi(strTmp);
							if(nyMM < 10)
								nyMM=10;
							GetWindowText(GetDlgItem(hDlg, IDC_LEFT), strTmp, sizeof(strTmp));
							nlMM=atoi(strTmp);
							if(nxMM < 10)
								nxMM=10;
							GetWindowText(GetDlgItem(hDlg, IDC_TOP), strTmp, sizeof(strTmp));
							ntMM=atoi(strTmp);
							if(nyMM < 10)
								nyMM=10;
							ResizePaper(hDlg);
						}
						break;
				case ID_COMBO_SCANMODE:
					if(HIWORD(wParam)==CBN_SELCHANGE)
					{
						iIndex = ComboBox_GetCurSel(GetDlgItem(hDlg, ID_COMBO_SCANMODE));
						if(ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_SCANMODE), iIndex) == TWPT_BW)
						{
							ScrollBar_SetPos(GetDlgItem(hDlg, IDC_GAMMA), 10, TRUE);
							UpdateDisplay(hDlg, IDC_GAMMAVALUE, "%.1f", 10.0F);
							current_gamma=10.F;
							EnableWindow(GetDlgItem(hDlg, IDC_GAMMA), FALSE);
						}
						else
						{
							EnableWindow(GetDlgItem(hDlg, IDC_GAMMA), TRUE);
						}
						if(hBmp)
						{
							DeleteObject(hBmp);
							hBmp=NULL;
							InvalidateRect(GetDlgItem(hDlg, IDC_STC_PAPER), NULL, TRUE);
							UpdateWindow(GetDlgItem(hDlg, IDC_STC_PAPER));
						}
					}
					break;
				case ID_COMBO_PAPERSIZE:
					if(HIWORD(wParam)==CBN_SELCHANGE)
					{
						if(hBmp)
							DeleteObject(hBmp);
						hBmp=NULL;
						InvalidateRect(GetDlgItem(hDlg, IDC_STC_PAPER), NULL, TRUE);
						UpdateWindow(GetDlgItem(hDlg, IDC_STC_PAPER));

						iIndex = ComboBox_GetCurSel(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE));
						SetCurrentSupportedSizes((TW_UINT16)ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE), iIndex));

						if(ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE), iIndex) == TWSS_NONE)
						{
							EnableWindow(GetDlgItem(hDlg, IDC_WIDTH), TRUE);
							EnableWindow(GetDlgItem(hDlg, IDC_HEIGHT), TRUE);
							EnableWindow(GetDlgItem(hDlg, IDC_LEFT), TRUE);
							EnableWindow(GetDlgItem(hDlg, IDC_TOP), TRUE);
						}
						else
						{
							EnableWindow(GetDlgItem(hDlg, IDC_WIDTH), FALSE);
							EnableWindow(GetDlgItem(hDlg, IDC_HEIGHT), FALSE);
							EnableWindow(GetDlgItem(hDlg, IDC_LEFT), FALSE);
							EnableWindow(GetDlgItem(hDlg, IDC_TOP), FALSE);
							if(GetCurrentSupportedSizes()==TWSS_USLETTER)
							{
								nxMM=(TW_UINT16)(8.5F * 25.4F);
								nyMM=(TW_UINT16)(11.0F * 25.4F);
								ntMM=nlMM=0;
							}
							else if(GetCurrentSupportedSizes()==TWSS_A4LETTER)
							{
								nxMM=(TW_UINT16)(8.26772F * 25.4F);
								nyMM=(TW_UINT16)(11.69291F * 25.4F);
								ntMM=nlMM=0;
							}
							sprintf(strTmp, "%d", nxMM);
							SetWindowText(GetDlgItem(hDlg, IDC_WIDTH), strTmp);
							sprintf(strTmp, "%d", nyMM);
							SetWindowText(GetDlgItem(hDlg, IDC_HEIGHT), strTmp);
							SetWindowText(GetDlgItem(hDlg, IDC_TOP), "0");
							SetWindowText(GetDlgItem(hDlg, IDC_LEFT), "0");
						}

						ResizePaper(hDlg);
					}
					break;

				case IDC_PREVIEW:
					GetClientRect(GetDlgItem(hDlg, IDC_STC_PAPER), &rcPreview);
					if(bFocusPresent)
					{
						nlMM=nlMM+MulDiv(nxMM, rcFocus.left, rcPreview.right);
						ntMM=ntMM+MulDiv(nyMM, rcFocus.top, rcPreview.bottom);
						nxMM=MulDiv(nxMM, rcFocus.right-rcFocus.left, rcPreview.right);
						nyMM=MulDiv(nyMM, rcFocus.bottom-rcFocus.top, rcPreview.bottom);
						pUintTypes = GetSupportedSupportedSizes(&iNumItems);
						sprintf(strTmp, "%d", nxMM);
						SetWindowText(GetDlgItem(hDlg, IDC_WIDTH), strTmp);
						sprintf(strTmp, "%d", nyMM);
						SetWindowText(GetDlgItem(hDlg, IDC_HEIGHT), strTmp);
						sprintf(strTmp, "%d", ntMM);
						SetWindowText(GetDlgItem(hDlg, IDC_TOP), strTmp);
						sprintf(strTmp, "%d", nlMM);
						SetWindowText(GetDlgItem(hDlg, IDC_LEFT), strTmp);

						ComboBox_SelectString(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE), 0, StringFromPaperSize(pUintTypes[0]));
						iIndex = ComboBox_GetCurSel(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE));
						SetCurrentSupportedSizes((TW_UINT16)ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE), iIndex));

						EnableWindow(GetDlgItem(hDlg, IDC_WIDTH), TRUE);
						EnableWindow(GetDlgItem(hDlg, IDC_HEIGHT), TRUE);
						EnableWindow(GetDlgItem(hDlg, IDC_LEFT), TRUE);
						EnableWindow(GetDlgItem(hDlg, IDC_TOP), TRUE);

						ResizePaper(hDlg);
					}
					SetNumPages(1);

					fResolution=(float)MulDiv(rcPreview.right, 254, nxMM*10);
					if((float)MulDiv(rcPreview.bottom, 254, nyMM*10) > fResolution)
						fResolution=(float)MulDiv(rcPreview.bottom, 254, nyMM*10);

					pFloatTypes = GetSupportedXResolution(&iNumItems);
					for(iIndex=0;iIndex < iNumItems;iIndex++)
						if(pFloatTypes[iIndex] > fResolution)
						{
							fResolution=pFloatTypes[iIndex];
							break;
						}
					if(iIndex == iNumItems)
						fResolution=75.0F;
					SetCurrentXResolution(fResolution);

					SetCurrentXScaling(100.0F);

					iIndex = ComboBox_GetCurSel(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE));
					SetCurrentSupportedSizes((TW_UINT16)ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE), iIndex));

					iIndex = ComboBox_GetCurSel(GetDlgItem(hDlg, ID_COMBO_SCANMODE));
					SetCurrentPixelType((TW_UINT16)LOWORD(ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_SCANMODE), iIndex)));
					SetCurrentBitDepth((TW_UINT16)HIWORD(ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_SCANMODE), iIndex)), GetCurrentPixelType());

					if(GetCurrentSupportedSizes()==TWSS_USLETTER)
					{
						nxMM=(TW_UINT16)(8.5F * 25.4F);
						nyMM=(TW_UINT16)(11.0F * 25.4F);
						ntMM=nlMM=0;
					}
					else if(GetCurrentSupportedSizes()==TWSS_A4LETTER)
					{
						nxMM=(TW_UINT16)(8.26772F * 25.4F);
						nyMM=(TW_UINT16)(11.69291F * 25.4F);
						ntMM=nlMM=0;
					}

					if(!StartScan(&dwLineSize))
						break;
					hDIB=ScanToDIB();
					if(!hDIB)
						break;
					if(hBmp)
						DeleteObject(hBmp);
					hBmp=NULL;
					hBmp=FixUp(hDlg, hDIB);
					if(!hBmp)
						break;
					InvalidateRect(GetDlgItem(hDlg, IDC_STC_PAPER), NULL, TRUE);
					UpdateWindow(GetDlgItem(hDlg, IDC_STC_PAPER));
					break;
			  case IDOK:									 	
					/*
					*	Update all our current settings first
					*/
					SetNumPages(1);

					iIndex = ComboBox_GetCurSel(GetDlgItem(hDlg, ID_COMBO_RESOLUTION));
					SetCurrentXResolution((float)ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_RESOLUTION), iIndex));

					SetCurrentXScaling(100.0F);

					iIndex = ComboBox_GetCurSel(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE));
					SetCurrentSupportedSizes((TW_UINT16)ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE), iIndex));

					iIndex = ComboBox_GetCurSel(GetDlgItem(hDlg, ID_COMBO_SCANMODE));
					SetCurrentPixelType((TW_UINT16)LOWORD(ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_SCANMODE), iIndex)));
					SetCurrentBitDepth((TW_UINT16)HIWORD(ComboBox_GetItemData(GetDlgItem(hDlg, ID_COMBO_SCANMODE), iIndex)), GetCurrentPixelType());

					/*
					*	For now, just fall through
					* NotifyXferReady comes later
					*/
					if(hBmp)
						DeleteObject(hBmp);
					hBmp=NULL;
					NotifyXferReady();
					break;
				case IDCANCEL:
					if(hBmp)
						DeleteObject(hBmp);
					hBmp=NULL;
					NotifyCloseDSReq();
					break;
				default:
					break;
			 }
			 break;

		default:
			break;
	}	  //switch
  return FALSE;
}

void ResizePaper(HWND hDlg)
{
	/*
	*	Resize the paper static control
	*/
	float fWidth = 8.5F, fHeight = 11.0F, fRatio = 0.0F;
	int iIndex = ComboBox_GetCurSel(GetDlgItem(hDlg, ID_COMBO_PAPERSIZE));
	RECT rcWndRect;
	int iWidth = 0, iHeight = 0;
	POINT ptTopLeft, ptBottomRight;
	static int nSaveWidth=-1, nSaveHeight=-1;

	if(hBmp)
		DeleteObject(hBmp);
	hBmp=NULL;
	/*
	*	Figure out where the window is now
	*/
	GetWindowRect(GetDlgItem(hDlg, IDC_STC_PAPER), &rcWndRect);
	ptTopLeft.x = rcWndRect.left;
	ptTopLeft.y = rcWndRect.top;

	ptBottomRight.x = rcWndRect.right;
	ptBottomRight.y = rcWndRect.bottom;

	ScreenToClient(hDlg, &ptTopLeft);
	ScreenToClient(hDlg, &ptBottomRight);

	/*
	* Width does not change
	*/
	iWidth = ptBottomRight.x - ptTopLeft.x;
	iHeight = ptBottomRight.y - ptTopLeft.y;

	if(nSaveWidth == -1)
		nSaveWidth=iWidth;
	if(nSaveHeight == -1)
		nSaveHeight=iHeight;

	iWidth = nSaveWidth;
	iHeight = nSaveHeight;

	fWidth = (float)nxMM/25.4F;
	fHeight = (float)nyMM/25.4F;

	iHeight = (int)((fHeight * iWidth) / fWidth);

	if(iHeight > nSaveHeight)
	{
		iWidth = nSaveWidth;
		iHeight = nSaveHeight;
		iWidth = (int)((fWidth * iHeight) / fHeight);
	}

	/*
	*	Move the window with the new dimensions
	*/
	MoveWindow(GetDlgItem(hDlg, IDC_STC_PAPER),
		ptTopLeft.x, ptTopLeft.y, iWidth, iHeight, TRUE);

	return;
}
