/*
 * Decompiled with CFR 0.152.
 */
package magick.util;

import java.lang.reflect.Field;
import magick.ClassType;
import magick.ColorspaceType;
import magick.CompositeOperator;
import magick.CompressionType;
import magick.DecorationType;
import magick.DrawInfo;
import magick.ExceptionType;
import magick.FilterType;
import magick.GeometryFlags;
import magick.GravityType;
import magick.ImageInfo;
import magick.ImageType;
import magick.InterlaceType;
import magick.MagickImage;
import magick.NoiseType;
import magick.PreviewType;
import magick.PrimitiveType;

public class DisplayImageMetaData {
    public static String nameOfpublicstaticintField(Class clazz, int n) {
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                if (fieldArray[i].getType() != Integer.TYPE || fieldArray[i].getInt(null) != n) continue;
                return fieldArray[i].getName();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n + "(unknown)";
    }

    private static String nameAndValueOfpublicstaticintField(Class clazz, int n) {
        return n + "(" + DisplayImageMetaData.nameOfpublicstaticintField(clazz, n) + ")";
    }

    public static String colorspaceTypeAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(ColorspaceType.class, n);
    }

    public static String classTypeAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(ClassType.class, n);
    }

    public static String compositeOperatorAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(CompositeOperator.class, n);
    }

    public static String compressionTypeAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(CompressionType.class, n);
    }

    public static String decorationTypeAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(DecorationType.class, n);
    }

    public static String drawInfoAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(DrawInfo.class, n);
    }

    public static String exceptionTypeAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(ExceptionType.class, n);
    }

    public static String filterTypeAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(FilterType.class, n);
    }

    public static String geometryFlagsAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(GeometryFlags.class, n);
    }

    public static String gravityTypeAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(GravityType.class, n);
    }

    public static String imageTypeAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(ImageType.class, n);
    }

    public static String interlaceTypeAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(InterlaceType.class, n);
    }

    public static String noiseTypeAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(NoiseType.class, n);
    }

    public static String previewTypeAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(PreviewType.class, n);
    }

    public static String primitiveTypeAsString(int n) {
        return DisplayImageMetaData.nameAndValueOfpublicstaticintField(PrimitiveType.class, n);
    }

    public static void displayImageInfo(ImageInfo imageInfo) {
        try {
            System.out.println("Info PreviewType is " + DisplayImageMetaData.previewTypeAsString(imageInfo.getPreviewType()));
            System.out.println("Info Monochrome is " + imageInfo.getMonochrome());
            System.out.println("Info Colorspace is " + DisplayImageMetaData.colorspaceTypeAsString(imageInfo.getColorspace()));
            System.out.println("Info Resolution units is " + imageInfo.getUnits());
            System.out.println("Info Compression is " + DisplayImageMetaData.compressionTypeAsString(imageInfo.getCompression()));
            System.out.println("Info Density is " + imageInfo.getDensity());
            System.out.println("Info magick is " + imageInfo.getMagick());
            System.out.println("Info filename is " + imageInfo.getFileName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void displayMagickImage(MagickImage magickImage) {
        try {
            System.out.println("ImageName is " + magickImage.getFileName());
            System.out.println("ImageFormat is " + magickImage.getImageFormat());
            System.out.println("Imagetype is " + DisplayImageMetaData.imageTypeAsString(magickImage.getImageType()));
            System.out.println("Compression is " + DisplayImageMetaData.compressionTypeAsString(magickImage.getCompression()));
            System.out.println("Colorspace is " + DisplayImageMetaData.colorspaceTypeAsString(magickImage.getColorspace()));
            System.out.println("Resolution units is " + magickImage.getUnits());
            System.out.println("Depth is " + magickImage.getDepth());
            System.out.println("X resolution is " + magickImage.getXResolution());
            System.out.println("Y resolution is " + magickImage.getYResolution());
            System.out.println("Size blob is " + magickImage.sizeBlob());
            System.out.println("Colors " + magickImage.getColors());
            System.out.println("Total colors " + magickImage.getTotalColors());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

