/*
 * Decompiled with CFR 0.152.
 */
package magick.util;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import magick.MagickImage;
import magick.MagickProducer;

public class MagickCanvas
extends Canvas {
    private Image image = null;
    private int width = 0;
    private int height = 0;

    public void setImage(MagickImage magickImage) {
        this.image = this.createImage(new MagickProducer(magickImage));
        ImageNotification imageNotification = new ImageNotification();
        this.width = this.image.getWidth(imageNotification);
        this.height = this.image.getHeight(imageNotification);
        if (this.width > 0 && this.height > 0) {
            this.setSize(this.width, this.height);
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, this);
        } else {
            super.paint(graphics);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    private class ImageNotification
    implements ImageObserver {
        private ImageNotification() {
        }

        @Override
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            MagickCanvas.this.width = n4;
            MagickCanvas.this.height = n5;
            MagickCanvas.this.setSize(n4, n5);
            MagickCanvas.this.repaint();
            return false;
        }
    }
}

