/*
 *  This file is part of MagiCapture.
 *  Copyright (C) 1999 Arthur Jerijian
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MAGICAPTURE_SAVE_H__
#define __MAGICAPTURE_SAVE_H__

/* Function declarations */

gint save_dialog_delete_event
(
    GtkWidget *widget,
    GdkEvent *event,
    gpointer data
);
void save_dialog_destroy_event (GtkWidget *widget, gpointer data);
gint save_filetype_delete_event
(
    GtkWidget *widget,
    GdkEvent *event,
    gpointer data
);
void save_filetype_destroy_event (GtkWidget *widget, gpointer data);

void save_init ();
void save_cleanup ();
void save_create_dialog ();
void save_create_filetype_dialog ();

void save_filetype_menu_select (GtkWidget *widget, gchar *filetype);
void save_filetype_clist_select
(
    GtkWidget *widget,
    gint row,
    gint column,
    GdkEventButton *event,
    gpointer data
);
void save_filetype_set (gchar *filetype);

void save_do (Image *image, ImageInfo *image_info);
void save_ok (GtkWidget *widget, GtkFileSelection *filesel);
gboolean save_image_to_file (gchar *save_path);

#endif /* __MAGICAPTURE_SAVE_H__ */
