/*
 *  This file is part of MagiCapture.
 *  Copyright (C) 1999 Arthur Jerijian
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MAGICAPTURE_WIDGET_H__
#define __MAGICAPTURE_WIDGET_H__

/* Constants */

#define DELAY_TEXTBOX_SIZE 3

/* Function declarations */

void add_button
(
    GtkWidget *box,
    GtkObject *object,
    GtkSignalFunc button_func,
    const gchar *button_text
);
void add_checkbox
(
    GtkWidget *box,
    GtkObject *object,
    GtkSignalFunc checkbox_func,
    gint active,
    const gchar *checkbox_text
);
GSList *add_radio
(
    GtkWidget *box,
    GtkObject *object,
    GSList *group,
    GtkSignalFunc radio_func,
    gint active,
    const gchar *radio_text
);
void add_menu_item
(
    GtkWidget *menu,
    GtkSignalFunc menu_item_func,
    const gchar *item_text,
    gpointer data
);
void add_separator (GtkWidget *box);
void add_label (GtkWidget *box, const gchar *label_text);
void add_delay (GtkWidget *box, GtkSignalFunc delay_func);

#endif /* __MAGICAPTURE_WIDGET_H__ */
