#!/usr/bin/env ruby
#
# $Id: search.rb,v 1.10 2002/05/01 20:24:30 ianmacd Exp $

require 'google'

KEY = File.open("#{ENV['HOME']}/.google_key") {|kf| kf.readline.chomp}
google = Google::Search.new(KEY)

query = ARGV.shift || 'ruby programming language'
query << Google::Search.restrict('daterange', 2002, 1, 1)

i = 0 
q = google.search(query)
q.resultElements.each do |result|
  printf "\nResult # %d\n\n", i += 1
  result.each do |key|
    printf("%s = %s\n", key, result.send(key))
  end
end

puts '---------------------------------'
i = 0
q.directoryCategories.each do |category|
  printf "\nCategory # %d\n\n", i += 1
  category.each do |key|
    printf("%s = %s\n", key, category.send(key))
  end
end

printf "Estimated number of results is %d.\n",
	q.estimatedTotalResultsCount
printf "Your query took %6f seconds.\n", q.searchTime
