-- Copyright (c) 2004-2005 Sean Chittenden <sean@chittenden.org>
-- Copyright (c) 2007 Neil Conway <neilc@samurai.com>
-- Copyright (c) 2007 Open Technology Group, Inc. <http://www.otg-nc.com>
--
-- See the file COPYING for distribution terms.

-- Adjust this setting to control where the objects get created.
SET search_path = public;

-- $1 = server hostname - TEXT
-- $2 = port number - TEXT (opt)
CREATE OR REPLACE FUNCTION memcache_server_add(TEXT, TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_server_add' LANGUAGE 'C' STRICT;
CREATE OR REPLACE FUNCTION memcache_server_add(TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_server_add' LANGUAGE 'C' STRICT;

-- $1 = server hostname - TEXT
-- $1 = port number - TEXT (opt)
CREATE OR REPLACE FUNCTION memcache_server_remove(TEXT, TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_server_remove' LANGUAGE 'C' STRICT;
CREATE OR REPLACE FUNCTION memcache_server_remove(TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_server_remove' LANGUAGE 'C' STRICT;

-- $1 = key to look up server with - TEXT
CREATE OR REPLACE FUNCTION memcache_server_find(IN TEXT, OUT host TEXT, OUT port INT4)
RETURNS RECORD AS '$libdir/pgmemcache', 'memcache_server_find' LANGUAGE 'C' STRICT;

-- $1 = hash value to look up server with - INT4
CREATE OR REPLACE FUNCTION memcache_server_find(IN INT4, OUT host TEXT, OUT port INT4)
RETURNS RECORD AS '$libdir/pgmemcache', 'memcache_server_find_hash' LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION memcache_server_list(OUT hostname TEXT, OUT port INT4, OUT status TEXT)
RETURNS SETOF RECORD AS '$libdir/pgmemcache', 'memcache_server_list' LANGUAGE 'C';

-- $1 = key - TEXT
-- $2 = val - TEXT (opt)
-- $3 = expire - INTERVAL or TIMESTAMPTZ (opt)
-- $4 = flags - INT4 (opt)
CREATE OR REPLACE FUNCTION memcache_add(TEXT, TEXT, INTERVAL) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_add' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_add(TEXT, TEXT, TIMESTAMPTZ) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_add_absexpire' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_add(TEXT, TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_add' LANGUAGE 'C';


-- $1 = key - TEXT
CREATE OR REPLACE FUNCTION memcache_get(TEXT) RETURNS TEXT
AS '$libdir/pgmemcache', 'memcache_get' LANGUAGE 'C';


-- $1 = key - TEXT
-- $2 = decrement - INT4, default 1 (opt)
CREATE OR REPLACE FUNCTION memcache_decr(TEXT, INT4) RETURNS INT4
AS '$libdir/pgmemcache', 'memcache_decr' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_decr(TEXT) RETURNS INT4
AS '$libdir/pgmemcache', 'memcache_decr' LANGUAGE 'C';


-- $1 = key - TEXT
-- $2 = increment - INT4, default 1 (opt)
CREATE OR REPLACE FUNCTION memcache_incr(TEXT, INT4) RETURNS INT4
AS '$libdir/pgmemcache', 'memcache_incr' LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION memcache_incr(TEXT) RETURNS INT4
AS '$libdir/pgmemcache', 'memcache_incr' LANGUAGE 'C' STRICT;


-- $1 = key - TEXT
-- $2 = hold timer - INTERVAL (opt)
CREATE OR REPLACE FUNCTION memcache_delete(TEXT, INTERVAL) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_delete' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_delete(TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_delete' LANGUAGE 'C';

-- Flush all servers in the cluster
CREATE OR REPLACE FUNCTION memcache_flush_all() RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_flush_all0' LANGUAGE 'C';

-- $1 = key to server to be flushed
CREATE OR REPLACE FUNCTION memcache_flush(TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_flush' LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION memcache_hash(TEXT) RETURNS INT4
AS '$libdir/pgmemcache', 'memcache_hash' LANGUAGE 'C' STRICT;


-- $1 = key - TEXT
-- $2 = val - TEXT
-- $3 = expire - INTERVAL or TIMESTAMPTZ (opt)
CREATE OR REPLACE FUNCTION memcache_replace(TEXT, TEXT, INTERVAL) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_replace' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_replace(TEXT, TEXT, TIMESTAMPTZ) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_replace_absexpire' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_replace(TEXT, TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_replace' LANGUAGE 'C';

-- $1 = key - TEXT
-- $2 = val - TEXT
-- $3 = expire - INTERVAL or TIMESTAMPTZ (opt)
CREATE OR REPLACE FUNCTION memcache_set(TEXT, TEXT, INTERVAL) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_set' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_set(TEXT, TEXT, TIMESTAMPTZ) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_set_absexpire' LANGUAGE 'C';

CREATE OR REPLACE FUNCTION memcache_set(TEXT, TEXT) RETURNS BOOL
AS '$libdir/pgmemcache', 'memcache_set' LANGUAGE 'C';


CREATE OR REPLACE FUNCTION memcache_stats() RETURNS TEXT
AS '$libdir/pgmemcache', 'memcache_stats' LANGUAGE 'C';

-- $1 = stat name - TEXT
CREATE OR REPLACE FUNCTION memcache_stats(TEXT) RETURNS TEXT
AS '$libdir/pgmemcache', 'memcache_stat' LANGUAGE 'C' STRICT;
