/* -*- mode: c -*-
 *
 * $Id: iconv.h.replace,v 1.1 2002/06/08 09:19:01 tai Exp $
 *
 */

/**
 * Replacement for real iconv.h.
 * This (re-)defines iconv* functions so they will be macro-expanded
 * to iconv_hook* functions which are included in this library.
 *
 * Using this header file, switching to iconv_hook from iconv is
 * easy, as adding
 *
 *   -Iiconv_hook_folder -Liconv_hook_folder -liconv_hook
 *
 * options is the only thing needed.
 */

#ifndef ICONV_H
#define ICONV_H

/* Force override by iconv_hook */
#undef  iconv
#undef  iconv_open
#undef  iconv_close
#define iconv       iconv_hook
#define iconv_open  iconv_hook_open
#define iconv_close iconv_hook_close

typedef void * iconv_t;

iconv_t
iconv_hook_open(const char *ienc, const char *oenc);

int
iconv_hook_close(iconv_t cd);

size_t
iconv_hook(iconv_t cd,
	   char **src, size_t *srclen, char **outbuf, size_t *outlen);

#endif
