/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __ls10_nvlinkip_discovery_h__
#define __ls10_nvlinkip_discovery_h__
/* This file is autogenerated.  Do not edit */
#define NV_NVLINKIP_DISCOVERY_COMMON                     /* R--4P */
#define NV_NVLINKIP_DISCOVERY_COMMON_ENTRY                 1:0         /* R-EVF */
#define NV_NVLINKIP_DISCOVERY_COMMON_ENTRY_INVALID         0x00000000   /* R-E-V */
#define NV_NVLINKIP_DISCOVERY_COMMON_ENTRY_ENUM            0x00000001   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_ENTRY_DATA1           0x00000002   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_ENTRY_DATA2           0x00000003   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_CONTENTS              30:2         /* R-EVF */
#define NV_NVLINKIP_DISCOVERY_COMMON_CONTENTS_INIT         0x00000000   /* R-E-V */
#define NV_NVLINKIP_DISCOVERY_COMMON_CHAIN                 31:31        /* R-EVF */
#define NV_NVLINKIP_DISCOVERY_COMMON_CHAIN_DISABLE      0x00000000   /* R-E-V */
#define NV_NVLINKIP_DISCOVERY_COMMON_CHAIN_ENABLE       0x00000001   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE                       7:2   /* R--UF */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_INVALID                   0x0   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_IOCTRL                    0x1   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_NVLTL                  0x2   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_NVLINK                    0x3   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_MINION                    0x4   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_NVLIPT                    0x5   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_NVLTLC                    0x6   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_IOCTRLMIF                  0x7   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_DLPL_MULTICAST            0x8   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_NVLTLC_MULTICAST          0x9   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_IOCTRLMIF_MULTICAST       0xA   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_DLPL              0xB   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_SIOCTRL                    0xC   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_TIOCTRL                    0xD   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_SIOCTRL_PERFMON            0xE   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_NVLIPT_SYS_PERFMON        0xF   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_TX_PERFMON_MULTICAST      0x10  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_RX_PERFMON_MULTICAST      0x11  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_TX_PERFMON                0x12  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_RX_PERFMON                  0x13  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_NVLW                    0x14  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_NVLW_PERFMON            0x15  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_NVLDL              0x16  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_NVLDL_MULTICAST           0x17  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_SYS_PERFMON               0x18  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_SYS_PERFMON_MULTICAST     0x19  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_NVLIPT_LNK            0x1A  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_NVLIPT_LNK_MULTICAST       0x1B  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_PLL                    0x1C  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DEVICE_CPR                    0x1D  /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_ID                      15:8  /* R--UF */
#define NV_NVLINKIP_DISCOVERY_COMMON_RESERVED                  19:16 /* R--UF */
#define NV_NVLINKIP_DISCOVERY_COMMON_VERSION                  30:20 /* R--UF */
#define NV_NVLINKIP_DISCOVERY_COMMON_VERSION_NVLINK10              0x1   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_VERSION_NVLINK20              0x2   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_VERSION_3                      0x3   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_VERSION_NVLINK22              0x4   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_VERSION_NVLINK30              0x5   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_VERSION_NVLINK31              0x6   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_VERSION_NVLINK40              0x7   /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA1_RESERVED          30:12  /* R--UF */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA1_IOCTRL_LENGTH      30:12  /* R--UF */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA1_RESERVED2                  11:2  /* R--UF */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA2_TYPE                  30:26  /* R--UF */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA2_TYPE_INVALID          0x0    /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA2_TYPE_PLLCONTROL      0x1    /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA2_TYPE_RESETREG      0x2    /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA2_TYPE_INTRREG          0x3    /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA2_TYPE_DISCOVERY      0x4    /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA2_TYPE_UNICAST          0x5    /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA2_TYPE_BROADCAST         0x6    /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA2_TYPE_MULTICAST0        0x7    /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA2_TYPE_MULTICAST1        0x8    /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA2_TYPE_MULTICAST2        0x9    /* R---V */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA2_ADDR                  25:2   /* R--UF */
#define NV_NVLINKIP_DISCOVERY_COMMON_DATA2_ADDR_ALIGN                2   /*       */
#endif // __ls10_nvlinkip_discovery_h__
