# frozen_string_literal: true

class AddVulnerabilityIssueLinksProjectIdTrigger < Gitlab::Database::Migration[2.2]
  milestone '17.1'

  def up
    install_sharding_key_assignment_trigger(
      table: :vulnerability_issue_links,
      sharding_key: :project_id,
      parent_table: :vulnerabilities,
      parent_sharding_key: :project_id,
      foreign_key: :vulnerability_id
    )
  end

  def down
    remove_sharding_key_assignment_trigger(
      table: :vulnerability_issue_links,
      sharding_key: :project_id,
      parent_table: :vulnerabilities,
      parent_sharding_key: :project_id,
      foreign_key: :vulnerability_id
    )
  end
end
