/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.performance.results;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

/**
 *
 * @author  radim
 */
public class ComparePanel extends javax.swing.JPanel {

    private static File wd;

    DefaultListModel refFilesModel = new DefaultListModel();
    DefaultListModel newFilesModel = new DefaultListModel();

    /** Creates new form ComparePanel */
    public ComparePanel() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        txtRefFile = new javax.swing.JTextField();
        btnRefFileBrowse = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        lstRefFiles = new javax.swing.JList();
        btnRefFileAdd = new javax.swing.JButton();
        btnRefFileRemove = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        txtNewFile = new javax.swing.JTextField();
        btnNewFileBrowse = new javax.swing.JButton();
        btnNewFileAdd = new javax.swing.JButton();
        btnNewFileRemove = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        lstNewFiles = new javax.swing.JList();
        btnCompare = new javax.swing.JButton();

        jLabel1.setText("Reference results:");

        btnRefFileBrowse.setText("Browse");
        btnRefFileBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnRefFileBrowseActionPerformed(evt);
            }
        });

        lstRefFiles.setModel(refFilesModel);
        jScrollPane1.setViewportView(lstRefFiles);

        btnRefFileAdd.setText("Add");
        btnRefFileAdd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnRefFileAddActionPerformed(evt);
            }
        });

        btnRefFileRemove.setText("Remove");
        btnRefFileRemove.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnRefFileRemoveActionPerformed(evt);
            }
        });

        jLabel2.setText("Compared results:");

        btnNewFileBrowse.setText("Browse");
        btnNewFileBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnNewFileBrowseActionPerformed(evt);
            }
        });

        btnNewFileAdd.setText("Add");
        btnNewFileAdd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnNewFileAddActionPerformed(evt);
            }
        });

        btnNewFileRemove.setText("Remove");
        btnNewFileRemove.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnNewFileRemoveActionPerformed(evt);
            }
        });

        lstNewFiles.setModel(newFilesModel);
        jScrollPane2.setViewportView(lstNewFiles);

        btnCompare.setText("Compare");
        btnCompare.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCompareActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addComponent(jLabel2)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 287, Short.MAX_VALUE)
                            .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 287, Short.MAX_VALUE)
                            .addComponent(txtRefFile, javax.swing.GroupLayout.DEFAULT_SIZE, 287, Short.MAX_VALUE)
                            .addComponent(txtNewFile, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 287, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                    .addComponent(btnRefFileAdd, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(btnRefFileBrowse, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(btnRefFileRemove, javax.swing.GroupLayout.PREFERRED_SIZE, 83, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addComponent(btnNewFileAdd)
                                .addComponent(btnNewFileBrowse))
                            .addComponent(btnNewFileRemove, javax.swing.GroupLayout.PREFERRED_SIZE, 83, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(btnCompare, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {btnNewFileAdd, btnNewFileBrowse, btnNewFileRemove, btnRefFileAdd, btnRefFileBrowse, btnRefFileRemove});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnRefFileBrowse)
                    .addComponent(txtRefFile, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(btnRefFileAdd)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnRefFileRemove))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(txtNewFile, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnNewFileBrowse))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(btnNewFileAdd)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnNewFileRemove))
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 107, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE)
                .addComponent(btnCompare)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void btnCompareActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCompareActionPerformed

        Object [] files = refFilesModel.toArray();
        Set<File> refFiles = new TreeSet<File>();
        for (Object s: files) {
            refFiles.add(new File((String)s));
        }
        files = newFilesModel.toArray();
        Set<File> newFiles = new TreeSet<File>();
        for (Object s: files) {
            newFiles.add(new File((String)s));
        }
        try {
            ReportUtils.doCompare(refFiles, newFiles);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }//GEN-LAST:event_btnCompareActionPerformed

    private void btnNewFileRemoveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnNewFileRemoveActionPerformed
        int idx = lstNewFiles.getSelectedIndex();
        if (idx != -1) {
            newFilesModel.remove(idx);
        }
    }//GEN-LAST:event_btnNewFileRemoveActionPerformed

    private void btnNewFileAddActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnNewFileAddActionPerformed
        String f = txtNewFile.getText();
        if (f != null && !"".equals(f)) {
            newFilesModel.add(0, f);
        }
    }//GEN-LAST:event_btnNewFileAddActionPerformed

    private void btnNewFileBrowseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnNewFileBrowseActionPerformed
        JFileChooser fc = new JFileChooser(wd);
        FileFilter filter = new FileFilter() {
            public boolean accept(File f) {
                return f.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "XML files";
            }

        };
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this);
        if(result == JFileChooser.APPROVE_OPTION) {
            txtNewFile.setText (fc.getSelectedFile().getPath());
            wd = fc.getCurrentDirectory();
        }
    }//GEN-LAST:event_btnNewFileBrowseActionPerformed

    private void btnRefFileRemoveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnRefFileRemoveActionPerformed

        int idx = lstRefFiles.getSelectedIndex();
        if (idx != -1) {
            refFilesModel.remove(idx);
        }
    }//GEN-LAST:event_btnRefFileRemoveActionPerformed

    private void btnRefFileAddActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnRefFileAddActionPerformed

        String f = txtRefFile.getText();
        if (f != null && !"".equals(f)) {
            refFilesModel.add(0, f);
        }
    }//GEN-LAST:event_btnRefFileAddActionPerformed

    private void btnRefFileBrowseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnRefFileBrowseActionPerformed

        JFileChooser fc = new JFileChooser(wd);
        FileFilter filter = new FileFilter() {
            public boolean accept(File f) {
                return f.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "XML files";
            }

        };
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this);
        if(result == JFileChooser.APPROVE_OPTION) {
            txtRefFile.setText (fc.getSelectedFile().getPath());
            wd = fc.getCurrentDirectory();
        }
    }//GEN-LAST:event_btnRefFileBrowseActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCompare;
    private javax.swing.JButton btnNewFileAdd;
    private javax.swing.JButton btnNewFileBrowse;
    private javax.swing.JButton btnNewFileRemove;
    private javax.swing.JButton btnRefFileAdd;
    private javax.swing.JButton btnRefFileBrowse;
    private javax.swing.JButton btnRefFileRemove;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JList lstNewFiles;
    private javax.swing.JList lstRefFiles;
    private javax.swing.JTextField txtNewFile;
    private javax.swing.JTextField txtRefFile;
    // End of variables declaration//GEN-END:variables
    
}
