/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.lib.profiler.charts.xy;

import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ItemPainter;

/**
 *
 * @author Jiri Sedlacek
 */
public interface XYItemPainter extends ItemPainter {

    public static final int TYPE_ABSOLUTE = 0;
    public static final int TYPE_RELATIVE = 1;
    

    public double getItemView(double dataY, XYItem item, ChartContext context);

    public double getItemValue(double viewY, XYItem item, ChartContext context);

    public double getItemValueScale(XYItem item, ChartContext context);


    public static abstract class Abstract implements XYItemPainter {

        public double getItemView(double dataY, XYItem item, ChartContext context) {
            return context.getViewY(dataY);
        }

        public double getItemValue(double viewY, XYItem item, ChartContext context) {
            return context.getDataY(viewY);
        }

        public double getItemValueScale(XYItem item, ChartContext context) {
            double scale = context.getViewHeight(1d);
            if (scale <= 0) scale = -1;
            return scale;
        }

    }

}
