/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleableShapeElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumFormatAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumLetterSyncAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextCountEmptyLinesAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextCountInTextBoxesAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextIncrementAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextNumberLinesAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextNumberPositionAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextOffsetAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextRestartOnPageAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStyleNameAttribute;

/**
 * DOM implementation of OpenDocument element  {@odf.element text:linenumbering-configuration}.
 *
 */
public class TextLinenumberingConfigurationElement extends OdfStylableElement {

	public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "linenumbering-configuration");

	/**
	 * Create the instance of <code>TextLinenumberingConfigurationElement</code>
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TextLinenumberingConfigurationElement(OdfFileDom ownerDoc) {
		super(ownerDoc, ELEMENT_NAME, OdfStyleFamily.Text, OdfName.newName(OdfDocumentNamespace.TEXT, "style-name"));
	}

	/**
	 * Get the element name
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element text:linenumbering-configuration}.
	 */
	public OdfName getOdfName() {
		return ELEMENT_NAME;
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleNumFormatAttribute</code> , See {@odf.attribute style:num-format}
	 *
	 * Attribute is mandatory.
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleNumFormatAttribute() {
		StyleNumFormatAttribute attr = (StyleNumFormatAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "num-format");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleNumFormatAttribute</code> , See {@odf.attribute style:num-format}
	 *
	 * @param styleNumFormatValue   The type is <code>String</code>
	 */
	public void setStyleNumFormatAttribute(String styleNumFormatValue) {
		StyleNumFormatAttribute attr = new StyleNumFormatAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleNumFormatValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleNumLetterSyncAttribute</code> , See {@odf.attribute style:num-letter-sync}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleNumLetterSyncAttribute() {
		StyleNumLetterSyncAttribute attr = (StyleNumLetterSyncAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "num-letter-sync");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleNumLetterSyncAttribute</code> , See {@odf.attribute style:num-letter-sync}
	 *
	 * @param styleNumLetterSyncValue   The type is <code>Boolean</code>
	 */
	public void setStyleNumLetterSyncAttribute(Boolean styleNumLetterSyncValue) {
		StyleNumLetterSyncAttribute attr = new StyleNumLetterSyncAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(styleNumLetterSyncValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextCountEmptyLinesAttribute</code> , See {@odf.attribute text:count-empty-lines}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTextCountEmptyLinesAttribute() {
		TextCountEmptyLinesAttribute attr = (TextCountEmptyLinesAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "count-empty-lines");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return Boolean.valueOf(TextCountEmptyLinesAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextCountEmptyLinesAttribute</code> , See {@odf.attribute text:count-empty-lines}
	 *
	 * @param textCountEmptyLinesValue   The type is <code>Boolean</code>
	 */
	public void setTextCountEmptyLinesAttribute(Boolean textCountEmptyLinesValue) {
		TextCountEmptyLinesAttribute attr = new TextCountEmptyLinesAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(textCountEmptyLinesValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextCountInTextBoxesAttribute</code> , See {@odf.attribute text:count-in-text-boxes}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTextCountInTextBoxesAttribute() {
		TextCountInTextBoxesAttribute attr = (TextCountInTextBoxesAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "count-in-text-boxes");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return Boolean.valueOf(TextCountInTextBoxesAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextCountInTextBoxesAttribute</code> , See {@odf.attribute text:count-in-text-boxes}
	 *
	 * @param textCountInTextBoxesValue   The type is <code>Boolean</code>
	 */
	public void setTextCountInTextBoxesAttribute(Boolean textCountInTextBoxesValue) {
		TextCountInTextBoxesAttribute attr = new TextCountInTextBoxesAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(textCountInTextBoxesValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextIncrementAttribute</code> , See {@odf.attribute text:increment}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTextIncrementAttribute() {
		TextIncrementAttribute attr = (TextIncrementAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "increment");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextIncrementAttribute</code> , See {@odf.attribute text:increment}
	 *
	 * @param textIncrementValue   The type is <code>Integer</code>
	 */
	public void setTextIncrementAttribute(Integer textIncrementValue) {
		TextIncrementAttribute attr = new TextIncrementAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(textIncrementValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextNumberLinesAttribute</code> , See {@odf.attribute text:number-lines}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTextNumberLinesAttribute() {
		TextNumberLinesAttribute attr = (TextNumberLinesAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "number-lines");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return Boolean.valueOf(TextNumberLinesAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextNumberLinesAttribute</code> , See {@odf.attribute text:number-lines}
	 *
	 * @param textNumberLinesValue   The type is <code>Boolean</code>
	 */
	public void setTextNumberLinesAttribute(Boolean textNumberLinesValue) {
		TextNumberLinesAttribute attr = new TextNumberLinesAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(textNumberLinesValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextNumberPositionAttribute</code> , See {@odf.attribute text:number-position}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextNumberPositionAttribute() {
		TextNumberPositionAttribute attr = (TextNumberPositionAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "number-position");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return TextNumberPositionAttribute.DEFAULT_VALUE;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextNumberPositionAttribute</code> , See {@odf.attribute text:number-position}
	 *
	 * @param textNumberPositionValue   The type is <code>String</code>
	 */
	public void setTextNumberPositionAttribute(String textNumberPositionValue) {
		TextNumberPositionAttribute attr = new TextNumberPositionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(textNumberPositionValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextOffsetAttribute</code> , See {@odf.attribute text:offset}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextOffsetAttribute() {
		TextOffsetAttribute attr = (TextOffsetAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "offset");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextOffsetAttribute</code> , See {@odf.attribute text:offset}
	 *
	 * @param textOffsetValue   The type is <code>String</code>
	 */
	public void setTextOffsetAttribute(String textOffsetValue) {
		TextOffsetAttribute attr = new TextOffsetAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(textOffsetValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextRestartOnPageAttribute</code> , See {@odf.attribute text:restart-on-page}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTextRestartOnPageAttribute() {
		TextRestartOnPageAttribute attr = (TextRestartOnPageAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "restart-on-page");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return Boolean.valueOf(TextRestartOnPageAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextRestartOnPageAttribute</code> , See {@odf.attribute text:restart-on-page}
	 *
	 * @param textRestartOnPageValue   The type is <code>Boolean</code>
	 */
	public void setTextRestartOnPageAttribute(Boolean textRestartOnPageValue) {
		TextRestartOnPageAttribute attr = new TextRestartOnPageAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(textRestartOnPageValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextStyleNameAttribute</code> , See {@odf.attribute text:style-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextStyleNameAttribute() {
		TextStyleNameAttribute attr = (TextStyleNameAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "style-name");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextStyleNameAttribute</code> , See {@odf.attribute text:style-name}
	 *
	 * @param textStyleNameValue   The type is <code>String</code>
	 */
	public void setTextStyleNameAttribute(String textStyleNameValue) {
		TextStyleNameAttribute attr = new TextStyleNameAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(textStyleNameValue);
	}

	/**
	 * Create child element {@odf.element text:linenumbering-separator}.
	 *
	 * @return the element {@odf.element text:linenumbering-separator}
	 */
	public TextLinenumberingSeparatorElement newTextLinenumberingSeparatorElement() {
		TextLinenumberingSeparatorElement textLinenumberingSeparator = ((OdfFileDom) this.ownerDocument).newOdfElement(TextLinenumberingSeparatorElement.class);
		this.appendChild(textLinenumberingSeparator);
		return textLinenumberingSeparator;
	}

	@Override
	public void accept(ElementVisitor visitor) {
		if (visitor instanceof DefaultElementVisitor) {
			DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
			defaultVisitor.visit(this);
		} else {
			visitor.visit(this);
		}
	}
}
