/*
 * Contributed by Stephane Eranian <eranian@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 *
 * PMU: spr_unc_upi_ll (SapphireRapids Uncore UPI)
 * Based on Intel JSON event table version   : 1.17
 * Based on Intel JSON event table published : 11/09/2023
 */
static const intel_x86_umask_t spr_unc_upi_direct_attempts[]={
  { .uname   = "D2C",
    .udesc   = "D2C (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "D2K",
    .udesc   = "D2K (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_upi_flowq_no_vna_crd[]={
  { .uname   = "AD_VNA_EQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_VNA_EQ1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_VNA_EQ2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_VNA_EQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_VNA_EQ1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_VNA_EQ2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_VNA_EQ3",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_VNA_EQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_upi_m3_byp_blocked[]={
  { .uname   = "BGF_CRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_AD_VNA_LE2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_AK_VNA_LE3",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_BL_VNA_EQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "GV_BLOCK",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_upi_m3_rxq_blocked[]={
  { .uname   = "BGF_CRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_AD_VNA_BTW_2_THRESH",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_AD_VNA_LE2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_AK_VNA_LE3",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_BL_VNA_BTW_0_THRESH",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_BL_VNA_EQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "GV_BLOCK",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_upi_req_slot2_from_m3[]={
  { .uname   = "ACK",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VNA",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_upi_rxl_flits[]={
  { .uname   = "ALL_DATA",
    .udesc   = "All Data",
    .ucode   = 0x0f00ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "ALL_NULL",
    .udesc   = "Null FLITs received from any slot",
    .ucode   = 0x2700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA",
    .udesc   = "Data (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IDLE",
    .udesc   = "Idle (experimental)",
    .ucode   = 0x4700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLCRD",
    .udesc   = "LLCRD Not Empty (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLCTRL",
    .udesc   = "LLCTRL (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NON_DATA",
    .udesc   = "All Non Data",
    .ucode   = 0x9700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NULL",
    .udesc   = "Slot NULL or LLCRD Empty (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PROTHDR",
    .udesc   = "Protocol Header (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT0",
    .udesc   = "Slot 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT1",
    .udesc   = "Slot 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT2",
    .udesc   = "Slot 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_upi_rxl_inserts[]={
  { .uname   = "SLOT0",
    .udesc   = "Slot 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT1",
    .udesc   = "Slot 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT2",
    .udesc   = "Slot 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_upi_rxl_occupancy[]={
  { .uname   = "SLOT0",
    .udesc   = "Slot 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT1",
    .udesc   = "Slot 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT2",
    .udesc   = "Slot 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_upi_rxl_slot_bypass[]={
  { .uname   = "S0_RXQ1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S0_RXQ2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S1_RXQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S1_RXQ2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S2_RXQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S2_RXQ1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_upi_txl0p_clk_active[]={
  { .uname   = "CFG_CTL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DFX",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RETRY",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RXQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RXQ_BYPASS",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RXQ_CRED",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SPARE",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TXQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_upi_txl_any_flits[]={
  { .uname   = "DATA",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLCRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLCTRL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NULL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PROTHDR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_upi_txl_flits[]={
  { .uname   = "ALL_DATA",
    .udesc   = "All Data",
    .ucode   = 0x0f00ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "ALL_LLCRD",
    .udesc   = "All LLCRD Not Empty (experimental)",
    .ucode   = 0x1700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ALL_LLCTRL",
    .udesc   = "All LLCTRL (experimental)",
    .ucode   = 0x4700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ALL_NULL",
    .udesc   = "All Null Flits",
    .ucode   = 0x2700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ALL_PROTHDR",
    .udesc   = "All Protocol Header (experimental)",
    .ucode   = 0x8700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA",
    .udesc   = "Data (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IDLE",
    .udesc   = "Idle (experimental)",
    .ucode   = 0x4700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLCRD",
    .udesc   = "LLCRD Not Empty (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLCTRL",
    .udesc   = "LLCTRL (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NON_DATA",
    .udesc   = "All Non Data",
    .ucode   = 0x9700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NULL",
    .udesc   = "Slot NULL or LLCRD Empty (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PROTHDR",
    .udesc   = "Protocol Header (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT0",
    .udesc   = "Slot 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT1",
    .udesc   = "Slot 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT2",
    .udesc   = "Slot 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_entry_t intel_spr_unc_upi_ll_pe[]={
  { .name   = "UNC_UPI_CLOCKTICKS",
    .desc   = "UPI Clockticks",
    .code   = 0x0001,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_DIRECT_ATTEMPTS",
    .desc   = "Direct packet attempts",
    .code   = 0x0012,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_direct_attempts),
    .umasks = spr_unc_upi_direct_attempts,
  },
  { .name   = "UNC_UPI_FLOWQ_NO_VNA_CRD",
    .desc   = "TBD",
    .code   = 0x0018,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_flowq_no_vna_crd),
    .umasks = spr_unc_upi_flowq_no_vna_crd,
  },
  { .name   = "UNC_UPI_L1_POWER_CYCLES",
    .desc   = "Cycles in L1",
    .code   = 0x0021,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_M3_BYP_BLOCKED",
    .desc   = "TBD",
    .code   = 0x0014,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_m3_byp_blocked),
    .umasks = spr_unc_upi_m3_byp_blocked,
  },
  { .name   = "UNC_UPI_M3_CRD_RETURN_BLOCKED",
    .desc   = "TBD (experimental)",
    .code   = 0x0016,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_M3_RXQ_BLOCKED",
    .desc   = "TBD",
    .code   = 0x0015,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_m3_rxq_blocked),
    .umasks = spr_unc_upi_m3_rxq_blocked,
  },
  { .name   = "UNC_UPI_PHY_INIT_CYCLES",
    .desc   = "PHY Cycles (experimental)",
    .code   = 0x0020,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_POWER_L1_NACK",
    .desc   = "L1 Req Nack (experimental)",
    .code   = 0x0023,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_POWER_L1_REQ",
    .desc   = "L1 Req (same as L1 Ack). (experimental)",
    .code   = 0x0022,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_REQ_SLOT2_FROM_M3",
    .desc   = "TBD",
    .code   = 0x0046,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_req_slot2_from_m3),
    .umasks = spr_unc_upi_req_slot2_from_m3,
  },
  { .name   = "UNC_UPI_RxL0P_POWER_CYCLES",
    .desc   = "Cycles in L0p (experimental)",
    .code   = 0x0025,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL0_POWER_CYCLES",
    .desc   = "Cycles in L0 (experimental)",
    .code   = 0x0024,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL_ANY_FLITS",
    .desc   = "TBD",
    .code   = 0x004b,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_txl_any_flits), /* shared */
    .umasks = spr_unc_upi_txl_any_flits,
  },
  { .name   = "UNC_UPI_RxL_BYPASSED",
    .desc   = "RxQ Flit Buffer Bypassed",
    .code   = 0x0031,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_rxl_inserts), /* shared */
    .umasks = spr_unc_upi_rxl_inserts,
  },
  { .name   = "UNC_UPI_RxL_CRC_ERRORS",
    .desc   = "CRC Errors Detected (experimental)",
    .code   = 0x000b,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL_CRC_LLR_REQ_TRANSMIT",
    .desc   = "LLR Requests Sent (experimental)",
    .code   = 0x0008,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL_CREDITS_CONSUMED_VN0",
    .desc   = "VN0 Credit Consumed (experimental)",
    .code   = 0x0039,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL_CREDITS_CONSUMED_VN1",
    .desc   = "VN1 Credit Consumed (experimental)",
    .code   = 0x003a,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL_CREDITS_CONSUMED_VNA",
    .desc   = "VNA Credit Consumed (experimental)",
    .code   = 0x0038,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL_FLITS",
    .desc   = "Flits Received",
    .code   = 0x0003,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_rxl_flits),
    .umasks = spr_unc_upi_rxl_flits,
  },
  { .name   = "UNC_UPI_RxL_INSERTS",
    .desc   = "Receive Flit Buffer Allocations",
    .code   = 0x0030,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_rxl_inserts),
    .umasks = spr_unc_upi_rxl_inserts,
  },
  { .name   = "UNC_UPI_RxL_OCCUPANCY",
    .desc   = "RxQ Occupancy",
    .code   = 0x0032,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_rxl_occupancy),
    .umasks = spr_unc_upi_rxl_occupancy,
  },
  { .name   = "UNC_UPI_RxL_SLOT_BYPASS",
    .desc   = "TBD",
    .code   = 0x0033,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_rxl_slot_bypass),
    .umasks = spr_unc_upi_rxl_slot_bypass,
  },
  { .name   = "UNC_UPI_TxL0P_CLK_ACTIVE",
    .desc   = "TBD",
    .code   = 0x002a,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_txl0p_clk_active),
    .umasks = spr_unc_upi_txl0p_clk_active,
  },
  { .name   = "UNC_UPI_TxL0P_POWER_CYCLES",
    .desc   = "Cycles in L0p (experimental)",
    .code   = 0x0027,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_TxL0P_POWER_CYCLES_LL_ENTER",
    .desc   = "TBD (experimental)",
    .code   = 0x0028,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_TxL0P_POWER_CYCLES_M3_EXIT",
    .desc   = "TBD (experimental)",
    .code   = 0x0029,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_TxL0_POWER_CYCLES",
    .desc   = "Cycles in L0 (experimental)",
    .code   = 0x0026,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_TxL_ANY_FLITS",
    .desc   = "TBD",
    .code   = 0x004a,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_txl_any_flits),
    .umasks = spr_unc_upi_txl_any_flits,
  },
  { .name   = "UNC_UPI_TxL_BYPASSED",
    .desc   = "Transmitted Flit Buffer Bypassed (experimental)",
    .code   = 0x0041,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_TxL_FLITS",
    .desc   = "Flits transmitted",
    .code   = 0x0002,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_upi_txl_flits),
    .umasks = spr_unc_upi_txl_flits,
  },
  { .name   = "UNC_UPI_TxL_INSERTS",
    .desc   = "Transmitted Flit Buffer Allocations (experimental)",
    .code   = 0x0040,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_TxL_OCCUPANCY",
    .desc   = "Transmitted Flit Buffer Occupancy (experimental)",
    .code   = 0x0042,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_VNA_CREDIT_RETURN_BLOCKED_VN01",
    .desc   = "TBD (experimental)",
    .code   = 0x0045,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_VNA_CREDIT_RETURN_OCCUPANCY",
    .desc   = "VNA Credits Pending Return - Occupancy (experimental)",
    .code   = 0x0044,
    .modmsk = SPR_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
};
/* 36 events available */
