/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence.parser;

import org.apache.maven.doxia.module.confluence.parser.Block;
import org.apache.maven.doxia.module.confluence.parser.BlockParser;
import org.apache.maven.doxia.module.confluence.parser.ChildBlocksBuilder;
import org.apache.maven.doxia.module.confluence.parser.ParagraphBlock;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineSource;

public class ParagraphBlockParser
implements BlockParser {
    private BlockParser[] parsers;

    public ParagraphBlockParser(BlockParser[] parsers) {
        this.parsers = parsers;
    }

    @Override
    public boolean accept(String line, ByLineSource source) {
        return true;
    }

    public Block visit(String line, ByLineSource source, boolean generateParagraphTags) throws ParseException {
        if (generateParagraphTags) {
            return this.visit(line, source);
        }
        ChildBlocksBuilder builder = new ChildBlocksBuilder(line);
        return new ParagraphBlock(builder.getBlocks(), generateParagraphTags);
    }

    @Override
    public Block visit(String line, ByLineSource source) throws ParseException {
        ChildBlocksBuilder builder = new ChildBlocksBuilder(this.appendUntilEmptyLine(line, source));
        return new ParagraphBlock(builder.getBlocks());
    }

    private String appendUntilEmptyLine(String line, ByLineSource source) throws ParseException {
        StringBuilder text = new StringBuilder();
        while (line.trim().length() != 0) {
            boolean accepted = false;
            for (BlockParser parser : this.parsers) {
                if (!parser.accept(line, source)) continue;
                accepted = true;
                break;
            }
            if (accepted) {
                source.ungetLine();
                break;
            }
            if (text.length() == 0) {
                text.append(line.trim());
            } else {
                text.append(" ").append(line.trim());
            }
            if ((line = source.getNextLine()) != null) continue;
        }
        return text.toString();
    }
}

