/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser.core;

import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.FencedCodeBlockParser;
import com.vladsch.flexmark.parser.core.ListBlockParser;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Node;

public class ListItemParser
extends AbstractBlockParser {
    private final ListItem myBlock;
    private final ListOptions myOptions;
    private final ListBlockParser.ListData myListData;
    private final Parsing myParsing;
    private boolean myHadBlankLine = false;
    private boolean myIsEmpty = false;

    ListItemParser(ListOptions options, Parsing parsing, ListBlockParser.ListData listData) {
        this.myOptions = options;
        this.myListData = listData;
        this.myParsing = parsing;
        this.myBlock = this.myListData.isNumberedList ? new OrderedListItem() : new BulletListItem();
        this.myBlock.setOpeningMarker(this.myListData.listMarker);
        this.myBlock.setMarkerSuffix(this.myListData.markerSuffix);
    }

    int getContentColumn() {
        return this.myListData.markerColumn + this.myListData.listMarker.length() + (this.myOptions.isItemContentAfterSuffix() ? this.myListData.contentOffset : this.myListData.markerSuffixOffset);
    }

    int getContentIndent() {
        return this.myListData.markerIndent + this.myListData.listMarker.length() + (this.myOptions.isItemContentAfterSuffix() ? this.myListData.contentOffset : this.myListData.markerSuffixOffset);
    }

    int getMarkerContentIndent() {
        return this.myListData.markerIndent + this.myListData.listMarker.length() + 1;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        if (block instanceof FencedCodeBlock && state.getProperties().get(Parser.PARSER_EMULATION_PROFILE) == ParserEmulationProfile.GITHUB_DOC) {
            FencedCodeBlockParser parser = (FencedCodeBlockParser)blockParser;
            return this.myListData.markerIndent < parser.getFenceMarkerIndent();
        }
        return true;
    }

    @Override
    public boolean isPropagatingLastBlankLine(BlockParser lastMatchedBlockParser) {
        return this.myBlock.getFirstChild() != null || this == lastMatchedBlockParser;
    }

    @Override
    public Block getBlock() {
        return this.myBlock;
    }

    @Override
    public void closeBlock(ParserState state) {
        this.myBlock.setCharsFromContent();
    }

    private BlockContinue continueAtColumn(int newColumn) {
        if (this.myHadBlankLine) {
            this.myBlock.setContainsBlankLine(true);
        }
        this.myIsEmpty = false;
        return BlockContinue.atColumn(newColumn);
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (state.isBlank()) {
            Node firstChild = this.myBlock.getFirstChild();
            boolean bl = this.myIsEmpty = firstChild == null;
            if (this.myIsEmpty || firstChild.getNext() == null) {
                this.myBlock.setHadBlankAfterItemParagraph(true);
            }
            this.myHadBlankLine = true;
            return BlockContinue.atIndex(state.getNextNonSpaceIndex());
        }
        assert (this.myBlock.getParent() instanceof ListBlock);
        ListBlockParser listBlockParser = (ListBlockParser)state.getActiveBlockParser(this.myBlock.getParent());
        ParserEmulationProfile emulationProfile = this.myOptions.getParserEmulationProfile();
        ParserEmulationProfile emulationFamily = emulationProfile.family;
        int contentIndent = this.getContentIndent();
        if (emulationFamily == ParserEmulationProfile.COMMONMARK) {
            int currentIndent = state.getIndent();
            int newColumn = state.getColumn() + contentIndent;
            if (currentIndent >= contentIndent + this.myOptions.getCodeIndent()) {
                listBlockParser.setItemHandledLine(state.getLine());
                return this.continueAtColumn(newColumn);
            }
            ListBlockParser.ListData listData = ListBlockParser.parseListMarker(this.myOptions, this.myOptions.getCodeIndent(), state);
            if (currentIndent >= contentIndent) {
                if (listData != null) {
                    boolean inParagraphListItem;
                    BlockParser matched = state.getActiveBlockParser();
                    boolean inParagraph = matched.isParagraphParser();
                    boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
                    if (!(!inParagraphListItem || this.myOptions.canInterrupt(listData.listBlock, listData.isEmpty, true) && this.myOptions.canStartSubList(listData.listBlock, listData.isEmpty))) {
                        listBlockParser.setItemHandledLineSkipActive(state.getLine());
                        return this.continueAtColumn(newColumn);
                    }
                    listBlockParser.setItemHandledNewListLine(state.getLine());
                    return this.continueAtColumn(newColumn);
                }
                if (this.myIsEmpty) {
                    listBlockParser.setItemHandledLine(state.getLine());
                    return BlockContinue.none();
                }
                listBlockParser.setItemHandledLine(state.getLine());
                return this.continueAtColumn(newColumn);
            }
            if (listData != null) {
                boolean overrideSubList;
                if (!this.myHadBlankLine && !this.myOptions.canInterrupt(listData.listBlock, listData.isEmpty, true)) {
                    listBlockParser.setItemHandledLine(state.getLine());
                    return this.continueAtColumn(state.getColumn() + currentIndent);
                }
                boolean bl = overrideSubList = this.myOptions.isItemTypeMismatchToNewList() && this.myOptions.isItemTypeMismatchToSubList() && this.myHadBlankLine;
                if (!overrideSubList && this.myOptions.startSubList(listBlockParser.getBlock(), listData.listBlock)) {
                    listBlockParser.setItemHandledNewListLine(state.getLine());
                    return this.continueAtColumn(state.getColumn() + currentIndent);
                }
                if (this.myOptions.startNewList(listBlockParser.getBlock(), listData.listBlock)) {
                    listBlockParser.setItemHandledNewListLine(state.getLine());
                    return BlockContinue.none();
                }
                listBlockParser.setItemHandledNewItemLine(state.getLine());
                return BlockContinue.none();
            }
        } else {
            int itemIndent = this.myOptions.getItemIndent();
            if (emulationFamily == ParserEmulationProfile.FIXED_INDENT) {
                int currentIndent = state.getIndent();
                int newColumn = state.getColumn() + itemIndent;
                if (currentIndent >= this.myOptions.getCodeIndent()) {
                    listBlockParser.setItemHandledLine(state.getLine());
                    return this.continueAtColumn(newColumn);
                }
                ListBlockParser.ListData listData = ListBlockParser.parseListMarker(this.myOptions, -1, state);
                if (currentIndent >= itemIndent) {
                    if (listData != null) {
                        boolean inParagraphListItem;
                        BlockParser matched = state.getActiveBlockParser();
                        boolean inParagraph = matched.isParagraphParser();
                        boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
                        if (!(!inParagraphListItem || this.myOptions.canInterrupt(listData.listBlock, listData.isEmpty, true) && this.myOptions.canStartSubList(listData.listBlock, listData.isEmpty))) {
                            listBlockParser.setItemHandledLineSkipActive(state.getLine());
                            return this.continueAtColumn(state.getColumn() + currentIndent);
                        }
                        listBlockParser.setItemHandledNewListLine(state.getLine());
                        return this.continueAtColumn(newColumn);
                    }
                    if (this.myIsEmpty) {
                        listBlockParser.setItemHandledLine(state.getLine());
                        return BlockContinue.none();
                    }
                    listBlockParser.setItemHandledLine(state.getLine());
                    return this.continueAtColumn(newColumn);
                }
                if (listData != null) {
                    boolean overrideSubList;
                    if (!this.myHadBlankLine && !this.myOptions.canInterrupt(listData.listBlock, listData.isEmpty, true)) {
                        listBlockParser.setItemHandledLine(state.getLine());
                        return this.continueAtColumn(state.getColumn() + currentIndent);
                    }
                    boolean bl = overrideSubList = this.myOptions.isItemTypeMismatchToNewList() && this.myOptions.isItemTypeMismatchToSubList() && this.myHadBlankLine;
                    if (!overrideSubList && this.myOptions.startSubList(listBlockParser.getBlock(), listData.listBlock)) {
                        listBlockParser.setItemHandledNewListLine(state.getLine());
                        return this.continueAtColumn(state.getColumn() + currentIndent);
                    }
                    if (this.myOptions.startNewList(listBlockParser.getBlock(), listData.listBlock)) {
                        listBlockParser.setItemHandledNewListLine(state.getLine());
                        return BlockContinue.none();
                    }
                    listBlockParser.setItemHandledNewItemLine(state.getLine());
                    return BlockContinue.none();
                }
            } else {
                int markerIndent = listBlockParser.getListData().markerIndent;
                int markerIndex = listBlockParser.getListData().markerIndex;
                if (emulationFamily == ParserEmulationProfile.KRAMDOWN) {
                    int currentIndent = state.getIndent();
                    int listIndent = markerIndent;
                    int newColumn = state.getColumn() + contentIndent;
                    ListBlockParser.ListData listData = ListBlockParser.parseListMarker(this.myOptions, -1, state);
                    if (currentIndent >= contentIndent) {
                        if (listData != null) {
                            boolean inParagraphListItem;
                            BlockParser matched = state.getActiveBlockParser();
                            boolean inParagraph = matched.isParagraphParser();
                            boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
                            if (!(!inParagraphListItem || this.myOptions.canInterrupt(listData.listBlock, listData.isEmpty, true) && this.myOptions.canStartSubList(listData.listBlock, listData.isEmpty))) {
                                listBlockParser.setItemHandledLineSkipActive(state.getLine());
                                return this.continueAtColumn(newColumn);
                            }
                            listBlockParser.setItemHandledNewListLine(state.getLine());
                            return this.continueAtColumn(newColumn);
                        }
                        if (this.myIsEmpty) {
                            listBlockParser.setItemHandledLine(state.getLine());
                            return BlockContinue.none();
                        }
                        listBlockParser.setItemHandledLine(state.getLine());
                        return this.continueAtColumn(newColumn);
                    }
                    if (currentIndent >= listIndent + itemIndent) {
                        if (this.myHadBlankLine) {
                            if (this.myBlock.isHadBlankAfterItemParagraph()) {
                                this.myBlock.setLoose(true);
                            }
                            listBlockParser.setItemHandledLineSkipActive(state.getLine());
                            return BlockContinue.none();
                        }
                        listBlockParser.setItemHandledLineSkipActive(state.getLine());
                        return this.continueAtColumn(state.getColumn() + currentIndent);
                    }
                    if (listData != null && currentIndent >= listIndent) {
                        boolean overrideSubList;
                        boolean bl = overrideSubList = this.myOptions.isItemTypeMismatchToNewList() && this.myOptions.isItemTypeMismatchToSubList() && this.myHadBlankLine;
                        if (!overrideSubList && this.myOptions.startSubList(listBlockParser.getBlock(), listData.listBlock)) {
                            listBlockParser.setItemHandledNewListLine(state.getLine());
                            return this.continueAtColumn(state.getColumn() + currentIndent);
                        }
                        if (this.myOptions.startNewList(listBlockParser.getBlock(), listData.listBlock)) {
                            listBlockParser.setItemHandledNewListLine(state.getLine());
                            return BlockContinue.none();
                        }
                        listBlockParser.setItemHandledNewItemLine(state.getLine());
                        return BlockContinue.none();
                    }
                } else if (emulationProfile == ParserEmulationProfile.GITHUB_DOC) {
                    int currentIndent = state.getIndent();
                    int currentIndex = state.getIndex() + currentIndent;
                    int listIndent = markerIndent;
                    int listIndex = markerIndent;
                    int contentIndentRemoval = Utils.maxLimit((int)currentIndent, (int[])new int[]{contentIndent, listIndent + 4});
                    if (currentIndent >= this.myOptions.getCodeIndent()) {
                        listBlockParser.setItemHandledLine(state.getLine());
                        return this.continueAtColumn(state.getColumn() + Utils.maxLimit((int)contentIndent, (int[])new int[]{itemIndent}));
                    }
                    ListBlockParser.ListData listData = ListBlockParser.parseListMarker(this.myOptions, -1, state);
                    if (currentIndent > itemIndent) {
                        if (listData != null) {
                            boolean inParagraphListItem;
                            BlockParser matched = state.getActiveBlockParser();
                            boolean inParagraph = matched.isParagraphParser();
                            boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
                            if (!(!inParagraphListItem || this.myOptions.canInterrupt(listData.listBlock, listData.isEmpty, true) && this.myOptions.canStartSubList(listData.listBlock, listData.isEmpty))) {
                                listBlockParser.setItemHandledLineSkipActive(state.getLine());
                                return this.continueAtColumn(state.getColumn() + currentIndent);
                            }
                            listBlockParser.setItemHandledNewListLine(state.getLine());
                            return this.continueAtColumn(state.getColumn() + contentIndentRemoval);
                        }
                        listBlockParser.setItemHandledLine(state.getLine());
                        return this.continueAtColumn(state.getColumn() + itemIndent);
                    }
                    if (currentIndent > listIndent) {
                        if (listData != null) {
                            boolean inParagraphListItem;
                            BlockParser matched = state.getActiveBlockParser();
                            boolean inParagraph = matched.isParagraphParser();
                            boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
                            if (!(!inParagraphListItem || this.myOptions.canInterrupt(listData.listBlock, listData.isEmpty, true) && this.myOptions.canStartSubList(listData.listBlock, listData.isEmpty))) {
                                listBlockParser.setItemHandledLineSkipActive(state.getLine());
                                return this.continueAtColumn(state.getColumn() + currentIndent);
                            }
                            listBlockParser.setItemHandledNewListLine(state.getLine());
                            return this.continueAtColumn(state.getColumn() + contentIndentRemoval);
                        }
                        listBlockParser.setItemHandledLine(state.getLine());
                        return this.continueAtColumn(state.getColumn() + contentIndentRemoval);
                    }
                    if (listData != null) {
                        boolean inParagraphListItem;
                        boolean overrideSubList;
                        boolean bl = overrideSubList = this.myOptions.isItemTypeMismatchToNewList() && this.myOptions.isItemTypeMismatchToSubList() && this.myHadBlankLine;
                        if (!overrideSubList && this.myOptions.startSubList(listBlockParser.getBlock(), listData.listBlock)) {
                            listBlockParser.setItemHandledNewListLine(state.getLine());
                            return this.continueAtColumn(state.getColumn() + contentIndentRemoval);
                        }
                        if (this.myOptions.startNewList(listBlockParser.getBlock(), listData.listBlock)) {
                            listBlockParser.setItemHandledNewListLine(state.getLine());
                            return BlockContinue.none();
                        }
                        BlockParser matched = state.getActiveBlockParser();
                        boolean inParagraph = matched.isParagraphParser();
                        boolean bl2 = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
                        if (!(!inParagraphListItem || this.myOptions.canInterrupt(listData.listBlock, listData.isEmpty, true) && this.myOptions.canStartSubList(listData.listBlock, listData.isEmpty))) {
                            listBlockParser.setItemHandledLineSkipActive(state.getLine());
                            return this.continueAtColumn(state.getColumn() + currentIndent);
                        }
                        listBlockParser.setItemHandledNewItemLine(state.getLine());
                        return BlockContinue.none();
                    }
                    if (!this.myHadBlankLine || state.getActiveBlockParser() instanceof FencedCodeBlockParser) {
                        listBlockParser.setItemHandledLine(state.getLine());
                        return this.continueAtColumn(state.getColumn() + currentIndent);
                    }
                } else if (emulationFamily == ParserEmulationProfile.MARKDOWN) {
                    int currentIndent = state.getIndent();
                    if (currentIndent >= this.myOptions.getCodeIndent()) {
                        listBlockParser.setItemHandledLine(state.getLine());
                        return this.continueAtColumn(state.getColumn() + itemIndent);
                    }
                    ListBlockParser.ListData listData = ListBlockParser.parseListMarker(this.myOptions, -1, state);
                    if (currentIndent > itemIndent) {
                        if (listData != null) {
                            boolean inParagraphListItem;
                            BlockParser matched = state.getActiveBlockParser();
                            boolean inParagraph = matched.isParagraphParser();
                            boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
                            if (!(!inParagraphListItem || this.myOptions.canInterrupt(listData.listBlock, listData.isEmpty, true) && this.myOptions.canStartSubList(listData.listBlock, listData.isEmpty))) {
                                listBlockParser.setItemHandledLineSkipActive(state.getLine());
                                return this.continueAtColumn(state.getColumn() + currentIndent);
                            }
                            listBlockParser.setItemHandledNewListLine(state.getLine());
                            return this.continueAtColumn(state.getColumn() + itemIndent);
                        }
                        listBlockParser.setItemHandledLine(state.getLine());
                        return this.continueAtColumn(state.getColumn() + itemIndent);
                    }
                    int listIndent = markerIndent;
                    if (currentIndent > listIndent) {
                        if (listData != null) {
                            boolean inParagraphListItem;
                            BlockParser matched = state.getActiveBlockParser();
                            boolean inParagraph = matched.isParagraphParser();
                            boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
                            if (!(!inParagraphListItem || this.myOptions.canInterrupt(listData.listBlock, listData.isEmpty, true) && this.myOptions.canStartSubList(listData.listBlock, listData.isEmpty))) {
                                listBlockParser.setItemHandledLineSkipActive(state.getLine());
                                return this.continueAtColumn(state.getColumn() + currentIndent);
                            }
                            listBlockParser.setItemHandledNewListLine(state.getLine());
                            return this.continueAtColumn(state.getColumn() + currentIndent);
                        }
                        listBlockParser.setItemHandledLine(state.getLine());
                        return this.continueAtColumn(state.getColumn() + currentIndent);
                    }
                    if (listData != null) {
                        boolean inParagraphListItem;
                        boolean overrideSubList;
                        boolean bl = overrideSubList = this.myOptions.isItemTypeMismatchToNewList() && this.myOptions.isItemTypeMismatchToSubList() && this.myHadBlankLine;
                        if (!overrideSubList && this.myOptions.startSubList(listBlockParser.getBlock(), listData.listBlock)) {
                            listBlockParser.setItemHandledNewListLine(state.getLine());
                            return this.continueAtColumn(state.getColumn() + currentIndent);
                        }
                        if (this.myOptions.startNewList(listBlockParser.getBlock(), listData.listBlock)) {
                            listBlockParser.setItemHandledNewListLine(state.getLine());
                            return BlockContinue.none();
                        }
                        BlockParser matched = state.getActiveBlockParser();
                        boolean inParagraph = matched.isParagraphParser();
                        boolean bl3 = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
                        if (!(!inParagraphListItem || this.myOptions.canInterrupt(listData.listBlock, listData.isEmpty, true) && this.myOptions.canStartSubList(listData.listBlock, listData.isEmpty))) {
                            listBlockParser.setItemHandledLineSkipActive(state.getLine());
                            return this.continueAtColumn(state.getColumn() + currentIndent);
                        }
                        listBlockParser.setItemHandledNewItemLine(state.getLine());
                        return BlockContinue.none();
                    }
                }
            }
        }
        return BlockContinue.none();
    }
}

