/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;

public abstract class ResolvePathsRequest<T> {
    private Path jdkHome;
    private Path mainModuleDescriptor;
    private Collection<T> pathElements;
    private Collection<String> additionalModules;

    private ResolvePathsRequest() {
    }

    @Deprecated
    public static ResolvePathsRequest<File> withFiles(Collection<File> files) {
        return ResolvePathsRequest.ofFiles(files);
    }

    public static ResolvePathsRequest<File> ofFiles(Collection<File> files) {
        ResolvePathsRequest<File> request = new ResolvePathsRequest<File>(){

            @Override
            protected Path toPath(File t) {
                return t.toPath();
            }
        };
        request.pathElements = files;
        return request;
    }

    @Deprecated
    public static ResolvePathsRequest<Path> withPaths(Collection<Path> paths) {
        return ResolvePathsRequest.ofPaths(paths);
    }

    public static ResolvePathsRequest<Path> ofPaths(Collection<Path> paths) {
        ResolvePathsRequest<Path> request = new ResolvePathsRequest<Path>(){

            @Override
            protected Path toPath(Path t) {
                return t;
            }
        };
        request.pathElements = paths;
        return request;
    }

    @Deprecated
    public static ResolvePathsRequest<String> withStrings(Collection<String> strings) {
        return ResolvePathsRequest.ofStrings(strings);
    }

    public static ResolvePathsRequest<String> ofStrings(Collection<String> strings) {
        ResolvePathsRequest<String> request = new ResolvePathsRequest<String>(){

            @Override
            protected Path toPath(String t) {
                return Paths.get(t, new String[0]);
            }
        };
        request.pathElements = strings;
        return request;
    }

    protected abstract Path toPath(T var1);

    final ResolvePathsResult<T> createResult() {
        return new ResolvePathsResult();
    }

    public Path getMainModuleDescriptor() {
        return this.mainModuleDescriptor;
    }

    public ResolvePathsRequest<T> setMainModuleDescriptor(T mainModuleDescriptor) {
        this.mainModuleDescriptor = this.toPath(mainModuleDescriptor);
        return this;
    }

    public Collection<T> getPathElements() {
        return this.pathElements;
    }

    public ResolvePathsRequest<T> setJdkHome(T jdkHome) {
        this.jdkHome = this.toPath(jdkHome);
        return this;
    }

    public Path getJdkHome() {
        return this.jdkHome;
    }

    public ResolvePathsRequest<T> setAdditionalModules(Collection<String> additionalModules) {
        this.additionalModules = additionalModules;
        return this;
    }

    public Collection<String> getAdditionalModules() {
        if (this.additionalModules == null) {
            this.additionalModules = Collections.emptyList();
        }
        return this.additionalModules;
    }
}

