/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.impl.DelegatingOutputStream;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.impl.TVMCI;
import com.oracle.truffle.api.impl.TruffleJDKServices;
import com.oracle.truffle.api.impl.TruffleLocator;
import com.oracle.truffle.api.io.TruffleProcessBuilder;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.io.ProcessHandler;

public abstract class Accessor {
    @CompilerDirectives.CompilationFinal
    private static volatile TVMCI tvmci;

    protected void initializeNativeImageTruffleLocator() {
        TruffleLocator.initializeNativeImageTruffleLocator();
    }

    protected ThreadLocal<Object> createFastThreadLocal() {
        return Accessor.getTVMCI().createFastThreadLocal();
    }

    protected IndirectCallNode createUncachedIndirectCall() {
        return Accessor.getTVMCI().createUncachedIndirectCall();
    }

    protected <T extends Node> BlockNode<T> createBlockNode(T[] elements, BlockNode.ElementExecutor<T> executor) {
        return Accessor.getTVMCI().createBlockNode((Node[])elements, executor);
    }

    protected void reloadEngineOptions(Object runtimeData, OptionValues optionValues) {
        Accessor.getTVMCI().reloadEngineOptions(runtimeData, optionValues);
    }

    protected void onEngineClosed(Object runtimeData) {
        Accessor.getTVMCI().onEngineClosed(runtimeData);
    }

    protected OutputStream getConfiguredLogStream() {
        return Accessor.getTVMCI().getConfiguredLogStream();
    }

    protected Accessor() {
        switch (this.getClass().getName()) {
            case "com.oracle.truffle.api.LanguageAccessor": 
            case "com.oracle.truffle.api.nodes.NodeAccessor": 
            case "com.oracle.truffle.api.instrumentation.InstrumentAccessor": 
            case "com.oracle.truffle.api.source.SourceAccessor": 
            case "com.oracle.truffle.api.interop.InteropAccessor": 
            case "com.oracle.truffle.api.io.IOAccessor": 
            case "com.oracle.truffle.api.frame.FrameAccessor": 
            case "com.oracle.truffle.polyglot.EngineAccessor": 
            case "com.oracle.truffle.api.utilities.JSONHelper.DumpAccessor": {
                break;
            }
            case "com.oracle.truffle.api.debug.Debugger$AccessorDebug": 
            case "com.oracle.truffle.tck.instrumentation.VerifierInstrument$TruffleTCKAccessor": 
            case "com.oracle.truffle.api.instrumentation.test.AbstractInstrumentationTest$TestAccessor": 
            case "com.oracle.truffle.api.test.polyglot.FileSystemsTest$TestAPIAccessor": 
            case "com.oracle.truffle.api.impl.TVMCIAccessor": 
            case "org.graalvm.compiler.truffle.runtime.CompilerRuntimeAccessor": 
            case "org.graalvm.compiler.truffle.runtime.debug.CompilerDebugAccessor": 
            case "com.oracle.truffle.api.library.LibraryAccessor": {
                break;
            }
            default: {
                throw new IllegalStateException(this.getClass().getName());
            }
        }
    }

    public final NodeSupport nodeSupport() {
        return Constants.NODES;
    }

    public final LanguageSupport languageSupport() {
        return Constants.LANGUAGE;
    }

    public final EngineSupport engineSupport() {
        return Constants.ENGINE;
    }

    public final InstrumentSupport instrumentSupport() {
        return Constants.INSTRUMENT;
    }

    public final InteropSupport interopSupport() {
        return Constants.INTEROP;
    }

    public final SourceSupport sourceSupport() {
        return Constants.SOURCE;
    }

    public final FrameSupport framesSupport() {
        return Constants.FRAMES;
    }

    public final IOSupport ioSupport() {
        return Constants.IO;
    }

    public final JDKSupport jdkSupport() {
        return Constants.JDKSERVICES;
    }

    public static void main(String ... args) {
        throw new IllegalStateException();
    }

    private static TVMCI getTVMCI() {
        if (ImageInfo.inImageRuntimeCode()) {
            return tvmci;
        }
        TVMCI result = tvmci;
        if (result == null) {
            tvmci = result = Truffle.getRuntime().getCapability(TVMCI.class);
        }
        return result;
    }

    protected OptionDescriptors getCompilerOptions() {
        TVMCI support = Accessor.getTVMCI();
        if (support == null) {
            return OptionDescriptors.EMPTY;
        }
        return support.getCompilerOptionDescriptors();
    }

    protected CastUnsafe getCastUnsafe() {
        return Accessor.getTVMCI().getCastUnsafe();
    }

    protected CallInlined getCallInlined() {
        return Accessor.getTVMCI().getCallInlined();
    }

    protected CallProfiled getCallProfiled() {
        return Accessor.getTVMCI().getCallProfiled();
    }

    protected boolean isGuestCallStackElement(StackTraceElement element) {
        TVMCI support = Accessor.getTVMCI();
        if (support == null) {
            return false;
        }
        return support.isGuestCallStackFrame(element);
    }

    protected void initializeProfile(CallTarget target, Class<?>[] argumentTypes) {
        Accessor.getTVMCI().initializeProfile(target, argumentTypes);
    }

    protected void onLoopCount(Node source, int iterations) {
        TVMCI support = Accessor.getTVMCI();
        if (support != null) {
            support.onLoopCount(source, iterations);
        }
    }

    public static abstract class CallProfiled {
        public abstract Object call(CallTarget var1, Object ... var2);
    }

    public static abstract class CastUnsafe {
        public abstract Object[] castArrayFixedLength(Object[] var1, int var2);

        public abstract <T> T unsafeCast(Object var1, Class<T> var2, boolean var3, boolean var4, boolean var5);
    }

    public static abstract class CallInlined {
        public abstract Object call(Node var1, CallTarget var2, Object ... var3);
    }

    private static class Constants {
        private static final LanguageSupport LANGUAGE = (LanguageSupport)Constants.loadSupport("com.oracle.truffle.api.LanguageAccessor$LanguageImpl");
        private static final NodeSupport NODES = (NodeSupport)Constants.loadSupport("com.oracle.truffle.api.nodes.NodeAccessor$AccessNodes");
        private static final InstrumentSupport INSTRUMENT = (InstrumentSupport)Constants.loadSupport("com.oracle.truffle.api.instrumentation.InstrumentAccessor$InstrumentImpl");
        private static final SourceSupport SOURCE = (SourceSupport)Constants.loadSupport("com.oracle.truffle.api.source.SourceAccessor$SourceSupportImpl");
        private static final InteropSupport INTEROP = (InteropSupport)Constants.loadSupport("com.oracle.truffle.api.interop.InteropAccessor$InteropImpl");
        private static final IOSupport IO = (IOSupport)Constants.loadSupport("com.oracle.truffle.api.io.IOAccessor$IOSupportImpl");
        private static final FrameSupport FRAMES = (FrameSupport)Constants.loadSupport("com.oracle.truffle.api.frame.FrameAccessor$FramesImpl");
        private static final EngineSupport ENGINE = (EngineSupport)Constants.loadSupport("com.oracle.truffle.polyglot.EngineAccessor$EngineImpl");
        private static final JDKSupport JDKSERVICES = new JDKSupport();

        private Constants() {
        }

        private static <T> T loadSupport(String className) {
            try {
                Class<?> klass = Class.forName(className, true, Accessor.class.getClassLoader());
                Constructor<?> constructor = klass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (T)constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static final class JDKSupport {
        private JDKSupport() {
        }

        public void exportTo(ClassLoader loader, String moduleName) {
            TruffleJDKServices.exportTo(loader, moduleName);
        }

        public void exportTo(Class<?> client) {
            TruffleJDKServices.exportTo(client);
        }

        public <Service> List<Iterable<Service>> getTruffleRuntimeLoaders(Class<Service> serviceClass) {
            return TruffleJDKServices.getTruffleRuntimeLoaders(serviceClass);
        }

        public <S> void addUses(Class<S> service) {
            TruffleJDKServices.addUses(service);
        }

        public Object getUnnamedModule(ClassLoader classLoader) {
            return TruffleJDKServices.getUnnamedModule(classLoader);
        }

        public boolean verifyModuleVisibility(Object lookupModule, Class<?> memberClass) {
            return TruffleJDKServices.verifyModuleVisibility(lookupModule, memberClass);
        }

        public boolean isNonTruffleClass(Class<?> clazz) {
            return TruffleJDKServices.isNonTruffleClass(clazz);
        }
    }

    public static abstract class IOSupport {
        public abstract TruffleProcessBuilder createProcessBuilder(Object var1, FileSystem var2, List<String> var3);
    }

    public static abstract class FrameSupport {
        protected abstract void markMaterializeCalled(FrameDescriptor var1);

        protected abstract boolean getMaterializeCalled(FrameDescriptor var1);
    }

    public static abstract class InstrumentSupport {
        public abstract void initializeInstrument(Object var1, Object var2, String var3, Supplier<? extends Object> var4);

        public abstract void createInstrument(Object var1, Object var2, String[] var3, OptionValues var4);

        public abstract void finalizeInstrument(Object var1, Object var2);

        public abstract void disposeInstrument(Object var1, Object var2, boolean var3);

        public abstract <T> T getInstrumentationHandlerService(Object var1, Object var2, Class<T> var3);

        public abstract Object createInstrumentationHandler(Object var1, DispatchOutputStream var2, DispatchOutputStream var3, InputStream var4, MessageTransport var5);

        public abstract void collectEnvServices(Set<Object> var1, Object var2, TruffleLanguage<?> var3);

        public abstract void onFirstExecution(RootNode var1);

        public abstract void onLoad(RootNode var1);

        public abstract Iterable<?> findTopScopes(TruffleLanguage.Env var1);

        public final DispatchOutputStream createDispatchOutput(OutputStream out) {
            if (out instanceof DispatchOutputStream) {
                return (DispatchOutputStream)out;
            }
            return new DispatchOutputStream(out);
        }

        public final DelegatingOutputStream createDelegatingOutput(OutputStream out, DispatchOutputStream delegate) {
            return new DelegatingOutputStream(out, delegate);
        }

        public final OutputStream getOut(DispatchOutputStream out) {
            return out.getOut();
        }

        public abstract OptionDescriptors describeOptions(Object var1, Object var2, String var3);

        public abstract Object getEngineInstrumenter(Object var1);

        public abstract void onNodeInserted(RootNode var1, Node var2);

        public abstract boolean hasContextBindings(Object var1);

        public abstract void notifyContextCreated(Object var1, TruffleContext var2);

        public abstract void notifyContextClosed(Object var1, TruffleContext var2);

        public abstract void notifyLanguageContextCreated(Object var1, TruffleContext var2, LanguageInfo var3);

        public abstract void notifyLanguageContextInitialized(Object var1, TruffleContext var2, LanguageInfo var3);

        public abstract void notifyLanguageContextFinalized(Object var1, TruffleContext var2, LanguageInfo var3);

        public abstract void notifyLanguageContextDisposed(Object var1, TruffleContext var2, LanguageInfo var3);

        public abstract void notifyThreadStarted(Object var1, TruffleContext var2, Thread var3);

        public abstract void notifyThreadFinished(Object var1, TruffleContext var2, Thread var3);

        public abstract org.graalvm.polyglot.SourceSection createSourceSection(Object var1, org.graalvm.polyglot.Source var2, SourceSection var3);

        public abstract void patchInstrumentationHandler(Object var1, DispatchOutputStream var2, DispatchOutputStream var3, InputStream var4);

        public abstract boolean isInputValueSlotIdentifier(Object var1);

        public abstract boolean isInstrumentable(Node var1);
    }

    public static abstract class LanguageSupport {
        public abstract void initializeLanguage(TruffleLanguage<?> var1, LanguageInfo var2, Object var3, Object var4);

        public abstract TruffleLanguage.Env createEnv(Object var1, TruffleLanguage<?> var2, OutputStream var3, OutputStream var4, InputStream var5, Map<String, Object> var6, OptionValues var7, String[] var8, FileSystem var9, FileSystem var10, Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> var11);

        public abstract boolean areOptionsCompatible(TruffleLanguage<?> var1, OptionValues var2, OptionValues var3);

        public abstract Object createEnvContext(TruffleLanguage.Env var1, List<Object> var2);

        public abstract TruffleContext createTruffleContext(Object var1);

        public abstract void postInitEnv(TruffleLanguage.Env var1);

        public abstract Object evalInContext(Source var1, Node var2, MaterializedFrame var3);

        public abstract Object findExportedSymbol(TruffleLanguage.Env var1, String var2, boolean var3);

        public abstract void dispose(TruffleLanguage.Env var1);

        public abstract LanguageInfo getLanguageInfo(TruffleLanguage.Env var1);

        public abstract LanguageInfo getLanguageInfo(TruffleLanguage<?> var1);

        public abstract Object getPolyglotLanguageInstance(TruffleLanguage<?> var1);

        public abstract CallTarget parse(TruffleLanguage.Env var1, Source var2, Node var3, String ... var4);

        public abstract ExecutableNode parseInline(TruffleLanguage.Env var1, Source var2, Node var3, MaterializedFrame var4);

        public abstract boolean isVisible(TruffleLanguage.Env var1, Object var2);

        public abstract String legacyToString(TruffleLanguage.Env var1, Object var2);

        public abstract <C> String legacyToString(TruffleLanguage<C> var1, C var2, Object var3);

        public abstract Object legacyFindMetaObject(TruffleLanguage.Env var1, Object var2);

        public abstract <C> Object legacyFindMetaObject(TruffleLanguage<C> var1, C var2, Object var3);

        public abstract SourceSection legacyFindSourceLocation(TruffleLanguage.Env var1, Object var2);

        public abstract <C> SourceSection legacyFindSourceLocation(TruffleLanguage<C> var1, C var2, Object var3);

        public abstract boolean isObjectOfLanguage(TruffleLanguage.Env var1, Object var2);

        public abstract Object getContext(TruffleLanguage.Env var1);

        public abstract TruffleLanguage<?> getSPI(TruffleLanguage.Env var1);

        public abstract InstrumentInfo createInstrument(Object var1, String var2, String var3, String var4);

        public abstract Object getPolyglotInstrument(InstrumentInfo var1);

        public abstract boolean isContextInitialized(TruffleLanguage.Env var1);

        public abstract OptionDescriptors describeOptions(TruffleLanguage<?> var1, String var2);

        public abstract void onThrowable(Node var1, RootCallTarget var2, Throwable var3, Frame var4);

        public abstract boolean isThreadAccessAllowed(TruffleLanguage.Env var1, Thread var2, boolean var3);

        public abstract void initializeThread(TruffleLanguage.Env var1, Thread var2);

        public abstract void initializeMultiThreading(TruffleLanguage.Env var1);

        public abstract void disposeThread(TruffleLanguage.Env var1, Thread var2);

        public abstract void finalizeContext(TruffleLanguage.Env var1);

        public abstract Iterable<Scope> findLocalScopes(TruffleLanguage.Env var1, Node var2, Frame var3);

        public abstract Iterable<Scope> findTopScopes(TruffleLanguage.Env var1);

        public abstract TruffleLanguage.Env patchEnvContext(TruffleLanguage.Env var1, OutputStream var2, OutputStream var3, InputStream var4, Map<String, Object> var5, OptionValues var6, String[] var7, FileSystem var8, FileSystem var9, Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> var10);

        public abstract boolean initializeMultiContext(TruffleLanguage<?> var1);

        public abstract boolean isTruffleStackTrace(Throwable var1);

        public abstract StackTraceElement[] getInternalStackTraceElements(Throwable var1);

        public abstract void materializeHostFrames(Throwable var1);

        public abstract void configureLoggers(Object var1, Map<String, Level> var2, Object ... var3);

        public abstract Object getDefaultLoggers();

        public abstract Object createEngineLoggers(Object var1, Map<String, Level> var2);

        public abstract void closeEngineLoggers(Object var1);

        public abstract TruffleLogger getLogger(String var1, String var2, Object var3);

        public abstract TruffleLanguage<?> getLanguage(TruffleLanguage.Env var1);

        public abstract Object createFileSystemContext(FileSystem var1, Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> var2);

        public abstract Object getCurrentFileSystemContext();

        public abstract String getMimeType(TruffleFile var1, Set<String> var2) throws IOException;

        public abstract Charset getEncoding(TruffleFile var1, String var2) throws IOException;

        public abstract TruffleFile getTruffleFile(String var1, Object var2);

        public abstract TruffleFile getTruffleFile(URI var1, Object var2);

        public abstract boolean hasAllAccess(Object var1);

        public abstract TruffleFile getTruffleFile(String var1, FileSystem var2, Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> var3);

        public abstract TruffleFile getTruffleFile(URI var1, FileSystem var2, Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> var3);

        public abstract SecurityException throwSecurityException(String var1);

        public abstract FileSystem getFileSystem(TruffleFile var1);

        public abstract Path getPath(TruffleFile var1);

        public abstract Object getScopedView(TruffleLanguage.Env var1, Node var2, Frame var3, Object var4);

        public abstract Object getLanguageView(TruffleLanguage.Env var1, Object var2);
    }

    public static abstract class EngineSupport {
        public abstract <T> Iterable<T> loadServices(Class<T> var1);

        public abstract Object getInstrumentationHandler(Object var1);

        public abstract void exportSymbol(Object var1, String var2, Object var3);

        public abstract Map<String, ? extends Object> getExportedSymbols();

        public abstract Object getPolyglotBindingsObject();

        public abstract Object importSymbol(Object var1, TruffleLanguage.Env var2, String var3);

        public abstract boolean isMimeTypeSupported(Object var1, String var2);

        public abstract boolean isEvalRoot(RootNode var1);

        public abstract boolean isMultiThreaded(Object var1);

        public final void attachOutputConsumer(DispatchOutputStream dos, OutputStream out) {
            dos.attach(out);
        }

        public final void detachOutputConsumer(DispatchOutputStream dos, OutputStream out) {
            dos.detach(out);
        }

        public abstract Object getCurrentPolyglotEngine();

        public abstract CallTarget parseForLanguage(Object var1, Source var2, String[] var3, boolean var4);

        public abstract TruffleLanguage.Env getEnvForInstrument(String var1, String var2);

        public abstract TruffleLanguage.Env getEnvForInstrument(LanguageInfo var1);

        public abstract TruffleLanguage.Env getLegacyLanguageEnv(Object var1, boolean var2);

        public abstract TruffleLanguage.ContextReference<Object> getCurrentContextReference(Object var1);

        public abstract boolean isDisposed(Object var1);

        public abstract Map<String, LanguageInfo> getInternalLanguages(Object var1);

        public abstract Map<String, LanguageInfo> getPublicLanguages(Object var1);

        public abstract Map<String, InstrumentInfo> getInstruments(Object var1);

        public abstract org.graalvm.polyglot.SourceSection createSourceSection(Object var1, org.graalvm.polyglot.Source var2, SourceSection var3);

        public abstract <T> T lookup(InstrumentInfo var1, Class<T> var2);

        public abstract <S> S lookup(LanguageInfo var1, Class<S> var2);

        public abstract <T extends TruffleLanguage<?>> T getCurrentLanguage(Class<T> var1);

        public abstract <C, T extends TruffleLanguage<C>> C getCurrentContext(Class<T> var1);

        public abstract TruffleContext getTruffleContext(Object var1);

        public abstract Object toGuestValue(Object var1, Object var2);

        public abstract Object getPolyglotEngine(Object var1);

        public abstract Object lookupHostSymbol(Object var1, TruffleLanguage.Env var2, String var3);

        public abstract Object asHostSymbol(Object var1, Class<?> var2);

        public abstract boolean isHostAccessAllowed(Object var1, TruffleLanguage.Env var2);

        public abstract boolean isNativeAccessAllowed(Object var1, TruffleLanguage.Env var2);

        public abstract boolean inContextPreInitialization(Object var1);

        public abstract Object createInternalContext(Object var1, Map<String, Object> var2, TruffleContext var3);

        public abstract void initializeInternalContext(Object var1, Object var2);

        public abstract Object enterInternalContext(Object var1);

        public abstract void leaveInternalContext(Object var1, Object var2);

        public abstract void closeInternalContext(Object var1);

        public abstract boolean isInternalContextEntered(Object var1);

        public abstract void reportAllLanguageContexts(Object var1, Object var2);

        public abstract void reportAllContextThreads(Object var1, Object var2);

        public abstract TruffleContext getParentContext(Object var1);

        public abstract boolean isCreateThreadAllowed(Object var1);

        public final Thread createThread(Object polyglotLanguageContext, Runnable runnable, Object innerContextImpl, ThreadGroup group) {
            return this.createThread(polyglotLanguageContext, runnable, innerContextImpl, group, 0L);
        }

        public final Thread createThread(Object polyglotLanguageContext, Runnable runnable, Object innerContextImpl) {
            return this.createThread(polyglotLanguageContext, runnable, innerContextImpl, null, 0L);
        }

        public abstract Thread createThread(Object var1, Runnable var2, Object var3, ThreadGroup var4, long var5);

        public abstract Iterable<Scope> createDefaultLexicalScope(Node var1, Frame var2);

        public abstract Iterable<Scope> createDefaultTopScope(Object var1);

        public abstract RuntimeException wrapHostException(Node var1, Object var2, Throwable var3);

        public abstract boolean isHostException(Throwable var1);

        public abstract Throwable asHostException(Throwable var1);

        public abstract Object getCurrentHostContext();

        public abstract PolyglotException wrapGuestException(String var1, Throwable var2);

        public abstract <T> T getOrCreateRuntimeData(Object var1, BiFunction<OptionValues, Supplier<TruffleLogger>, T> var2);

        public abstract Set<? extends Class<?>> getProvidedTags(LanguageInfo var1);

        public abstract Object getPolyglotBindingsForLanguage(Object var1);

        public abstract Object findMetaObjectForLanguage(Object var1, Object var2);

        public abstract boolean isInternal(FileSystem var1);

        public abstract boolean hasAllAccess(FileSystem var1);

        public abstract String getLanguageHome(Object var1);

        public abstract void addToHostClassPath(Object var1, TruffleFile var2);

        public abstract boolean isInstrumentExceptionsAreThrown(Object var1);

        public abstract Object asBoxedGuestValue(Object var1, Object var2);

        public abstract Object createDefaultLoggerCache();

        public abstract Handler getLogHandler(Object var1);

        public abstract Map<String, Level> getLogLevels(Object var1);

        public abstract Object getLoggerOwner(Object var1);

        public abstract TruffleLogger getLogger(Object var1, String var2);

        public abstract LogRecord createLogRecord(Object var1, Level var2, String var3, String var4, String var5, String var6, Object[] var7, Throwable var8);

        public abstract Object getCurrentOuterContext();

        public abstract boolean isCharacterBasedSource(String var1, String var2);

        public abstract Set<String> getValidMimeTypes(String var1);

        public abstract Object asHostObject(Object var1);

        public abstract boolean isHostObject(Object var1);

        public abstract boolean isHostFunction(Object var1);

        public abstract boolean isHostSymbol(Object var1);

        public abstract <S> S lookupService(Object var1, LanguageInfo var2, LanguageInfo var3, Class<S> var4);

        public abstract Object convertPrimitive(Object var1, Class<?> var2);

        public abstract <T extends TruffleLanguage<?>> TruffleLanguage.LanguageReference<T> lookupLanguageReference(Object var1, TruffleLanguage<?> var2, Class<T> var3);

        public abstract <T extends TruffleLanguage<?>> TruffleLanguage.LanguageReference<T> getDirectLanguageReference(Object var1, TruffleLanguage<?> var2, Class<T> var3);

        public abstract <T extends TruffleLanguage<C>, C> TruffleLanguage.ContextReference<C> lookupContextReference(Object var1, TruffleLanguage<?> var2, Class<T> var3);

        public abstract <T extends TruffleLanguage<C>, C> TruffleLanguage.ContextReference<C> getDirectContextReference(Object var1, TruffleLanguage<?> var2, Class<T> var3);

        public abstract FileSystem getFileSystem(Object var1);

        public abstract Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> getFileTypeDetectorsSupplier(Object var1);

        public abstract boolean isPolyglotEvalAllowed(Object var1);

        public abstract boolean isPolyglotBindingsAccessAllowed(Object var1);

        public abstract TruffleFile getTruffleFile(String var1);

        public abstract TruffleFile getTruffleFile(URI var1);

        public abstract int getAsynchronousStackDepth(Object var1);

        public abstract void setAsynchronousStackDepth(Object var1, int var2);

        public abstract boolean isCreateProcessAllowed(Object var1);

        public abstract Map<String, String> getProcessEnvironment(Object var1);

        public abstract Process createSubProcess(Object var1, List<String> var2, String var3, Map<String, String> var4, boolean var5, ProcessHandler.Redirect var6, ProcessHandler.Redirect var7, ProcessHandler.Redirect var8) throws IOException;

        public abstract boolean hasDefaultProcessHandler(Object var1);

        public abstract ProcessHandler.Redirect createRedirectToOutputStream(Object var1, OutputStream var2);

        public abstract boolean isIOAllowed();

        public abstract ZoneId getTimeZone(Object var1);

        public abstract Set<String> getLanguageIds();

        public abstract Set<String> getInstrumentIds();

        public abstract Set<String> getInternalIds();

        public abstract String getUnparsedOptionValue(OptionValues var1, OptionKey<?> var2);

        public abstract String getRelativePathInLanguageHome(TruffleFile var1);

        public abstract void onSourceCreated(Source var1);

        public abstract String getReinitializedPath(TruffleFile var1);

        public abstract URI getReinitializedURI(TruffleFile var1);

        public abstract LanguageInfo getLanguageInfo(Object var1, Class<? extends TruffleLanguage<?>> var2);

        public abstract <C> Object getDefaultLanguageView(TruffleLanguage<C> var1, C var2, Object var3);

        public abstract Object getLanguageView(LanguageInfo var1, Object var2);

        public abstract Object getScopedView(LanguageInfo var1, Node var2, Frame var3, Object var4);

        public abstract boolean initializeLanguage(Object var1, LanguageInfo var2);

        public abstract RuntimeException engineToLanguageException(Throwable var1);

        public abstract RuntimeException engineToInstrumentException(Throwable var1);
    }

    public static abstract class InteropSupport {
        public abstract boolean isTruffleObject(Object var1);

        public abstract void checkInteropType(Object var1);

        public abstract boolean isExecutableObject(Object var1);

        public abstract Object createDefaultNodeObject(Node var1);

        public abstract Object createLegacyMetaObjectWrapper(Object var1, Object var2);

        public abstract Object unwrapLegacyMetaObjectWrapper(Object var1);
    }

    public static abstract class DumpSupport {
        public abstract void dump(Node var1, Node var2, CharSequence var3);
    }

    public static abstract class SourceSupport {
        public abstract Object getSourceIdentifier(Source var1);

        public abstract Source copySource(Source var1);

        public abstract void setPolyglotSource(Source var1, org.graalvm.polyglot.Source var2);

        public abstract org.graalvm.polyglot.Source getPolyglotSource(Source var1);

        public abstract String findMimeType(URL var1, Object var2) throws IOException;

        public abstract boolean isLegacySource(Source var1);

        public abstract Source.SourceBuilder newBuilder(String var1, File var2);

        public abstract void setFileSystemContext(Source.SourceBuilder var1, Object var2);

        public abstract void invalidateAfterPreinitialiation(Source var1);
    }

    public static abstract class NodeSupport {
        public abstract boolean isInstrumentable(RootNode var1);

        public abstract void setCallTarget(RootNode var1, RootCallTarget var2);

        public abstract boolean isCloneUninitializedSupported(RootNode var1);

        public abstract RootNode cloneUninitialized(RootNode var1);

        public abstract int adoptChildrenAndCount(RootNode var1);

        public abstract Object getPolyglotLanguage(LanguageInfo var1);

        public abstract TruffleLanguage<?> getLanguage(RootNode var1);

        public abstract LanguageInfo createLanguage(Object var1, String var2, String var3, String var4, String var5, Set<String> var6, boolean var7, boolean var8);

        public abstract Object getPolyglotEngine(RootNode var1);

        public abstract List<TruffleStackTraceElement> findAsynchronousFrames(CallTarget var1, Frame var2);

        public abstract int getRootNodeBits(RootNode var1);

        public abstract void setRootNodeBits(RootNode var1, int var2);

        public abstract Lock getLock(Node var1);

        public void reportPolymorphicSpecialize(Node node) {
            Accessor.getTVMCI().reportPolymorphicSpecialize(node);
        }

        public abstract void clearPolyglotEngine(RootNode var1);

        public abstract void applyPolyglotEngine(RootNode var1, RootNode var2);

        public abstract void forceAdoption(Node var1, Node var2);
    }
}

