/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.util.TRegexUtil;

public final class RegexCompilerInterface {
    private static final String REPEATED_REG_EXP_FLAG_MSG = "Repeated RegExp flag: %c";
    private static final String UNSUPPORTED_REG_EXP_FLAG_MSG = "Invalid regular expression flags";
    private static final String UNSUPPORTED_REG_EXP_FLAG_MSG_NASHORN = "Unsupported RegExp flag: %c";

    private RegexCompilerInterface() {
    }

    public static Object compile(String pattern, String flags, JSContext context, TRegexUtil.CompileRegexNode compileRegexNode) {
        RegexCompilerInterface.validateFlags(flags, context.getEcmaScriptVersion(), context.isOptionNashornCompatibilityMode());
        try {
            return compileRegexNode.execute(context.getRegexEngine(), pattern, flags);
        }
        catch (RuntimeException e) {
            CompilerDirectives.transferToInterpreter();
            if (e instanceof TruffleException && ((TruffleException)e).isSyntaxError()) {
                throw Errors.createSyntaxError(e.getMessage());
            }
            throw e;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void validate(JSContext context, String pattern, String flags, int ecmaScriptVersion) {
        if (context.isOptionNashornCompatibilityMode() && !flags.isEmpty()) {
            RegexCompilerInterface.validateFlags(flags, ecmaScriptVersion, true);
        }
        try {
            TRegexUtil.ValidateRegexNode.getUncached().execute(context.getRegexEngine(), pattern, flags);
        }
        catch (RuntimeException e) {
            if (e instanceof TruffleException && ((TruffleException)e).isSyntaxError()) {
                throw Errors.createSyntaxError(e.getMessage());
            }
            throw e;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void validateFlags(String flags, int ecmaScriptVersion, boolean nashornCompat) {
        boolean ignoreCase = false;
        boolean multiline = false;
        boolean global = false;
        boolean sticky = false;
        boolean unicode = false;
        boolean dotAll = false;
        for (int i = 0; i < flags.length(); ++i) {
            boolean repeated;
            char ch = flags.charAt(i);
            switch (ch) {
                case 'i': {
                    repeated = ignoreCase;
                    ignoreCase = true;
                    break;
                }
                case 'm': {
                    repeated = multiline;
                    multiline = true;
                    break;
                }
                case 'g': {
                    repeated = global;
                    global = true;
                    break;
                }
                case 'y': {
                    if (ecmaScriptVersion >= 6) {
                        repeated = sticky;
                        sticky = true;
                        break;
                    }
                }
                case 'u': {
                    if (ecmaScriptVersion >= 6) {
                        repeated = unicode;
                        unicode = true;
                        break;
                    }
                }
                case 's': {
                    if (ecmaScriptVersion >= 9) {
                        repeated = dotAll;
                        dotAll = true;
                        break;
                    }
                }
                default: {
                    if (nashornCompat) {
                        throw RegexCompilerInterface.throwFlagError(UNSUPPORTED_REG_EXP_FLAG_MSG_NASHORN, ch);
                    }
                    throw RegexCompilerInterface.throwFlagError(UNSUPPORTED_REG_EXP_FLAG_MSG);
                }
            }
            if (!repeated) continue;
            throw RegexCompilerInterface.throwFlagError(REPEATED_REG_EXP_FLAG_MSG, ch);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static RuntimeException throwFlagError(String msg, char flag) {
        throw Errors.createSyntaxError(String.format(msg, Character.valueOf(flag)));
    }

    @CompilerDirectives.TruffleBoundary
    private static RuntimeException throwFlagError(String msg) {
        throw Errors.createSyntaxError(msg);
    }
}

