/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter.resolve.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.shared.artifact.filter.resolve.AbstractFilter;
import org.apache.maven.shared.artifact.filter.resolve.AndFilter;
import org.apache.maven.shared.artifact.filter.resolve.ExclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.FilterTransformer;
import org.apache.maven.shared.artifact.filter.resolve.OrFilter;
import org.apache.maven.shared.artifact.filter.resolve.PatternExclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.PatternInclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.SonatypeAetherNode;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.util.filter.AndDependencyFilter;
import org.sonatype.aether.util.filter.ExclusionsDependencyFilter;
import org.sonatype.aether.util.filter.OrDependencyFilter;
import org.sonatype.aether.util.filter.PatternExclusionsDependencyFilter;
import org.sonatype.aether.util.filter.PatternInclusionsDependencyFilter;
import org.sonatype.aether.util.filter.ScopeDependencyFilter;

public class SonatypeAetherFilterTransformer
implements FilterTransformer<DependencyFilter> {
    private static final String GAE_C_V = "(.*:.*:.*):(.+)(:.*)";

    @Override
    public AndDependencyFilter transform(AndFilter filter) {
        ArrayList<DependencyFilter> filters = new ArrayList<DependencyFilter>(filter.getFilters().size());
        for (TransformableFilter dependencyFilter : filter.getFilters()) {
            filters.add(dependencyFilter.transform(this));
        }
        return new AndDependencyFilter(filters);
    }

    @Override
    public ExclusionsDependencyFilter transform(ExclusionsFilter filter) {
        return new ExclusionsDependencyFilter(filter.getExcludes());
    }

    @Override
    public OrDependencyFilter transform(OrFilter filter) {
        ArrayList<DependencyFilter> filters = new ArrayList<DependencyFilter>(filter.getFilters().size());
        for (TransformableFilter dependencyFilter : filter.getFilters()) {
            filters.add(dependencyFilter.transform(this));
        }
        return new OrDependencyFilter(filters);
    }

    @Override
    public ScopeDependencyFilter transform(ScopeFilter filter) {
        return new ScopeDependencyFilter(filter.getIncluded(), filter.getExcluded());
    }

    @Override
    public DependencyFilter transform(PatternExclusionsFilter filter) {
        return new PatternExclusionsDependencyFilter(filter.getExcludes());
    }

    @Override
    public DependencyFilter transform(PatternInclusionsFilter filter) {
        for (String include : filter.getIncludes()) {
            if (!include.matches(GAE_C_V)) continue;
            return this.newAdvancedPatternInclusionFilter(filter.getIncludes());
        }
        return new PatternInclusionsDependencyFilter(filter.getIncludes());
    }

    @Override
    public DependencyFilter transform(final AbstractFilter filter) {
        return new DependencyFilter(){

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                return filter.accept(new SonatypeAetherNode(node), null);
            }
        };
    }

    private DependencyFilter newAdvancedPatternInclusionFilter(Collection<String> includes) {
        ArrayList<Object> filters = new ArrayList<Object>(includes.size());
        Pattern pattern = Pattern.compile(GAE_C_V);
        for (String include : includes) {
            Matcher matcher = pattern.matcher(include);
            if (matcher.matches()) {
                PatternInclusionsDependencyFilter patternFilter = new PatternInclusionsDependencyFilter(new String[]{matcher.group(1) + matcher.group(3)});
                final String classifier = matcher.group(2);
                DependencyFilter classifierFilter = new DependencyFilter(){

                    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                        String nodeClassifier = node.getDependency().getArtifact().getClassifier();
                        if (nodeClassifier == null) {
                            return false;
                        }
                        return "*".equals(classifier) || nodeClassifier.matches(classifier);
                    }
                };
                filters.add(new AndDependencyFilter(new DependencyFilter[]{patternFilter, classifierFilter}));
                continue;
            }
            filters.add(new PatternInclusionsDependencyFilter(new String[]{include}));
        }
        return new OrDependencyFilter(filters);
    }
}

