/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.util.internal.StringUtils;

public class ForkingRunListener
implements RunListener,
ConsoleLogger,
ConsoleOutputReceiver {
    public static final byte BOOTERCODE_TESTSET_STARTING = 49;
    public static final byte BOOTERCODE_TESTSET_COMPLETED = 50;
    public static final byte BOOTERCODE_STDOUT = 51;
    public static final byte BOOTERCODE_STDERR = 52;
    public static final byte BOOTERCODE_TEST_STARTING = 53;
    public static final byte BOOTERCODE_TEST_SUCCEEDED = 54;
    public static final byte BOOTERCODE_TEST_ERROR = 55;
    public static final byte BOOTERCODE_TEST_FAILED = 56;
    public static final byte BOOTERCODE_TEST_SKIPPED = 57;
    public static final byte BOOTERCODE_TEST_ASSUMPTIONFAILURE = 71;
    public static final byte BOOTERCODE_CONSOLE = 72;
    public static final byte BOOTERCODE_SYSPROPS = 73;
    public static final byte BOOTERCODE_NEXT_TEST = 78;
    public static final byte BOOTERCODE_STOP_ON_NEXT_TEST = 83;
    public static final byte BOOTERCODE_ERROR = 88;
    public static final byte BOOTERCODE_BYE = 90;
    private final PrintStream target;
    private final int testSetChannelId;
    private final boolean trimStackTraces;
    private final byte[] stdOutHeader;
    private final byte[] stdErrHeader;

    public ForkingRunListener(PrintStream target, int testSetChannelId, boolean trimStackTraces) {
        this.target = target;
        this.testSetChannelId = testSetChannelId;
        this.trimStackTraces = trimStackTraces;
        this.stdOutHeader = ForkingRunListener.createHeader((byte)51, testSetChannelId);
        this.stdErrHeader = ForkingRunListener.createHeader((byte)52, testSetChannelId);
        this.sendProps();
    }

    public void testSetStarting(ReportEntry report) {
        this.encodeAndWriteToTarget(this.toString((byte)49, report, this.testSetChannelId));
    }

    public void testSetCompleted(ReportEntry report) {
        this.encodeAndWriteToTarget(this.toString((byte)50, report, this.testSetChannelId));
    }

    public void testStarting(ReportEntry report) {
        this.encodeAndWriteToTarget(this.toString((byte)53, report, this.testSetChannelId));
    }

    public void testSucceeded(ReportEntry report) {
        this.encodeAndWriteToTarget(this.toString((byte)54, report, this.testSetChannelId));
    }

    public void testAssumptionFailure(ReportEntry report) {
        this.encodeAndWriteToTarget(this.toString((byte)71, report, this.testSetChannelId));
    }

    public void testError(ReportEntry report) {
        this.encodeAndWriteToTarget(this.toString((byte)55, report, this.testSetChannelId));
    }

    public void testFailed(ReportEntry report) {
        this.encodeAndWriteToTarget(this.toString((byte)56, report, this.testSetChannelId));
    }

    public void testSkipped(ReportEntry report) {
        this.encodeAndWriteToTarget(this.toString((byte)57, report, this.testSetChannelId));
    }

    public void testExecutionSkippedByUser() {
        this.encodeAndWriteToTarget(this.toString((byte)83, new SimpleReportEntry(), this.testSetChannelId));
    }

    void sendProps() {
        Properties systemProperties = System.getProperties();
        if (systemProperties != null) {
            Enumeration<?> propertyKeys = systemProperties.propertyNames();
            while (propertyKeys.hasMoreElements()) {
                String key;
                String value = systemProperties.getProperty(key = (String)propertyKeys.nextElement());
                this.encodeAndWriteToTarget(this.toPropertyString(key, value == null ? "null" : value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        byte[] header = stdout ? this.stdOutHeader : this.stdErrHeader;
        byte[] content = new byte[buf.length * 3 + 1];
        int i = StringUtils.escapeBytesToPrintable(content, 0, buf, off, len);
        content[i++] = 10;
        PrintStream printStream = this.target;
        synchronized (printStream) {
            this.target.write(header, 0, header.length);
            this.target.write(content, 0, i);
        }
    }

    public static byte[] createHeader(byte booterCode, int testSetChannel) {
        return StringUtils.encodeStringForForkCommunication(String.valueOf((char)booterCode) + ',' + Integer.toString(testSetChannel, 16) + ',' + Charset.defaultCharset().name() + ',');
    }

    public void info(String message) {
        if (message != null) {
            StringBuilder sb = new StringBuilder(7 + message.length() * 5);
            this.append(sb, (byte)72);
            ForkingRunListener.comma(sb);
            this.append(sb, Integer.toHexString(this.testSetChannelId));
            ForkingRunListener.comma(sb);
            StringUtils.escapeToPrintable(sb, message);
            sb.append('\n');
            this.encodeAndWriteToTarget(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeAndWriteToTarget(String string) {
        byte[] encodeBytes = StringUtils.encodeStringForForkCommunication(string);
        PrintStream printStream = this.target;
        synchronized (printStream) {
            this.target.write(encodeBytes, 0, encodeBytes.length);
        }
    }

    private String toPropertyString(String key, String value) {
        StringBuilder stringBuilder = new StringBuilder();
        this.append(stringBuilder, (byte)73);
        ForkingRunListener.comma(stringBuilder);
        this.append(stringBuilder, Integer.toHexString(this.testSetChannelId));
        ForkingRunListener.comma(stringBuilder);
        StringUtils.escapeToPrintable(stringBuilder, key);
        ForkingRunListener.comma(stringBuilder);
        StringUtils.escapeToPrintable(stringBuilder, value);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private String toString(byte operationCode, ReportEntry reportEntry, int testSetChannelId) {
        StringBuilder stringBuilder = new StringBuilder();
        this.append(stringBuilder, operationCode);
        ForkingRunListener.comma(stringBuilder);
        this.append(stringBuilder, Integer.toHexString(testSetChannelId));
        ForkingRunListener.comma(stringBuilder);
        ForkingRunListener.nullableEncoding(stringBuilder, reportEntry.getSourceName());
        ForkingRunListener.comma(stringBuilder);
        ForkingRunListener.nullableEncoding(stringBuilder, reportEntry.getName());
        ForkingRunListener.comma(stringBuilder);
        ForkingRunListener.nullableEncoding(stringBuilder, reportEntry.getGroup());
        ForkingRunListener.comma(stringBuilder);
        ForkingRunListener.nullableEncoding(stringBuilder, reportEntry.getMessage());
        ForkingRunListener.comma(stringBuilder);
        this.nullableEncoding(stringBuilder, reportEntry.getElapsed());
        this.encode(stringBuilder, reportEntry.getStackTraceWriter());
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private static void comma(StringBuilder stringBuilder) {
        stringBuilder.append(",");
    }

    private ForkingRunListener append(StringBuilder stringBuilder, String message) {
        stringBuilder.append(this.encode(message));
        return this;
    }

    private ForkingRunListener append(StringBuilder stringBuilder, byte b) {
        stringBuilder.append((char)b);
        return this;
    }

    private void nullableEncoding(StringBuilder stringBuilder, Integer source) {
        if (source == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(source.toString());
        }
    }

    private String encode(String source) {
        return source;
    }

    private static void nullableEncoding(StringBuilder stringBuilder, String source) {
        if (source == null || source.length() == 0) {
            stringBuilder.append("null");
        } else {
            StringUtils.escapeToPrintable(stringBuilder, source);
        }
    }

    private void encode(StringBuilder stringBuilder, StackTraceWriter stackTraceWriter) {
        ForkingRunListener.encode(stringBuilder, stackTraceWriter, this.trimStackTraces);
    }

    public static void encode(StringBuilder stringBuilder, StackTraceWriter stackTraceWriter, boolean trimStackTraces) {
        if (stackTraceWriter != null) {
            ForkingRunListener.comma(stringBuilder);
            SafeThrowable throwable = stackTraceWriter.getThrowable();
            if (throwable != null) {
                String message = throwable.getLocalizedMessage();
                ForkingRunListener.nullableEncoding(stringBuilder, message);
            }
            ForkingRunListener.comma(stringBuilder);
            ForkingRunListener.nullableEncoding(stringBuilder, stackTraceWriter.smartTrimmedStackTrace());
            ForkingRunListener.comma(stringBuilder);
            ForkingRunListener.nullableEncoding(stringBuilder, trimStackTraces ? stackTraceWriter.writeTrimmedTraceToString() : stackTraceWriter.writeTraceToString());
        }
    }
}

