/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.InitErrorObjectNodeFactory;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.CreateMethodPropertyNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSProperty;

public final class InitErrorObjectNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertySetNode setException;
    @Node.Child
    private PropertySetNode setFormattedStack;
    @Node.Child
    private DefineStackPropertyNode defineStackProperty;
    private final boolean defaultColumnNumber;
    @Node.Child
    private CreateMethodPropertyNode setLineNumber;
    @Node.Child
    private CreateMethodPropertyNode setColumnNumber;

    private InitErrorObjectNode(JSContext context, boolean defaultColumnNumber) {
        this.setException = PropertySetNode.createSetHidden(JSError.EXCEPTION_PROPERTY_NAME, context);
        this.setFormattedStack = PropertySetNode.createSetHidden(JSError.FORMATTED_STACK_NAME, context);
        this.defineStackProperty = DefineStackPropertyNode.create();
        this.defaultColumnNumber = defaultColumnNumber;
        if (context.isOptionNashornCompatibilityMode()) {
            this.setLineNumber = CreateMethodPropertyNode.create(context, "lineNumber");
            this.setColumnNumber = CreateMethodPropertyNode.create(context, "columnNumber");
        }
    }

    public static InitErrorObjectNode create(JSContext context) {
        return new InitErrorObjectNode(context, false);
    }

    public static InitErrorObjectNode create(JSContext context, boolean defaultColumnNumber) {
        return new InitErrorObjectNode(context, defaultColumnNumber);
    }

    public DynamicObject execute(DynamicObject errorObj, GraalJSException exception) {
        this.setException.setValue(errorObj, exception);
        this.setFormattedStack.setValue(errorObj, null);
        this.defineStackProperty.execute(errorObj);
        if (this.setLineNumber != null && exception.getJSStackTrace().length > 0) {
            GraalJSException.JSStackTraceElement topStackTraceElement = exception.getJSStackTrace()[0];
            this.setLineNumber.executeVoid(errorObj, topStackTraceElement.getLineNumber());
            this.setColumnNumber.executeVoid(errorObj, this.defaultColumnNumber ? -1 : topStackTraceElement.getColumnNumber());
        }
        return errorObj;
    }

    @ImportStatic(value={JSError.class})
    public static abstract class DefineStackPropertyNode
    extends JavaScriptBaseNode {
        static DefineStackPropertyNode create() {
            return InitErrorObjectNodeFactory.DefineStackPropertyNodeGen.create();
        }

        abstract void execute(DynamicObject var1);

        @Specialization(guards={"shapeAfter != null", "errorObj.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()", "shapeAfter.getValidAssumption()"}, limit="3")
        void doCached(DynamicObject errorObj, @Cached(value="errorObj.getShape()") Shape cachedShape, @Cached(value="addStackProperty(cachedShape)") Shape shapeAfter, @Cached(value="shapeAfter.getProperty(STACK_NAME)") Property cachedProperty) {
            cachedProperty.setSafe(errorObj, (Object)JSError.STACK_PROXY, cachedShape, shapeAfter);
        }

        static Shape addStackProperty(Shape shape) {
            Property stackProperty = shape.getProperty((Object)"stack");
            if (stackProperty != null) {
                return null;
            }
            return shape.defineProperty((Object)"stack", (Object)JSError.STACK_PROXY, JSAttributes.getDefaultNotEnumerable() | 0x10);
        }

        @Specialization(replaces={"doCached"})
        void doUncached(DynamicObject errorObj) {
            Property stackProperty = errorObj.getShape().getProperty((Object)"stack");
            int attrs = JSAttributes.getDefaultNotEnumerable();
            if (stackProperty != null) {
                if (!JSProperty.isConfigurable(stackProperty)) {
                    throw Errors.createTypeErrorCannotRedefineProperty("stack");
                }
                if (JSProperty.isEnumerable(stackProperty)) {
                    attrs = JSAttributes.getDefault();
                }
            }
            JSObjectUtil.defineProxyProperty(errorObj, "stack", JSError.STACK_PROXY, attrs | 0x10);
        }
    }
}

