/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.Undefined;

public class IteratorCloseNode
extends JavaScriptBaseNode {
    @Node.Child
    private GetMethodNode getReturnNode;
    @Node.Child
    private JSFunctionCallNode methodCallNode;
    @Node.Child
    private IsJSObjectNode isObjectNode;
    @Node.Child
    private JavaScriptNode iteratorNode;

    protected IteratorCloseNode(JSContext context, JavaScriptNode iteratorNode) {
        this.getReturnNode = GetMethodNode.create(context, null, "return");
        this.methodCallNode = JSFunctionCallNode.createCall();
        this.isObjectNode = IsJSObjectNode.create();
        this.iteratorNode = iteratorNode;
    }

    public static IteratorCloseNode create(JSContext context) {
        return new IteratorCloseNode(context, null);
    }

    public static IteratorCloseNode create(JSContext context, JavaScriptNode iteratorNode) {
        return new IteratorCloseNode(context, iteratorNode);
    }

    public final void executeVoid(DynamicObject iterator) {
        Object innerResult;
        Object returnMethod = this.getReturnNode.executeWithTarget(iterator);
        if (returnMethod != Undefined.instance && !this.isObjectNode.executeBoolean(innerResult = this.methodCallNode.executeCall(JSArguments.createZeroArg(iterator, returnMethod)))) {
            throw Errors.createTypeErrorIterResultNotAnObject(innerResult, this);
        }
    }

    public final Object execute(DynamicObject iterator, Object value) {
        this.executeVoid(iterator);
        return value;
    }

    public final void executeAbrupt(DynamicObject iterator) {
        Object returnMethod = this.getReturnNode.executeWithTarget(iterator);
        if (returnMethod != Undefined.instance) {
            try {
                this.methodCallNode.executeCall(JSArguments.createZeroArg(iterator, returnMethod));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

