/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.intl.CreateOptionsObjectNode;
import com.oracle.truffle.js.nodes.intl.CreateOptionsObjectNodeGen;
import com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import com.oracle.truffle.js.nodes.intl.InitializeDisplayNamesNodeGen;
import com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSDisplayNames;
import java.util.MissingResourceException;

public abstract class InitializeDisplayNamesNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;
    @Node.Child
    CreateOptionsObjectNode createOptionsNode;
    @Node.Child
    GetStringOptionNode getLocaleMatcherOption;
    @Node.Child
    GetStringOptionNode getStyleOption;
    @Node.Child
    GetStringOptionNode getTypeOption;
    @Node.Child
    GetStringOptionNode getFallbackOption;

    protected InitializeDisplayNamesNode(JSContext context) {
        this.context = context;
        this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context);
        this.createOptionsNode = CreateOptionsObjectNodeGen.create(context);
        this.getLocaleMatcherOption = GetStringOptionNode.create(context, "localeMatcher", new String[]{"lookup", "best fit"}, "best fit");
        this.getStyleOption = GetStringOptionNode.create(context, "style", new String[]{"narrow", "short", "long"}, "long");
        this.getTypeOption = GetStringOptionNode.create(context, "type", new String[]{"language", "region", "script", "currency"}, "language");
        this.getFallbackOption = GetStringOptionNode.create(context, "fallback", new String[]{"code", "none"}, "code");
    }

    public abstract DynamicObject executeInit(DynamicObject var1, Object var2, Object var3);

    public static InitializeDisplayNamesNode createInitalizeDisplayNamesNode(JSContext context) {
        return InitializeDisplayNamesNodeGen.create(context);
    }

    @Specialization
    public DynamicObject initializeDisplayNames(DynamicObject displayNamesObject, Object localesArg, Object optionsArg) {
        try {
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(localesArg);
            DynamicObject options = this.createOptionsNode.execute(optionsArg);
            this.getLocaleMatcherOption.executeValue(options);
            String optStyle = this.getStyleOption.executeValue(options);
            String optType = this.getTypeOption.executeValue(options);
            String optFallback = this.getFallbackOption.executeValue(options);
            JSDisplayNames.InternalState state = JSDisplayNames.getInternalState(displayNamesObject);
            JSDisplayNames.setupInternalState(this.context, state, locales, optStyle, optType, optFallback);
        }
        catch (MissingResourceException e) {
            throw Errors.createICU4JDataError(e);
        }
        return displayNamesObject;
    }
}

