/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;

public class SetFunctionNameNode
extends JavaScriptBaseNode {
    private final ConditionProfile isSymbolProfile = ConditionProfile.createBinaryProfile();

    protected SetFunctionNameNode() {
    }

    public static SetFunctionNameNode create() {
        return new SetFunctionNameNode();
    }

    public Object execute(Object functionValue, Object propertyKey) {
        return this.execute(functionValue, propertyKey, null);
    }

    public Object execute(Object functionValue, Object propertyKey, String prefix) {
        String name;
        assert (JSFunction.isJSFunction(functionValue));
        assert (JSRuntime.isPropertyKey(propertyKey));
        String string = name = this.isSymbolProfile.profile(propertyKey instanceof Symbol) ? ((Symbol)propertyKey).toFunctionNameString() : (String)propertyKey;
        if (prefix != null && !prefix.isEmpty()) {
            name = SetFunctionNameNode.concatenate(prefix, name);
        }
        return SetFunctionNameNode.setFunctionName((DynamicObject)functionValue, name);
    }

    @CompilerDirectives.TruffleBoundary
    private static String concatenate(String prefix, String name) {
        return new StringBuilder(prefix.length() + 1 + name.length()).append(prefix).append(' ').append(name).toString();
    }

    private static Object setFunctionName(DynamicObject functionValue, String name) {
        PropertyDescriptor propDesc = PropertyDescriptor.createData(name, false, false, true);
        JSRuntime.definePropertyOrThrow(functionValue, "name", propDesc);
        return functionValue;
    }
}

