/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.BlockParser;
import org.apache.maven.doxia.module.twiki.parser.FormatedTextParser;
import org.apache.maven.doxia.module.twiki.parser.GenericListBlockParser;
import org.apache.maven.doxia.module.twiki.parser.HRuleBlockParser;
import org.apache.maven.doxia.module.twiki.parser.NopBlock;
import org.apache.maven.doxia.module.twiki.parser.ParagraphBlock;
import org.apache.maven.doxia.module.twiki.parser.SectionBlockParser;
import org.apache.maven.doxia.module.twiki.parser.TableBlockParser;
import org.apache.maven.doxia.module.twiki.parser.VerbatimBlockParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineSource;

public class ParagraphBlockParser
implements BlockParser {
    private final Pattern paragraphSeparator = Pattern.compile("^(\\s*)$");
    private SectionBlockParser sectionParser;
    private GenericListBlockParser listParser;
    private FormatedTextParser textParser;
    private HRuleBlockParser hrulerParser;
    private TableBlockParser tableBlockParser;
    private VerbatimBlockParser verbatimParser;
    private static final NopBlock NOP = new NopBlock();

    @Override
    public final boolean accept(String line) {
        return !this.sectionParser.accept(line) && !this.hrulerParser.accept(line) && !this.verbatimParser.accept(line);
    }

    @Override
    public final Block visit(String line, ByLineSource source) throws ParseException {
        StringBuilder sb = new StringBuilder();
        ArrayList<Block> childs = new ArrayList<Block>();
        boolean sawText = false;
        boolean pre = false;
        String l = line;
        do {
            Matcher m;
            if ((m = this.paragraphSeparator.matcher(l)).lookingAt()) {
                if (!sawText) continue;
                break;
            }
            sawText = true;
            if (this.listParser.accept(l)) {
                if (sb.length() != 0) {
                    childs.addAll(Arrays.asList(this.textParser.parse(sb.toString().trim())));
                    sb = new StringBuilder();
                }
                childs.add(this.listParser.visit(l, source));
                continue;
            }
            if (this.tableBlockParser.accept(l)) {
                childs.add(this.tableBlockParser.visit(l, source));
                continue;
            }
            sb.append(l);
            if (l.contains("<pre>")) {
                pre = true;
            }
            if (l.contains("</pre>")) {
                pre = false;
            }
            if (!pre) {
                sb.append(" ");
                continue;
            }
            sb.append("\n");
        } while ((l = source.getNextLine()) != null && this.accept(l));
        if (line != null) {
            source.ungetLine();
        }
        if (sb.length() != 0) {
            childs.addAll(Arrays.asList(this.textParser.parse(sb.toString().trim())));
            sb = new StringBuilder();
        }
        if (childs.size() == 0) {
            return NOP;
        }
        return new ParagraphBlock(childs.toArray(new Block[0]));
    }

    public final void setSectionParser(SectionBlockParser aSectionParser) {
        if (aSectionParser == null) {
            throw new IllegalArgumentException("arg can't be null");
        }
        this.sectionParser = aSectionParser;
    }

    public final void setListParser(GenericListBlockParser aListParser) {
        if (aListParser == null) {
            throw new IllegalArgumentException("arg can't be null");
        }
        this.listParser = aListParser;
    }

    public final void setTextParser(FormatedTextParser aTextParser) {
        if (aTextParser == null) {
            throw new IllegalArgumentException("arg can't be null");
        }
        this.textParser = aTextParser;
    }

    public final void setHrulerParser(HRuleBlockParser aHrulerParser) {
        if (aHrulerParser == null) {
            throw new IllegalArgumentException("arg can't be null");
        }
        this.hrulerParser = aHrulerParser;
    }

    public final void setTableBlockParser(TableBlockParser aTableBlockParser) {
        if (aTableBlockParser == null) {
            throw new IllegalArgumentException("arg can't be null");
        }
        this.tableBlockParser = aTableBlockParser;
    }

    public final void setVerbatimParser(VerbatimBlockParser aVerbatimParser) {
        if (aVerbatimParser == null) {
            throw new IllegalArgumentException("arg can't be null");
        }
        this.verbatimParser = aVerbatimParser;
    }
}

