/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.macro;

import java.util.Map;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Macro.class, hint="ssi")
public class SsiMacro
extends AbstractMacro {
    private static final String PARAM_FUNCTION = "function";

    private boolean isInternalParameter(String name) {
        return PARAM_FUNCTION.equals(name) || MacroRequest.isInternalParameter(name);
    }

    @Override
    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        String function = (String)request.getParameter(PARAM_FUNCTION);
        this.required(PARAM_FUNCTION, function);
        StringBuilder buff = new StringBuilder();
        buff.append('#');
        buff.append(function);
        for (Map.Entry<String, Object> entry : request.getParameters().entrySet()) {
            if (this.isInternalParameter(entry.getKey())) continue;
            buff.append(' ');
            buff.append(entry.getKey());
            buff.append("=\"");
            buff.append(entry.getValue());
            buff.append('\"');
        }
        buff.append(' ');
        sink.comment(buff.toString());
    }
}

