/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.DefaultBlockNode;
import com.oracle.truffle.api.impl.DefaultCallTarget;
import com.oracle.truffle.api.impl.DefaultIndirectCallNode;
import com.oracle.truffle.api.impl.TVMCI;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;

final class DefaultTVMCI
extends TVMCI {
    private static final DefaultCastUnsafe CAST_UNSAFE = new DefaultCastUnsafe();

    DefaultTVMCI() {
    }

    @Override
    protected void onLoopCount(Node source, int count) {
    }

    void onFirstExecution(DefaultCallTarget callTarget) {
        super.onFirstExecution(callTarget.getRootNode());
    }

    void onLoad(DefaultCallTarget callTarget) {
        super.onLoad(callTarget.getRootNode());
    }

    @Override
    protected IndirectCallNode createUncachedIndirectCall() {
        return DefaultIndirectCallNode.createUncached();
    }

    @Override
    protected Accessor.CallInlined getCallInlined() {
        return DefaultCallTarget.CALL_INLINED;
    }

    @Override
    protected Accessor.CallProfiled getCallProfiled() {
        return DefaultCallTarget.CALL_PROFILED;
    }

    @Override
    protected Accessor.CastUnsafe getCastUnsafe() {
        return CAST_UNSAFE;
    }

    @Override
    protected <T extends Node> BlockNode<T> createBlockNode(T[] elements, BlockNode.ElementExecutor<T> executor) {
        return new DefaultBlockNode(elements, executor);
    }

    @Override
    protected boolean isGuestCallStackFrame(StackTraceElement e) {
        String methodName = e.getMethodName();
        return methodName.startsWith("call") && e.getClassName().equals(DefaultCallTarget.class.getName());
    }

    private static final class DefaultCastUnsafe
    extends Accessor.CastUnsafe {
        private DefaultCastUnsafe() {
        }

        @Override
        public Object[] castArrayFixedLength(Object[] args, int length) {
            return args;
        }

        @Override
        public <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
            return (T)value;
        }
    }
}

