/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter.spi;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.maven.surefire.api.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.api.util.internal.WritableBufferedByteChannel;
import org.apache.maven.surefire.spi.MasterProcessChannelProcessorFactory;

public abstract class AbstractMasterProcessChannelProcessorFactory
implements MasterProcessChannelProcessorFactory {
    private static final String STREAM_FLUSHER = "surefire-forkedjvm-stream-flusher";
    private final ScheduledExecutorService flusher = Executors.newScheduledThreadPool(1, DaemonThreadFactory.newDaemonThreadFactory((String)"surefire-forkedjvm-stream-flusher"));

    protected void schedulePeriodicFlusher(int delayInMillis, final WritableBufferedByteChannel channel) {
        final AtomicLong bufferOverflows = new AtomicLong();
        this.flusher.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                long currentBufferOverflows = channel.countBufferOverflows();
                if (bufferOverflows.get() == currentBufferOverflows) {
                    try {
                        channel.write(ByteBuffer.allocate(0));
                    }
                    catch (Exception exception) {}
                } else {
                    bufferOverflows.set(currentBufferOverflows);
                }
            }
        }, 0L, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public void close() throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    AbstractMasterProcessChannelProcessorFactory.this.flusher.shutdown();
                    return null;
                }
            });
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }
}

