/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.ibm.icu.util.ULocale;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.intl.LocalePrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.EnumSet;
import java.util.Locale;

public final class JSLocale
extends JSBuiltinObject
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final String CLASS_NAME = "Locale";
    public static final String PROTOTYPE_NAME = "Locale.prototype";
    private static final HiddenKey INTERNAL_STATE_ID = new HiddenKey("_internalState");
    private static final Property INTERNAL_STATE_PROPERTY;
    public static final JSLocale INSTANCE;

    private JSLocale() {
    }

    public static boolean isJSLocale(Object obj) {
        return JSObject.isDynamicObject(obj) && JSLocale.isJSLocale((DynamicObject)obj);
    }

    public static boolean isJSLocale(DynamicObject obj) {
        return JSLocale.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject localePrototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(ctx, localePrototype, ctor);
        JSObjectUtil.putDataProperty(ctx, localePrototype, Symbol.SYMBOL_TO_STRING_TAG, "Intl.Locale", JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putFunctionsFromContainer(realm, localePrototype, LocalePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putConstantAccessorProperty(ctx, localePrototype, "baseName", JSLocale.createBaseNameGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putConstantAccessorProperty(ctx, localePrototype, "calendar", JSLocale.createCalendarGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putConstantAccessorProperty(ctx, localePrototype, "caseFirst", JSLocale.createCaseFirstGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putConstantAccessorProperty(ctx, localePrototype, "collation", JSLocale.createCollationGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putConstantAccessorProperty(ctx, localePrototype, "hourCycle", JSLocale.createHourCycleGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putConstantAccessorProperty(ctx, localePrototype, "numeric", JSLocale.createNumericGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putConstantAccessorProperty(ctx, localePrototype, "numberingSystem", JSLocale.createNumberingSystemGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putConstantAccessorProperty(ctx, localePrototype, "language", JSLocale.createLanguageGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putConstantAccessorProperty(ctx, localePrototype, "script", JSLocale.createScriptGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putConstantAccessorProperty(ctx, localePrototype, "region", JSLocale.createRegionGetterFunction(realm), Undefined.instance);
        return localePrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        initialShape = initialShape.addProperty(INTERNAL_STATE_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static DynamicObject create(JSContext context) {
        InternalState state = new InternalState();
        DynamicObject result = JSObject.create(context, context.getLocaleFactory(), state);
        assert (JSLocale.isJSLocale(result));
        return result;
    }

    static Object emptyStringToUndefined(String s) {
        return s.isEmpty() ? Undefined.instance : s;
    }

    private static DynamicObject createBaseNameGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleBaseName, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){

                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSLocale.getInternalState((DynamicObject)obj).getBaseName();
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get baseName");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createCalendarGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleCalendar, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){

                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSRuntime.nullToUndefined(JSLocale.getInternalState((DynamicObject)((DynamicObject)obj)).calendar);
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get calendar");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createCaseFirstGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleCaseFirst, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){

                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSRuntime.nullToUndefined(JSLocale.getInternalState((DynamicObject)((DynamicObject)obj)).caseFirst);
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get caseFirst");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createCollationGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleCollation, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){

                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSRuntime.nullToUndefined(JSLocale.getInternalState((DynamicObject)((DynamicObject)obj)).collation);
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get collation");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createHourCycleGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleHourCycle, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){

                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSRuntime.nullToUndefined(JSLocale.getInternalState((DynamicObject)((DynamicObject)obj)).hourCycle);
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get hourCycle");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createNumericGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleNumeric, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){

                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSRuntime.nullToUndefined(JSLocale.getInternalState((DynamicObject)((DynamicObject)obj)).numeric);
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get numeric");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createNumberingSystemGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleNumberingSystem, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){

                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSRuntime.nullToUndefined(JSLocale.getInternalState((DynamicObject)((DynamicObject)obj)).numberingSystem);
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get numberingSystem");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createLanguageGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleLanguage, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){

                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSLocale.emptyStringToUndefined(JSLocale.getInternalState((DynamicObject)obj).getLanguage());
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get language");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createScriptGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleScript, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){

                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSLocale.emptyStringToUndefined(JSLocale.getInternalState((DynamicObject)obj).getScript());
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get script");
        });
        return JSFunction.create(realm, getterData);
    }

    private static DynamicObject createRegionGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.LocaleRegion, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){

                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSLocale.isJSLocale(obj)) {
                        return JSLocale.emptyStringToUndefined(JSLocale.getInternalState((DynamicObject)obj).getRegion());
                    }
                    throw Errors.createTypeErrorLocaleExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get region");
        });
        return JSFunction.create(realm, getterData);
    }

    @CompilerDirectives.TruffleBoundary
    public static void setupInternalState(InternalState state, Locale locale) {
        state.locale = locale;
        state.calendar = locale.getUnicodeLocaleType("ca");
        state.caseFirst = locale.getUnicodeLocaleType("kf");
        state.collation = locale.getUnicodeLocaleType("co");
        state.hourCycle = locale.getUnicodeLocaleType("hc");
        String kn = locale.getUnicodeLocaleType("kn");
        state.numeric = "true".equals(kn) || "".equals(kn);
        state.numberingSystem = locale.getUnicodeLocaleType("nu");
    }

    public static InternalState getInternalState(DynamicObject localeObject) {
        return (InternalState)INTERNAL_STATE_PROPERTY.get(localeObject, JSLocale.isJSLocale(localeObject));
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getLocalePrototype();
    }

    static {
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        INTERNAL_STATE_PROPERTY = JSObjectUtil.makeHiddenProperty(INTERNAL_STATE_ID, allocator.locationForType(InternalState.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)));
        INSTANCE = new JSLocale();
    }

    public static class InternalState {
        private Locale locale;
        String calendar;
        String caseFirst;
        String collation;
        String hourCycle;
        boolean numeric;
        String numberingSystem;

        @CompilerDirectives.TruffleBoundary
        public String getLocale() {
            return IntlUtil.maybeAppendMissingLanguageSubTag(this.locale.toLanguageTag());
        }

        @CompilerDirectives.TruffleBoundary
        public String getBaseName() {
            return this.locale.stripExtensions().toLanguageTag();
        }

        @CompilerDirectives.TruffleBoundary
        public String getLanguage() {
            return this.locale.getLanguage();
        }

        @CompilerDirectives.TruffleBoundary
        public String getScript() {
            return this.locale.getScript();
        }

        @CompilerDirectives.TruffleBoundary
        public String getRegion() {
            return this.locale.getCountry();
        }

        @CompilerDirectives.TruffleBoundary
        public String maximize() {
            ULocale max = ULocale.addLikelySubtags((ULocale)ULocale.forLocale((Locale)this.locale));
            Locale.Builder builder = new Locale.Builder().setLocale(this.locale);
            builder.setLanguage(max.getLanguage());
            builder.setScript(max.getScript());
            builder.setRegion(max.getCountry());
            return builder.build().toLanguageTag();
        }

        @CompilerDirectives.TruffleBoundary
        public String minimize() {
            ULocale max = ULocale.minimizeSubtags((ULocale)ULocale.forLocale((Locale)this.locale));
            Locale.Builder builder = new Locale.Builder().setLocale(this.locale);
            builder.setLanguage(max.getLanguage());
            builder.setScript(max.getScript());
            builder.setRegion(max.getCountry());
            return builder.build().toLanguageTag();
        }
    }
}

