/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.nodes.interop.JSInteropCallNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNodeGen;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.JSClassProfile;

@GenerateUncached
public abstract class JSInteropInvokeNode
extends JSInteropCallNode {
    JSInteropInvokeNode() {
    }

    public static JSInteropInvokeNode create() {
        return JSInteropInvokeNodeGen.create();
    }

    public abstract Object execute(DynamicObject var1, String var2, Object[] var3) throws UnknownIdentifierException, UnsupportedMessageException;

    @Specialization(guards={"cachedName.equals(name)"}, limit="1")
    Object doCached(DynamicObject receiver, String name, Object[] arguments, @Cached(value="name") String cachedName, @CachedLanguage TruffleLanguage.LanguageReference<JavaScriptLanguage> languageRef, @Cached(value="createGetProperty(cachedName, languageRef)") PropertyGetNode functionPropertyGetNode, @Cached.Shared(value="isCallable") @Cached IsCallableNode isCallableNode, @Cached.Shared(value="call") @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callNode, @Cached.Shared(value="importValue") @Cached JSForeignToJSTypeNode importValueNode) throws UnknownIdentifierException, UnsupportedMessageException {
        Object function = functionPropertyGetNode.getValueOrDefault(receiver, null);
        if (function == null) {
            throw UnknownIdentifierException.create((String)cachedName);
        }
        if (isCallableNode.executeBoolean(function)) {
            return callNode.executeCall(JSArguments.create(receiver, function, JSInteropInvokeNode.prepare(arguments, importValueNode)));
        }
        throw UnsupportedMessageException.create();
    }

    @Specialization(replaces={"doCached"})
    Object doUncached(DynamicObject receiver, String name, Object[] arguments, @CachedLanguage TruffleLanguage.LanguageReference<JavaScriptLanguage> languageRef, @Cached(value="create(languageRef.get().getJSContext())", uncached="getUncachedRead()") ReadElementNode readNode, @Cached.Shared(value="isCallable") @Cached IsCallableNode isCallableNode, @Cached.Shared(value="call") @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callNode, @Cached.Shared(value="importValue") @Cached JSForeignToJSTypeNode importValueNode) throws UnknownIdentifierException, UnsupportedMessageException {
        Object function = readNode == null ? JSObject.getOrDefault(receiver, name, (Object)receiver, null, JSClassProfile.getUncached()) : readNode.executeWithTargetAndIndexOrDefault(receiver, name, null);
        if (function == null) {
            throw UnknownIdentifierException.create((String)name);
        }
        if (isCallableNode.executeBoolean(function)) {
            Object[] preparedArgs = JSInteropInvokeNode.prepare(arguments, importValueNode);
            if (callNode == null) {
                return JSRuntime.call(function, receiver, preparedArgs);
            }
            return callNode.executeCall(JSArguments.create(receiver, function, preparedArgs));
        }
        throw UnsupportedMessageException.create();
    }

    PropertyGetNode createGetProperty(String name, TruffleLanguage.LanguageReference<JavaScriptLanguage> languageRef) {
        return PropertyGetNode.create(name, false, ((JavaScriptLanguage)languageRef.get()).getJSContext());
    }

    static ReadElementNode getUncachedRead() {
        return null;
    }
}

