/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import java.io.IOException;
import java.util.Map;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.DetectedProfileActivator;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class FileProfileActivator
extends DetectedProfileActivator {
    protected boolean canDetectActivation(Profile profile) {
        return profile.getActivation() != null && profile.getActivation().getFile() != null;
    }

    public boolean isActive(Profile profile) {
        Activation activation = profile.getActivation();
        ActivationFile actFile = activation.getFile();
        if (actFile != null) {
            String fileString = actFile.getExists();
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            try {
                interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
            }
            catch (IOException e) {
                // empty catch block
            }
            interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)System.getProperties()));
            if (StringUtils.isNotEmpty((String)fileString)) {
                try {
                    fileString = interpolator.interpolate(fileString, "");
                }
                catch (InterpolationException e) {
                    this.getLogger().debug("Failed to interpolate path in file profile activator: " + fileString, (Throwable)e);
                }
                fileString = StringUtils.replace((String)fileString, (String)"\\", (String)"/");
                return FileUtils.fileExists((String)fileString);
            }
            fileString = actFile.getMissing();
            if (StringUtils.isNotEmpty((String)fileString)) {
                try {
                    fileString = interpolator.interpolate(fileString, "");
                }
                catch (InterpolationException e) {
                    this.getLogger().debug("Failed to interpolate path in file profile activator: " + fileString, (Throwable)e);
                }
                fileString = StringUtils.replace((String)fileString, (String)"\\", (String)"/");
                return !FileUtils.fileExists((String)fileString);
            }
        }
        return false;
    }
}

